/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.dimension.bumpToOverworld;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.AetherMod;
import teamport.aether.world.AetherDimension;
import turniplabs.halplibe.helper.EnvironmentHelper;

@Mixin(value={Player.class}, remap=false)
public abstract class SPBumpToOverworldMixin
extends Mob {
    @Shadow
    public int dimension;

    public SPBumpToOverworldMixin(@Nullable World world) {
        super(world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        assert (this.world != null);
        if (this.dimension == AetherDimension.AETHER.id && this.y < (double)(this.world.worldType.getMinY() - 10) && EnvironmentHelper.isSinglePlayer()) {
            Minecraft mc = Minecraft.getMinecraft();
            AetherMod.LOGGER.info(String.format("Sending %s to overworld", this.getDisplayName()));
            CompoundTag passengerNBT = null;
            CompoundTag vehicleNBT = null;
            if (this.getPassenger() != null) {
                passengerNBT = new CompoundTag();
                Entity p = this.getPassenger();
                this.ejectRider();
                p.save(passengerNBT);
                p.remove();
            }
            if (this.isPassenger() && this.vehicle != null) {
                vehicleNBT = new CompoundTag();
                ((Entity)this.vehicle).save(vehicleNBT);
                this.vehicle.ejectRider();
            }
            mc.currentWorld.setEntityDead((Entity)this);
            mc.thePlayer.removed = false;
            float scale = Dimension.getCoordScale((Dimension)AetherDimension.AETHER, (Dimension)Dimension.OVERWORLD);
            this.moveTo(this.x *= (double)scale, 270.0, this.z *= (double)scale, this.yRot, this.xRot);
            if (this.isAlive()) {
                mc.currentWorld.updateEntityWithOptionalForce((Entity)this, false);
            }
            WorldClient newWorld = new WorldClient((World)mc.currentWorld, Dimension.OVERWORLD);
            mc.changeWorld(newWorld, "Leaving " + AetherDimension.AETHER.getTranslatedName(), (Player)Player.class.cast((Object)this));
            this.world = newWorld;
            this.dimension = Dimension.OVERWORLD.id;
            if (this.isAlive()) {
                mc.currentWorld.updateEntityWithOptionalForce((Entity)this, false);
            }
            if (passengerNBT != null) {
                Entity p = EntityDispatcher.createEntityFromNBT((CompoundTag)passengerNBT, (World)mc.currentWorld);
                p.load(passengerNBT);
                p.moveTo(this.x, this.y, this.z, 0.0f, 0.0f);
                mc.currentWorld.entityJoinedWorld(p);
                p.startRiding((IVehicle)this);
            }
            if (vehicleNBT != null) {
                Entity v = EntityDispatcher.createEntityFromNBT((CompoundTag)vehicleNBT, (World)mc.currentWorld);
                v.load(vehicleNBT);
                v.moveTo(this.x, this.y, this.z, 0.0f, 0.0f);
                mc.currentWorld.entityJoinedWorld(v);
                this.startRiding((IVehicle)v);
            }
        }
    }
}

