/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.entity;

import net.minecraft.core.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class}, remap=false)
public class EntityMixin {
    @Shadow
    public double y;
    @Unique
    public double prevY;
    @Unique
    public double deltaY;

    public EntityMixin() {
        this.prevY = this.y - 0.5;
    }

    @Inject(method={"baseTick()V"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        this.deltaY = this.y - this.prevY;
        this.prevY = this.y - 0.5;
    }

    @ModifyArg(method={"move(DDD)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/util/helper/MathHelper;floor(D)I", ordinal=5), index=0)
    public double extendBlockRange(double originalY) {
        return originalY + this.deltaY;
    }
}

