/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.fix;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import teamport.aether.AetherMod;

@Mixin(value={World.class}, remap=false, priority=0)
public abstract class WorldGetCubesMixin {
    @Shadow
    @Nullable
    public abstract Block<?> getBlock(int var1, int var2, int var3);

    @Unique
    public boolean isBrokenAABB(AABB aabb) {
        double diffX = Math.abs(aabb.maxX - aabb.minX);
        double diffY = Math.abs(aabb.maxY - aabb.minY);
        double diffZ = Math.abs(aabb.maxZ - aabb.minZ);
        return diffX > 1000000.0 || diffY > 1000000.0 || diffZ > 1000000.0 || Double.isNaN(diffX) || Double.isNaN(diffY) || Double.isNaN(diffZ);
    }

    @Unique
    public void preventStupidShit(Entity entity, AABB aabb, CallbackInfoReturnable<List<Entity>> cir) {
        if (this.isBrokenAABB(aabb)) {
            if (entity != null) {
                AetherMod.LOGGER.error("{} is moving too fast. Entity at {} {} {} with speed {}! Please send this to a developer!", new Object[]{Entity.getNameFromEntity((Entity)entity, (boolean)true), entity.x, entity.y, entity.z, Math.sqrt(entity.xd * entity.xd + entity.yd * entity.yd + entity.zd * entity.zd)});
                Block<?> block = this.getBlock((int)Math.round(entity.x), (int)Math.round(entity.y - 1.0), (int)Math.round(entity.z));
                String name = block == null ? "air" : block.getLanguageKey(0);
                AetherMod.LOGGER.error("Currently standing on: {} at ", (Object)name);
                AetherMod.LOGGER.error("Please send this log to a BWA developer!");
                Thread.dumpStack();
                entity.absMoveTo(0.0, 255.0, 0.0, 0.0f, 0.0f);
                entity.xo = 0.0;
                entity.yo = 0.0;
                entity.zo = 0.0;
            } else {
                AetherMod.LOGGER.error("Something is moving too fast! Please send this to a developer!");
                Thread.dumpStack();
            }
            cir.setReturnValue(new ArrayList());
            cir.cancel();
        }
    }

    @Inject(method={"getEntitiesWithinAABB"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends Entity> void getEntitiesWithinAABB(Class<T> ofClass, AABB aabb, CallbackInfoReturnable<List<Entity>> cir) {
        this.preventStupidShit(null, aabb, cir);
    }

    @Inject(method={"getEntitiesWithinAABBExcludingEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void getEntitiesWithinAABBExcludingEntity(Entity entity, AABB aabb, CallbackInfoReturnable<List<Entity>> cir) {
        this.preventStupidShit(entity, aabb, cir);
    }

    @Inject(method={"getCubes"}, at={@At(value="HEAD")}, cancellable=true)
    public void getCubes(Entity entity, AABB aabb, CallbackInfoReturnable<List<AABB>> cir) {
        if (this.isBrokenAABB(aabb)) {
            AetherMod.LOGGER.error("{} is moving too fast!! Please send this to a developer!", (Object)Entity.getNameFromEntity((Entity)entity, (boolean)true));
            Thread.dumpStack();
            entity.absMoveTo(0.0, 255.0, 0.0, 0.0f, 0.0f);
            entity.xo = 0.0;
            entity.yo = 0.0;
            entity.zo = 0.0;
            cir.setReturnValue(new ArrayList());
            cir.cancel();
        }
    }
}

