/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.player;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.entity.boss.AetherBossList;
import teamport.aether.entity.boss.EnemyBoss;
import teamport.aether.net.message.BossListNetworkMessage;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

@Mixin(value={Player.class}, remap=false)
public abstract class PlayerBossListMixin
extends Mob
implements AetherBossList {
    @Unique
    List<Mob> aether$bossList = new ArrayList<Mob>();

    public PlayerBossListMixin(@Nullable World world) {
        super(world);
    }

    @Override
    public List<Mob> aether$getBossList() {
        ArrayList<Mob> _bosses = new ArrayList<Mob>(this.aether$bossList);
        for (Mob boss : this.aether$bossList) {
            if ((!(boss instanceof EnemyBoss) || ((EnemyBoss)boss).canFight()) && boss.isAlive() && boss.world.dimension == this.world.dimension && !(boss.distanceTo((Entity)this) > 80.0f)) continue;
            _bosses.remove(boss);
        }
        this.aether$bossList = _bosses;
        return this.aether$bossList;
    }

    @Override
    public void aether$TryAddBossList(Mob mob) {
        if (!this.aether$bossList.contains(mob)) {
            this.aether$bossList.add(mob);
            if (EnvironmentHelper.isServerEnvironment()) {
                NetworkHandler.sendToPlayer((Player)((Player)Player.class.cast(this)), (NetworkMessage)new BossListNetworkMessage(BossListNetworkMessage.Type.ADD, (Entity)mob));
            }
        }
    }

    @Override
    public void aether$clearBossList() {
        this.aether$bossList.clear();
        if (EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToPlayer((Player)((Player)Player.class.cast(this)), (NetworkMessage)BossListNetworkMessage.clear());
        }
    }

    @Override
    public void aether$removeFromBossList(Mob mob) {
        this.aether$bossList.remove(mob);
        if (EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToPlayer((Player)((Player)Player.class.cast(this)), (NetworkMessage)new BossListNetworkMessage(BossListNetworkMessage.Type.REMOVE, (Entity)mob));
        }
    }

    @Inject(method={"attackTargetEntityWithCurrentItem"}, at={@At(value="HEAD")})
    public void attackTargetEntityWithCurrentItem(Entity entity, CallbackInfo ci) {
        if (entity instanceof EnemyBoss && entity instanceof Mob && !this.aether$bossList.contains(entity)) {
            this.aether$TryAddBossList((Mob)entity);
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    public void onDeath(CallbackInfo ci) {
        this.aether$bossList.clear();
    }
}

