/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.noise;

import java.util.Random;

public class Worley {
    public static int[][] offsets = new int[][]{{-1, 1}, {0, 1}, {1, 1}, {-1, 0}, {0, 0}, {1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    public static int bound = 0;

    public static int isSeed(int x, int z, int gridSize, int seed, int values, int padding) {
        int cellX = (int)Math.floor((double)x / (double)gridSize);
        int cellZ = (int)Math.floor((double)z / (double)gridSize);
        int s = Worley.mix(cellX, cellZ, seed);
        Random cellSeed = new Random(s);
        int relX = padding + cellSeed.nextInt(gridSize - padding * 2);
        int relZ = padding + cellSeed.nextInt(gridSize - padding * 2);
        int distX = cellX * gridSize + relX - x;
        int distZ = cellZ * gridSize + relZ - z;
        return distX == 0 && distZ == 0 ? cellSeed.nextInt(values) : -1;
    }

    public static float sampleAt(int x, int z, int gridSize, int seed) {
        int cellX = (int)Math.floor((double)x / (double)gridSize);
        int cellZ = (int)Math.floor((double)z / (double)gridSize);
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < 9; ++i) {
            min = Math.min(min, Worley.distanceFrom(x, z, cellX + offsets[i][0], cellZ + offsets[i][1], gridSize, seed));
        }
        return min;
    }

    public static float distanceFrom(int x, int z, int cellX, int cellZ, int gridSize, int seed) {
        int s = Worley.mix(cellX, cellZ, seed);
        Random cellSeed = new Random(s);
        int relX = bound + cellSeed.nextInt(gridSize - bound * 2);
        int relZ = bound + cellSeed.nextInt(gridSize - bound * 2);
        int distX = cellX * gridSize + relX - x;
        int distZ = cellZ * gridSize + relZ - z;
        return distX * distX + distZ * distZ;
    }

    public static int mix(int a, int b, int c) {
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

