/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.bronzeLegacy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.boss.slider.MobBossSlider;
import teamport.aether.helper.Pair;
import teamport.aether.items.AetherItems;
import teamport.aether.world.feature.chest.WorldFeatureAetherBronzeChest;
import teamport.aether.world.feature.dungeon.bronze.WorldFeatureAetherBronzeDungeon;
import teamport.aether.world.feature.dungeon.bronzeLegacy.DungeonLogicBronzeDungeonLegacy;
import teamport.aether.world.feature.util.BlockPallet;
import teamport.aether.world.feature.util.WorldFeatureBlock;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;
import teamport.aether.world.feature.util.map.WorldFeatureMap;

public class WorldFeatureAetherBronzeDungeonLegacy
extends WorldFeatureMap<DungeonLogicBronzeDungeonLegacy> {
    public int ROOM_COUNT_MAX = 10;
    public static final int TUNNEL_HEIGHT = 8;
    public static final int TUNNEL_WIDTH = 6;
    public int roomCount = 0;
    public WorldFeatureComponent hallway;
    public World world;
    public Random random;
    protected DungeonLogicBronzeDungeonLegacy logic;
    public static final BlockPallet carvedHolystone = new BlockPallet();
    public static final BlockPallet lockedCarvedHolystone = new BlockPallet();
    public static final BlockPallet holystone = new BlockPallet();
    public static final BlockPallet chestsOrMimic = new BlockPallet();
    public static final WeightedRandomBag<WeightedRandomLootObject> ARMOR;
    public static final WeightedRandomBag<WeightedRandomLootObject> JUNK;
    public static final WeightedRandomBag<WeightedRandomLootObject> AMMO;
    public static final WeightedRandomBag<WeightedRandomLootObject> GADGET;
    public static final WeightedRandomBag<WeightedRandomLootObject> FOOD;
    public static final WeightedRandomBag<WeightedRandomLootObject> TREASURE;

    @Override
    public boolean place(World world, Random random, int i, int j, int k) {
        if (!this.canPlace(world, i, j, k)) {
            return false;
        }
        this.registerAndGenerate(world, (world.getRandomSeed() ^ 0xD9L) + random.nextLong(), i + 8, j + 2, k + 8);
        return true;
    }

    @Override
    public boolean canPlace(World world, int x, int y, int z) {
        this.world = world;
        return this.canPlace(x, y, z);
    }

    @Override
    protected Class<DungeonLogicBronzeDungeonLegacy> getAppliedClass() {
        return DungeonLogicBronzeDungeonLegacy.class;
    }

    @Override
    public boolean generate(DungeonLogicBronzeDungeonLegacy logic, World world, long seed, int x, int y, int z) {
        this.world = world;
        this.random = new Random(seed);
        this.hallway = new WorldFeatureComponent();
        if (this.isBoxEmpty(x, y, z, Direction.EAST, 16, Direction.UP, 12, Direction.SOUTH, 16, 0.0f)) {
            return false;
        }
        this.createBossAndTreasure(x, y, z, x + 7 + this.random.nextInt(2), y - 1, z + 7 + this.random.nextInt(2));
        int x2 = x + 20;
        int z2 = z + 2;
        if (this.isBoxEmpty(x2, y, z2, Direction.EAST, 12, Direction.UP, 12, Direction.SOUTH, 12)) {
            this.addSquareTube(holystone, x2 - 5, y, z2 + 3, 6, 6, 6);
            return true;
        }
        this.makeAnotherRoom(world, this.random, y, x2, z2);
        this.findNextRoom(x2, y, z2);
        this.placeComponent(this.hallway);
        return true;
    }

    private void placeComponent(WorldFeatureComponent rooms) {
        for (WorldFeatureBlock wfblock : rooms.blockList) {
            if (!this.canReplace(wfblock)) continue;
            wfblock.place(this.world);
        }
    }

    private boolean canReplace(WorldFeatureBlock wfblock) {
        Material blockMaterial;
        Block block = this.world.getBlock(wfblock.x, wfblock.y, wfblock.z);
        int blockID = block == null ? 0 : block.id();
        Material material = blockMaterial = blockID == 0 ? Material.air : block.getMaterial();
        if (blockID == AetherBlocks.CHEST_MIMIC_SKYROOT.id() || blockID == AetherBlocks.CHEST_PLANKS_SKYROOT.id()) {
            this.world.removeBlockTileEntity(wfblock.x, wfblock.y, wfblock.z);
            return true;
        }
        return BlockTags.CAVES_CUT_THROUGH.appliesTo((ITaggable)block) || blockMaterial == Material.grass || blockMaterial == Material.dirt || blockMaterial == Material.marble || blockMaterial == Material.moss || blockMaterial.isStone() || blockMaterial.isLiquid();
    }

    private boolean findNextRoom(int x, int y, int z) {
        int tries = 3;
        ArrayList<Direction> dirList = new ArrayList<Direction>(Arrays.asList(Direction.horizontalDirections));
        int index = this.random.nextInt(dirList.size() - 1);
        boolean finished = true;
        while (finished && tries-- > 0) {
            finished = this.placeNextRoom(x, y, z, dirList.get(index));
            index = this.random.nextInt(dirList.size() - 1);
            dirList.remove(index);
        }
        return !finished;
    }

    private boolean placeNextRoom(int finalX, int finalY, int finalZ, Direction dir) {
        if (this.roomCount++ > this.ROOM_COUNT_MAX) {
            return false;
        }
        int x = finalX + dir.getOffsetX() * 16;
        int y = finalY + dir.getOffsetY() * 16;
        int z = finalZ + dir.getOffsetZ() * 16;
        if (this.random.nextInt(5) == 0) {
            if (this.canPlace(x, y, z)) {
                return true;
            }
            WorldFeatureComponent rooms = new WorldFeatureComponent();
            rooms.add(WorldFeatureComponent.drawShell(this.random, carvedHolystone, Direction.EAST, 12, Direction.UP, 12, Direction.SOUTH, 12, x, y, z, true));
            rooms.add(WorldFeatureComponent.drawVolume(0, 0, Direction.EAST, 10, Direction.UP, 10, Direction.SOUTH, 10, x + 1, y + 1, z + 1, true));
            this.placeComponent(rooms);
            WorldFeatureComponent.drawPlane(this.random, carvedHolystone, Direction.SOUTH, 4, Direction.EAST, 4, x + 4, y + 1, z + 4, true).place(this.world);
            this.placeNextRoom(finalX, finalY - 15, finalZ, dir);
            this.hallway.add(WorldFeatureComponent.drawVolume(0, 0, Direction.SOUTH, 2, Direction.DOWN, 6, Direction.EAST, 2, x + 5, y + 1, z + 5, true));
        } else {
            if (this.canPlace(x, y, z)) {
                return true;
            }
            this.placeChestRoom(x, y, z);
        }
        if (this.canPlace(x, y, z)) {
            return true;
        }
        this.placeChestRoom(x, y, z);
        this.generateTunnel(finalX, finalY, finalZ, dir);
        return this.findNextRoom(x, y, z);
    }

    private void generateTunnel(int x, int y, int z, Direction dir) {
        switch (dir) {
            case NORTH: {
                this.hallway.add(WorldFeatureComponent.drawVolume(1, 0, dir, 6, Direction.UP, 6, dir.rotate(1), 4, x + 4, y + 1, z, true));
                break;
            }
            case EAST: {
                this.hallway.add(WorldFeatureComponent.drawVolume(2, 0, dir, 6, Direction.UP, 6, dir.rotate(1), 4, x + 11, y + 1, z + 4, true));
                break;
            }
            case SOUTH: {
                this.hallway.add(WorldFeatureComponent.drawVolume(3, 0, dir, 6, Direction.UP, 6, dir.rotate(1), 4, x + 8, y + 1, z + 11, true));
                break;
            }
            case WEST: {
                this.hallway.add(WorldFeatureComponent.drawVolume(4, 0, dir, 6, Direction.UP, 6, dir.rotate(1), 4, x, y + 1, z + 8, true));
                break;
            }
        }
    }

    private void placeChestRoom(int x, int y, int z) {
        WorldFeatureComponent rooms = new WorldFeatureComponent();
        rooms.add(WorldFeatureComponent.drawShell(this.random, carvedHolystone, Direction.EAST, 12, Direction.UP, 12, Direction.SOUTH, 12, x, y, z, true));
        rooms.add(WorldFeatureComponent.drawVolume(0, 0, Direction.EAST, 10, Direction.UP, 10, Direction.SOUTH, 10, x + 1, y + 1, z + 1, true));
        this.placeComponent(rooms);
        WorldFeatureComponent chests = new WorldFeatureComponent();
        WorldFeatureComponent.drawPlane(this.random, carvedHolystone, Direction.SOUTH, 4, Direction.EAST, 4, x + 4, y + 1, z + 4, true).place(this.world);
        chests.add(WorldFeatureComponent.drawPlane(this.random, chestsOrMimic, Direction.SOUTH, 2, Direction.EAST, 2, x + 5, y + 2, z + 5, true));
        chests.place(this.world);
        for (WorldFeatureBlock chest : chests.blockList) {
            WorldFeatureComponent.populateChest(this.world, this.random, chest, WorldFeatureAetherBronzeDungeon::generateLoot);
        }
    }

    private boolean canPlace(int x, int y, int z) {
        if (y <= 11) {
            return false;
        }
        return this.isBoxEmpty(x, y, z, Direction.EAST, 12, Direction.UP, 12, Direction.SOUTH, 12);
    }

    private boolean isBoxEmpty(int startX, int startY, int startZ, Direction direction1, int length1, Direction direction2, int length2, Direction direction3, int length3) {
        return this.isBoxEmpty(startX, startY, startZ, direction1, length1, direction2, length2, direction3, length3, 0.35f);
    }

    private boolean isBoxEmpty(int startX, int startY, int startZ, Direction direction1, int length1, Direction direction2, int length2, Direction direction3, int length3, float percent) {
        int volume = 0;
        for (int i = 0; i < length3; ++i) {
            int x3 = startX + direction3.getOffsetX() * i;
            int y3 = startY + direction3.getOffsetY() * i;
            int z3 = startZ + direction3.getOffsetZ() * i;
            for (int j = 0; j < length2; ++j) {
                int blockX = x3 + direction2.getOffsetX() * j;
                int blockY = y3 + direction2.getOffsetY() * j;
                int blockZ = z3 + direction2.getOffsetZ() * j;
                for (int k = 0; k < length1; ++k) {
                    if (this.world.getBlockId(blockX, blockY, blockZ) == 0) {
                        ++volume;
                    }
                    blockX += direction1.getOffsetX();
                    blockY += direction1.getOffsetY();
                    blockZ += direction1.getOffsetZ();
                }
            }
        }
        return (float)volume > (float)(length1 * length2 * length3) * percent;
    }

    private void addSquareTube(BlockPallet pallet, int x, int y, int z, int lengthX, int lengthY, int lengthZ) {
        for (int sx = x; sx < x + lengthX; ++sx) {
            for (int sy = y; sy < y + lengthY; ++sy) {
                for (int sz = z; sz < z + lengthZ; ++sz) {
                    this.world.setBlockAndMetadataWithNotify(sx, sy, sz, 0, 0);
                }
            }
        }
    }

    public void createBossAndTreasure(int x, int y, int z, int x2, int y2, int z2) {
        WorldFeatureComponent rooms = new WorldFeatureComponent();
        rooms.add(WorldFeatureComponent.drawShell(this.random, lockedCarvedHolystone, Direction.EAST, 16, Direction.UP, 12, Direction.SOUTH, 16, x, y, z, true));
        rooms.add(WorldFeatureComponent.drawVolume(0, 0, Direction.EAST, 14, Direction.UP, 10, Direction.SOUTH, 14, x + 1, y + 1, z + 1, true));
        rooms.add(WorldFeatureComponent.drawShell(this.random, lockedCarvedHolystone, Direction.EAST, 4, Direction.UP, 4, Direction.SOUTH, 4, x + 6, y - 2, z + 6, true));
        rooms.add(WorldFeatureComponent.drawVolume(0, 0, Direction.EAST, 2, Direction.UP, 2, Direction.SOUTH, 2, x + 7, y - 1, z + 7, true));
        rooms.place(this.world);
        this.logic.setClearArea(new Pair<WorldFeaturePoint, WorldFeaturePoint>(new WorldFeaturePoint(x, y - 2, z), new WorldFeaturePoint(x + 16, y + 14, z + 16)));
        ArrayList<WorldFeaturePoint> treasureDoor = new ArrayList<WorldFeaturePoint>();
        treasureDoor.add(new WorldFeaturePoint(x + 7, y + 1, z + 7));
        treasureDoor.add(new WorldFeaturePoint(x + 8, y + 1, z + 7));
        treasureDoor.add(new WorldFeaturePoint(x + 7, y + 1, z + 8));
        treasureDoor.add(new WorldFeaturePoint(x + 8, y + 1, z + 8));
        this.logic.setTreasureDoor(treasureDoor);
        WorldFeatureAetherBronzeChest.bronzeChest().place(this.world, this.random, x2, y2, z2);
        MobBossSlider boss = new MobBossSlider(this.world);
        boss.moveTo(x + 8, y + 2, z + 8, 0.0f, 0.0f);
        boss.setReturnPoint(new WorldFeaturePoint(x + 8, y + 2, z + 8));
        boss.setTrophy(AetherItems.KEY_BRONZE.getDefaultStack());
        boss.setDungeonID(this.logic.id);
        this.world.entityJoinedWorld((Entity)boss);
    }

    private void makeAnotherRoom(World world, Random random, int y, int x2, int z2) {
        WorldFeatureComponent rooms = new WorldFeatureComponent();
        rooms.add(WorldFeatureComponent.drawShell(random, carvedHolystone, Direction.EAST, 12, Direction.UP, 12, Direction.SOUTH, 12, x2, y, z2, true));
        rooms.add(WorldFeatureComponent.drawVolume(0, 0, Direction.EAST, 10, Direction.UP, 10, Direction.SOUTH, 10, x2 + 1, y + 1, z2 + 1, true));
        this.placeComponent(rooms);
        this.addSquareTube(holystone, x2 - 5, y, z2 + 3, 6, 6, 6);
    }

    static {
        carvedHolystone.addEntry(AetherBlocks.CARVED_STONE.id(), 85.0);
        carvedHolystone.addEntry(AetherBlocks.CARVED_STONE_LIGHT.id(), 5.0);
        carvedHolystone.addEntry(AetherBlocks.CARVED_STONE_TRAPPED.id(), 10.0);
        lockedCarvedHolystone.addEntry(AetherBlocks.CARVED_STONE_LOCKED.id(), 90.0);
        lockedCarvedHolystone.addEntry(AetherBlocks.CARVED_STONE_LIGHT_LOCKED.id(), 10.0);
        holystone.addEntry(AetherBlocks.COBBLE_HOLYSTONE.id(), 90.0);
        holystone.addEntry(AetherBlocks.COBBLE_HOLYSTONE_MOSSY.id(), 10.0);
        chestsOrMimic.addEntry(0, 1.0);
        chestsOrMimic.addEntry(AetherBlocks.CHEST_MIMIC_SKYROOT.id(), 1.0);
        chestsOrMimic.addEntry(AetherBlocks.CHEST_PLANKS_SKYROOT.id(), 1.0);
        ARMOR = new WeightedRandomBag();
        JUNK = new WeightedRandomBag();
        AMMO = new WeightedRandomBag();
        GADGET = new WeightedRandomBag();
        FOOD = new WeightedRandomBag();
        JUNK.addEntry((Object)new WeightedRandomLootObject(null), 8.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMBROSIUM.getDefaultStack(), 1, 6), 4.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.TORCH_AMBROSIUM.getDefaultStack(), 1, 4), 4.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.HOLYSTONE.getDefaultStack(), 4, 12), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.HOLYSTONE_MOSSY.getDefaultStack(), 4, 12), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.ICESTONE.getDefaultStack(), 4, 12), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.CARVED_STONE_LIGHT.getDefaultStack(), 4, 12), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.CARVED_STONE.getDefaultStack(), 4, 12), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherItems.BUCKET_SKYROOT.getDefaultStack()), 1.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherItems.ZANITE.getDefaultStack(), 1, 4), 1.0);
        FOOD.addEntry((Object)new WeightedRandomLootObject(null), 8.0);
        FOOD.addEntry((Object)new WeightedRandomLootObject(AetherItems.FOOD_HEALING_STONE.getDefaultStack(), 1, 4), 4.0);
        FOOD.addEntry((Object)new WeightedRandomLootObject(AetherItems.FOOD_GUMMY_BLUE.getDefaultStack(), 1, 4), 2.0);
        FOOD.addEntry((Object)new WeightedRandomLootObject(AetherItems.FOOD_GUMMY_GOLD.getDefaultStack(), 1, 2), 1.0);
        int minTool = AetherItems.TOOL_PICKAXE_HOLYSTONE.getMaxDamage() / 2;
        int maxTool = AetherItems.TOOL_PICKAXE_HOLYSTONE.getMaxDamage();
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_PICKAXE_HOLYSTONE.getDefaultStack()).setRandomMetadata(minTool, maxTool), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_AXE_HOLYSTONE.getDefaultStack()).setRandomMetadata(minTool, maxTool), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SWORD_HOLYSTONE.getDefaultStack()).setRandomMetadata(minTool, maxTool), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SHOVEL_HOLYSTONE.getDefaultStack()).setRandomMetadata(minTool, maxTool), 1.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(null), 8.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMMO_DART_GOLDEN.getDefaultStack(), 2, 6), 4.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMMO_DART_POISON.getDefaultStack(), 2, 6), 2.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMMO_DART_ENCHANTED.getDefaultStack(), 2, 6), 1.0);
        GADGET.addEntry((Object)new WeightedRandomLootObject(null), 4.0);
        GADGET.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_TALISMAN_LEATHER.getDefaultStack()), 3.0);
        GADGET.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_TALISMAN_ZANITE.getDefaultStack()), 1.0);
        TREASURE = new WeightedRandomBag();
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.RECORD_MORNING.getDefaultStack()), 1.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_HAMMER_NOTCH.getDefaultStack()), 10.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_KNIFE_LIGHTNING.getDefaultStack(), 1, 16), 10.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SWORD_LIGHTNING.getDefaultStack()), 10.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_TALISMAN_REGEN.getDefaultStack()), 10.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_CAPE_SWET.getDefaultStack()), 10.0);
    }
}

