/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.util.map;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.World;
import teamport.aether.AetherMod;
import teamport.aether.compat.AetherPlugin;
import teamport.aether.net.message.AetherDungeonMapUpdateNetworkMessage;
import teamport.aether.world.feature.dungeon.bronze.DungeonLogicBronzeDungeon;
import teamport.aether.world.feature.dungeon.bronzeLegacy.DungeonLogicBronzeDungeonLegacy;
import teamport.aether.world.feature.dungeon.gold.DungeonLogicGoldDungeon;
import teamport.aether.world.feature.dungeon.silver.DungeonLogicSilverDungeon;
import teamport.aether.world.feature.util.WorldFeaturePoint;
import teamport.aether.world.feature.util.map.DungeonLogic;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class DungeonMap {
    protected static final HashMap<Integer, DungeonLogic> dungeonMap = new HashMap();
    private static final HashMap<String, Class<? extends DungeonLogic>> KEY_TYPE_MAP = new HashMap();
    private static final HashMap<Class<? extends DungeonLogic>, String> TYPE_KEY_MAP = new HashMap();
    protected static final List<DungeonLogic> entryListCache;
    protected static final int MP_LIST_UPDATE_COOLDOWN = 3000;
    protected static long lastListUpdateStamp;
    protected static final int ATTEMPT_GENERATE_COOLDOWN = 40;
    protected static int currGenerateCooldown;

    protected DungeonMap() {
    }

    public static void registerDungeonType(String key, Class<? extends DungeonLogic> type) {
        KEY_TYPE_MAP.put(key, type);
        TYPE_KEY_MAP.put(type, key);
    }

    public static CompoundTag save(CompoundTag data) {
        ListTag dungeons = new ListTag();
        dungeonMap.forEach((id, dungeon) -> {
            CompoundTag dungeonData = new CompoundTag();
            dungeon.save(dungeonData);
            dungeonData.putString("type", TYPE_KEY_MAP.get(dungeon.getClass()));
            dungeonData.putInt("dimensionID", dungeon.getDimensionID());
            dungeonData.putLong("seed", dungeon.seed);
            dungeonData.putInt("id", id.intValue());
            dungeons.addTag((Tag)dungeonData);
        });
        data.put("aether.dungeon", (Tag)dungeons);
        return data;
    }

    public static void load(CompoundTag data) {
        dungeonMap.clear();
        Tag dungeons = data.getTagOrDefault("aether.dungeon", null);
        if (dungeons instanceof ListTag) {
            ((ListTag)dungeons).forEach(tag -> {
                DungeonLogic dungeon = DungeonMap.loadDungeonFromNBT((CompoundTag)tag);
                if (dungeon != null) {
                    dungeonMap.put(dungeon.id, dungeon);
                }
            });
        } else if (dungeons instanceof CompoundTag) {
            CompoundTag compoundDungeons = (CompoundTag)dungeons;
            for (Tag tag2 : compoundDungeons.getValues()) {
                if (!(tag2 instanceof CompoundTag)) continue;
                ((CompoundTag)tag2).putInt("id", Integer.parseInt(tag2.getTagName()));
                DungeonLogic dungeon = DungeonMap.loadDungeonFromNBT((CompoundTag)tag2);
                if (dungeon == null) continue;
                dungeonMap.put(dungeon.id, dungeon);
            }
        }
    }

    public static DungeonLogic loadDungeonFromNBT(CompoundTag tag) {
        DungeonLogic dungeonEntry;
        String type = tag.getString("type");
        int dimensionID = tag.getInteger("dimensionID");
        long seed = tag.getLong("seed");
        int id = tag.getInteger("id");
        try {
            dungeonEntry = KEY_TYPE_MAP.get(type).getConstructor(Integer.TYPE, Integer.TYPE, Long.TYPE).newInstance(dimensionID, id, seed);
        }
        catch (Exception e) {
            AetherMod.LOGGER.error("Failed to load dungeon {} from map!", (Object)id);
            AetherMod.LOGGER.error("This world might be outdated or corrupted!");
            Thread.dumpStack();
            return null;
        }
        dungeonEntry.load(tag);
        return dungeonEntry;
    }

    public static Collection<DungeonLogic> getDungeonList() {
        if (EnvironmentHelper.isClientWorld()) {
            long time = System.currentTimeMillis();
            if (time - lastListUpdateStamp >= 3000L) {
                lastListUpdateStamp = time;
                NetworkHandler.sendToServer((NetworkMessage)new AetherDungeonMapUpdateNetworkMessage());
            }
            return entryListCache;
        }
        return dungeonMap.values();
    }

    public static ListTag serializeListFor(Player player) {
        ListTag resultTag = new ListTag();
        dungeonMap.values().stream().filter(Objects::nonNull).filter(d -> d.getPosition() != null).filter(d -> d.getPosition().distanceTo(WorldFeaturePoint.wfpoint((Entity)player)) < 300.0).forEach(d -> resultTag.addTag((Tag)d.save(new CompoundTag())));
        return resultTag;
    }

    public static void updateListCache(ListTag dungeons) {
        entryListCache.clear();
        dungeons.forEach(tag -> {
            DungeonLogic dungeon = DungeonMap.loadDungeonFromNBT((CompoundTag)tag);
            if (dungeon != null) {
                entryListCache.add(dungeon);
            }
        });
    }

    public static void runWithDungeon(Integer dungeonID, Consumer<DungeonLogic> func) {
        if (dungeonID == null) {
            return;
        }
        DungeonLogic dungeon = dungeonMap.get(dungeonID);
        if (dungeon == null) {
            return;
        }
        func.accept(dungeon);
    }

    protected static boolean chunkWithinRadius(Player player, int chunkX, int chunkZ) {
        int playerChunkX = Math.floorDiv((int)player.x, 16);
        int playerChunkZ = Math.floorDiv((int)player.z, 16);
        return chunkX >= playerChunkX - 16 && chunkX <= playerChunkX + 16 && chunkZ >= playerChunkZ - 16 && chunkZ <= playerChunkZ + 16;
    }

    public static void onWorldTick(World world) {
        if (--currGenerateCooldown <= 0) {
            for (Player player : world.players) {
                dungeonMap.values().stream().filter(Objects::nonNull).filter(d -> !d.hasGenerated).filter(d -> d.getDimensionID() == world.dimension.id).filter(d -> !d.hasGenerated).filter(d -> DungeonMap.chunkWithinRadius(player, Math.floorDiv(d.position.x, 16), Math.floorDiv(d.position.z, 16))).forEach(d -> d.generate(world));
            }
            currGenerateCooldown = 40;
        }
        for (DungeonLogic logic : dungeonMap.values()) {
            if (logic == null || logic.getDimensionID() != world.dimension.id) {
                return;
            }
            if (!logic.canTick(world)) continue;
            logic.onTick(world);
        }
    }

    public static DungeonLogic getDungeon(int id) {
        return dungeonMap.get(id);
    }

    public static boolean isEmpty() {
        return dungeonMap.isEmpty();
    }

    public static void remove(Integer id) {
        DungeonLogic dungeon = dungeonMap.get(id);
        if (dungeon == null) {
            AetherMod.LOGGER.error("Couldn't find dungeon of id {}", (Object)id);
            return;
        }
        DungeonMap.dungeonMap.get((Object)id).markedRemoved = true;
    }

    public static <T extends DungeonLogic> T register(Class<T> dungeonClass, World world, long seed, int x, int y, int z) {
        DungeonLogic dungeon;
        int id = dungeonMap.size();
        while (dungeonMap.get(id) != null) {
            ++id;
        }
        try {
            dungeon = (DungeonLogic)dungeonClass.getConstructor(Integer.TYPE, Integer.TYPE, Long.TYPE).newInstance(world.dimension.id, id, seed);
        }
        catch (Exception e) {
            AetherMod.LOGGER.error("Failed to register dungeon!");
            throw new RuntimeException(e);
        }
        dungeon.setPosition(new WorldFeaturePoint(x, y, z));
        dungeonMap.put(id, dungeon);
        return (T)dungeon;
    }

    static {
        DungeonMap.registerDungeonType("SUNSPIRIT", DungeonLogicGoldDungeon.class);
        DungeonMap.registerDungeonType("VALKYRIE", DungeonLogicSilverDungeon.class);
        DungeonMap.registerDungeonType("SLIDER", DungeonLogicBronzeDungeon.class);
        DungeonMap.registerDungeonType("SLIDER_LEGACY", DungeonLogicBronzeDungeonLegacy.class);
        DungeonMap.registerDungeonType("BASE", DungeonLogicBase.class);
        FabricLoader.getInstance().getEntrypointContainers("aether", AetherPlugin.class).forEach(plugin -> ((AetherPlugin)plugin.getEntrypoint()).registerDungeonType());
        entryListCache = new ArrayList<DungeonLogic>();
        lastListUpdateStamp = 0L;
        currGenerateCooldown = 0;
    }

    protected static class DungeonLogicBase
    extends DungeonLogic {
        public DungeonLogicBase(int dimensionID, int id, long seed) {
            super(dimensionID, id, seed);
        }

        @Override
        protected boolean placeDungeon(World world, Random random) {
            return false;
        }

        @Override
        protected boolean canPlaceDungeon(World world) {
            return false;
        }
    }
}

