/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.util.map;

import java.util.Random;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import teamport.aether.world.feature.util.map.DungeonLogic;
import teamport.aether.world.feature.util.map.DungeonMap;

public abstract class WorldFeatureMap<T extends DungeonLogic>
extends WorldFeature {
    public boolean place(World world, Random random, int i, int j, int k) {
        if (!this.canPlace(world, i, j, k)) {
            return false;
        }
        this.registerAndGenerate(world, (world.getRandomSeed() ^ 0xD9L) + random.nextLong(), i, j, k);
        return true;
    }

    public T registerAndGenerate(World world, long seed, int x, int y, int z) {
        T logic = this.register(world, seed, x, y, z);
        this.generate(logic, world, seed, x, y, z);
        return logic;
    }

    public T register(World world, long seed, int x, int y, int z) {
        return DungeonMap.register(this.getAppliedClass(), world, seed, x, y, z);
    }

    protected abstract Class<T> getAppliedClass();

    public abstract boolean canPlace(World var1, int var2, int var3, int var4);

    public abstract boolean generate(T var1, World var2, long var3, int var5, int var6, int var7);
}

