/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.attribute.type;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import sunsetsatellite.catalyst.effects.api.attribute.type.NumberAttribute;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.type.NumberModifier;

public final class FloatAttribute
extends NumberAttribute<Float> {
    public FloatAttribute(String key, Float defaultValue, Float minValue, Float maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    public FloatAttribute(String key, Float defaultValue) {
        super(key, defaultValue, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    @Override
    public Float calculate(IHasEffects target) {
        if (target.getContainer().getAttributes().contains(this)) {
            for (EffectStack effectStack : target.getContainer().getEffects()) {
                if (!effectStack.hasAttribute(this) || !effectStack.isActive()) continue;
                float value = ((Float)this.getBaseValue()).floatValue();
                List validModifiers = effectStack.getEffect().getModifiers().stream().filter(M -> M.attribute.getClass().isAssignableFrom(this.getClass())).map(M -> {
                    if (M instanceof NumberModifier) {
                        return (NumberModifier)M;
                    }
                    return null;
                }).filter(Objects::nonNull).sorted(Comparator.comparing(M -> M.type)).collect(Collectors.toList());
                for (NumberModifier modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            if (!(((Number)modifier.calculate(effectStack)).floatValue() > value)) break;
                            value = ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100.0f * ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100.0f * ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.calculate(effectStack)).floatValue();
                        }
                    }
                }
                return Float.valueOf(Math.min(((Float)this.maxValue).floatValue(), Math.max(value, ((Float)this.minValue).floatValue())));
            }
            return (Float)this.getBaseValue();
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }

    @Override
    public Float calculate(IHasEffects target, Float baseValue) {
        if (target.getContainer().getAttributes().contains(this)) {
            for (EffectStack effectStack : target.getContainer().getEffects()) {
                if (!effectStack.hasAttribute(this)) continue;
                float value = baseValue.floatValue();
                List validModifiers = effectStack.getEffect().getModifiers().stream().filter(M -> M.attribute.getClass().isAssignableFrom(this.getClass())).map(M -> {
                    if (M instanceof NumberModifier) {
                        return (NumberModifier)M;
                    }
                    return null;
                }).filter(Objects::nonNull).sorted(Comparator.comparing(M -> M.type)).collect(Collectors.toList());
                for (NumberModifier modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            if (!(((Number)modifier.calculate(effectStack)).floatValue() > value)) break;
                            value = ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100.0f * ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100.0f * ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.calculate(effectStack)).floatValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.calculate(effectStack)).floatValue();
                        }
                    }
                }
                return Float.valueOf(Math.min(((Float)this.maxValue).floatValue(), Math.max(value, ((Float)this.minValue).floatValue())));
            }
            return baseValue;
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }
}

