/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.helpers.ArgumentParser;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.Effects;

public class ArgumentParserEffect
extends ArgumentParser {
    private Effect effect;
    private static final SimpleCommandExceptionType INVALID_EFFECT = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("error.catalyst-effects.invalidEffect"));

    protected ArgumentParserEffect(StringReader reader) {
        super(reader);
    }

    private CompletableFuture<Suggestions> suggestItems(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsBuilder2 = suggestionsBuilder.createOffset(this.startPosition);
        consumer.accept(suggestionsBuilder2);
        return suggestionsBuilder.add(suggestionsBuilder2).buildFuture();
    }

    public Effect parse() throws CommandSyntaxException {
        this.startPosition = this.reader.getCursor();
        this.suggestions = this::suggestItems;
        this.parseEffect();
        if (this.effect == null) {
            throw INVALID_EFFECT.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.effect;
    }

    private void parseEffect() throws CommandSyntaxException {
        char peak;
        StringBuilder builder = new StringBuilder();
        while (this.reader.canRead() && (peak = this.reader.peek()) != '[' && peak != '{' && peak != ' ') {
            builder.append(this.reader.read());
        }
        String string = builder.toString();
        this.effect = (Effect)Effects.getInstance().getItem(string);
    }
}

