/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.mixin;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentHealthBar;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemFood;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.DyeColor;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.effect.options.EffectExtraHealthDisplayStyle;
import sunsetsatellite.catalyst.effects.api.effect.render.EffectRenderer;
import sunsetsatellite.catalyst.effects.api.effect.render.EffectRendererDispatcher;
import sunsetsatellite.catalyst.effects.api.effect.render.EffectRendererManager;
import sunsetsatellite.catalyst.effects.api.effect.render.heartContainer.HeartContainer;
import sunsetsatellite.catalyst.effects.api.effect.render.heartContainer.IHasCustomHeartContainer;
import sunsetsatellite.catalyst.effects.helper.HealthHelper;
import sunsetsatellite.catalyst.effects.interfaces.mixins.IKeybinds;

@Mixin(value={HudComponentHealthBar.class}, remap=false)
public abstract class HudComponentHealthBarMixin
extends HudComponentMovable {
    @Unique
    Random random = new Random();
    @Unique
    int iconWidth = 9;
    @Unique
    int iconHeight = 9;
    @Unique
    int spacing = 1;

    public HudComponentHealthBarMixin(String key, int xSize, int ySize, Layout layout) {
        super(key, xSize, ySize, layout);
    }

    @Unique
    int getRows(Player player) {
        return (int)Math.ceil((double)player.getMaxHealth() / 20.0);
    }

    public int getYSize(Minecraft mc) {
        EffectExtraHealthDisplayStyle extraHealthDisplay = (EffectExtraHealthDisplayStyle)((Object)((IKeybinds)mc.gameSettings).getExtraHealthDisplayStyle().value);
        if (extraHealthDisplay == EffectExtraHealthDisplayStyle.EXTRA_BARS) {
            return this.iconHeight * this.getRows((Player)mc.thePlayer) + this.spacing;
        }
        return super.getYSize(mc);
    }

    public int getAnchorY(ComponentAnchor anchor) {
        return (int)(anchor.yPosition * (float)this.getYSize(Minecraft.getMinecraft()));
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(Minecraft mc, HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick, CallbackInfo ci) {
        EffectRenderer<?> renderer;
        PlayerLocal player = mc.thePlayer;
        EffectStack stack = EffectRendererManager.resolveDominantHeartContainer(((IHasEffects)player).getContainer());
        if (stack == null && this.getRows((Player)player) == 1) {
            return;
        }
        HeartContainer heartContainer = null;
        ci.cancel();
        if (stack != null && (renderer = EffectRendererDispatcher.getRendererFor(stack.getEffect())) instanceof IHasCustomHeartContainer) {
            heartContainer = ((IHasCustomHeartContainer)((Object)renderer)).getCustomContainer((Player)player);
        }
        if (heartContainer == null) {
            heartContainer = new HeartContainer((Player)player);
        }
        int x = this.getLayout().getComponentX(mc, (HudComponent)this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, (HudComponent)this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        this.random.setSeed((long)hud.updateCounter * 312871L);
        EffectExtraHealthDisplayStyle extraHealthDisplay = (EffectExtraHealthDisplayStyle)((Object)((IKeybinds)mc.gameSettings).getExtraHealthDisplayStyle().value);
        if (extraHealthDisplay == EffectExtraHealthDisplayStyle.EXTRA_BARS || this.getRows((Player)player) == 1) {
            this.drawExtraBars(mc, hud, (Player)player, heartContainer, x, y);
        } else if (extraHealthDisplay == EffectExtraHealthDisplayStyle.MULTIPLIER) {
            this.drawNumberBar(mc, hud, (Player)player, heartContainer, x, y);
        }
    }

    @Unique
    private void drawNumberBar(Minecraft mc, HudIngame hud, Player player, HeartContainer heartContainer, int x, int y) {
        float playerHealthPercent = (float)player.getHealth() / (float)HealthHelper.getMaxHealth(player);
        int extraHearts = HealthHelper.getMaxHealth(player) / 2;
        int heartsToRender = 8;
        this.drawRow(mc, hud, player, heartContainer, 8, (int)(playerHealthPercent * 16.0f), x, y);
        hud.drawString(mc.font, String.format("+%s", extraHearts), x + 3 * this.spacing + 7 * this.iconWidth, y + (heartContainer.shouldShake() ? this.random.nextInt(2) : 0), DyeColor.WHITE.color.value);
    }

    @Unique
    public void drawExtraBars(Minecraft mc, HudIngame hud, Player player, HeartContainer heartContainer, int x, int y) {
        int health = player.getHealth();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(0.01 * (double)this.getRows(player)));
        for (int barCount = 0; barCount < this.getRows(player); ++barCount) {
            int totalHealth = HealthHelper.getMaxHealth(player);
            int healthInRow = Math.min(totalHealth - barCount * 20, 20);
            int heartsToRender = (healthInRow + 1) / 2;
            if (heartsToRender == 0) continue;
            int healthInCurrentRow = health - barCount * 20;
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-0.01 * (double)barCount));
            int rowY = y - this.iconHeight * barCount + this.getYSize(mc) - this.iconHeight - this.spacing;
            this.drawRow(mc, hud, player, heartContainer, heartsToRender, healthInCurrentRow, x, rowY);
        }
    }

    @Unique
    public void drawRow(Minecraft mc, HudIngame hud, Player player, HeartContainer heartContainer, int heartsToRender, int healthInCurrentRow, int x, int y) {
        HeartContainer.HeartGlyphVariant glyphVariant = player.getGamemode() == Gamemode.hardcore ? HeartContainer.HeartGlyphVariant.HARDCORE : HeartContainer.HeartGlyphVariant.NONE;
        for (int i = 0; i < heartsToRender; ++i) {
            int xHeart = x + i * 8;
            int yHeart = y;
            if (heartContainer.shouldShake()) {
                yHeart += this.random.nextInt(2);
            }
            int currentHeart = i * 2 + 1;
            heartContainer.drawHeart(glyphVariant, HeartContainer.HeartGlyphType.CONTAINER, xHeart, yHeart, hud);
            if (currentHeart < healthInCurrentRow) {
                heartContainer.drawHeart(glyphVariant, HeartContainer.HeartGlyphType.FULL, xHeart, yHeart, hud);
            }
            if (currentHeart == healthInCurrentRow) {
                heartContainer.drawHeart(glyphVariant, HeartContainer.HeartGlyphType.HALF, xHeart, yHeart, hud);
            }
            if (player.inventory.getCurrentItem() == null || !(player.inventory.getCurrentItem().getItem() instanceof ItemFood) || !((Boolean)mc.gameSettings.foodHealthRegenOverlay.value).booleanValue()) continue;
            int healing = ((ItemFood)player.inventory.getCurrentItem().getItem()).getHealAmount();
            if (currentHeart < healthInCurrentRow) continue;
            if (currentHeart == healthInCurrentRow) {
                heartContainer.drawHeart(HeartContainer.HeartGlyphVariant.PREVIEW, HeartContainer.HeartGlyphType.HALF_RIGHT, xHeart, yHeart, hud);
                continue;
            }
            if (currentHeart < healthInCurrentRow + healing) {
                heartContainer.drawHeart(HeartContainer.HeartGlyphVariant.PREVIEW, HeartContainer.HeartGlyphType.FULL, xHeart, yHeart, hud);
                continue;
            }
            if (currentHeart != healthInCurrentRow + healing) continue;
            heartContainer.drawHeart(HeartContainer.HeartGlyphVariant.PREVIEW, HeartContainer.HeartGlyphType.HALF, xHeart, yHeart, hud);
        }
    }
}

