/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.canvas;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasRootClient;
import sh.lem.ccholo.networking.S2CCanvasCaptureStatePacket;
import sh.lem.ccholo.networking.S2CCanvasInitPacket;
import sh.lem.ccholo.networking.S2CCanvasRemovePacket;
import sh.lem.ccholo.networking.S2CCanvasSetClipboardPacket;
import sh.lem.ccholo.networking.S2CCanvasUpdatePacket;
import sh.lem.ccholo.objects.BaseObject;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001dH\u0007\u00a8\u0006\u001e"}, d2={"Lsh/lem/ccholo/canvas/CanvasHandlerClient;", "", "<init>", "()V", "checkMainThread", "", "name", "", "onCanvasInitPacket", "", "msg", "Lsh/lem/ccholo/networking/S2CCanvasInitPacket;", "onCanvasInitPacket$CC_Holo", "onCanvasRemovePacket", "Lsh/lem/ccholo/networking/S2CCanvasRemovePacket;", "onCanvasRemovePacket$CC_Holo", "onCanvasUpdatePacket", "Lsh/lem/ccholo/networking/S2CCanvasUpdatePacket;", "onCanvasUpdatePacket$CC_Holo", "onCanvasCaptureStatePacket", "Lsh/lem/ccholo/networking/S2CCanvasCaptureStatePacket;", "onCanvasCaptureStatePacket$CC_Holo", "onCanvasSetClipboardPacket", "Lsh/lem/ccholo/networking/S2CCanvasSetClipboardPacket;", "onCanvasSetClipboardPacket$CC_Holo", "onLogIn", "event", "Lnet/minecraftforge/client/event/ClientPlayerNetworkEvent$LoggingIn;", "onLogOut", "Lnet/minecraftforge/client/event/ClientPlayerNetworkEvent$LoggingOut;", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nCanvasHandlerClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasHandlerClient.kt\nsh/lem/ccholo/canvas/CanvasHandlerClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n2642#2:88\n2642#2:90\n1#3:89\n1#3:91\n1#3:92\n*S KotlinDebug\n*F\n+ 1 CanvasHandlerClient.kt\nsh/lem/ccholo/canvas/CanvasHandlerClient\n*L\n29#1:88\n47#1:90\n29#1:89\n47#1:91\n*E\n"})
public final class CanvasHandlerClient {
    @NotNull
    public static final CanvasHandlerClient INSTANCE = new CanvasHandlerClient();

    private CanvasHandlerClient() {
    }

    private final boolean checkMainThread(String name) {
        if (!Minecraft.getInstance().isSameThread()) {
            CCHolo.log.error(name + " ran off-thread, refusing!");
            return false;
        }
        return true;
    }

    public final void onCanvasInitPacket$CC_Holo(@NotNull S2CCanvasInitPacket msg) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.checkMainThread("S2CCanvasInitPacket")) {
            return;
        }
        CCHolo.log.debug("Received canvas init packet for canvas " + msg.getCanvasId() + " with " + msg.getObjects().size() + " objects");
        CanvasRootClient root = CanvasRootClient.INSTANCE;
        root.initialise();
        Iterable $this$onEach$iv = msg.getObjects();
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2419$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            BaseObject p0 = (BaseObject)element$iv;
            boolean bl2 = false;
            root.updateObject(p0);
        }
        root.updateCaptureState(msg.getCapturing(), msg.getCapturingMouseMove(), msg.getKeyCaptures());
    }

    public final void onCanvasRemovePacket$CC_Holo(@NotNull S2CCanvasRemovePacket msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.checkMainThread("S2CCanvasRemovePacket")) {
            return;
        }
        CanvasRootClient.INSTANCE.initialise();
    }

    public final void onCanvasUpdatePacket$CC_Holo(@NotNull S2CCanvasUpdatePacket msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.checkMainThread("S2CCanvasUpdatePacket")) {
            return;
        }
        CanvasRootClient root = CanvasRootClient.INSTANCE;
        Iterable $this$onEach$iv = msg.getChanged();
        boolean $i$f$onEach = false;
        Iterable iterable = $this$onEach$iv;
        Iterable $this$onEach_u24lambda_u2419$iv = iterable;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            BaseObject p0 = (BaseObject)element$iv;
            boolean bl2 = false;
            root.updateObject(p0);
        }
        int[] nArray = msg.getRemoved();
        for (Object p0 : (Iterable)nArray) {
            boolean bl3 = false;
            root.remove((int)p0);
        }
    }

    public final void onCanvasCaptureStatePacket$CC_Holo(@NotNull S2CCanvasCaptureStatePacket msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.checkMainThread("S2CCanvasCaptureStatePacket")) {
            return;
        }
        CanvasRootClient root = CanvasRootClient.INSTANCE;
        root.updateCaptureState(msg.getCapturing(), msg.getCapturingMouseMove(), msg.getKeyCaptures());
    }

    public final void onCanvasSetClipboardPacket$CC_Holo(@NotNull S2CCanvasSetClipboardPacket msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.checkMainThread("S2CCanvasSetClipboardPacket")) {
            return;
        }
        try {
            Minecraft.getInstance().keyboardHandler.setClipboard(msg.getText());
        }
        catch (Exception e) {
            CCHolo.log.error("Error while setting clipboard", (Throwable)e);
        }
    }

    @SubscribeEvent
    public final void onLogIn(@NotNull ClientPlayerNetworkEvent.LoggingIn event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CCHolo.log.debug("Logging in, initialising canvas root");
        CanvasRootClient.INSTANCE.initialise();
    }

    @SubscribeEvent
    public final void onLogOut(@NotNull ClientPlayerNetworkEvent.LoggingOut event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CCHolo.log.debug("Logging out, clearing canvas root");
        CanvasRootClient.INSTANCE.initialise();
    }
}

