/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.canvas;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasCapturingScreen;
import sh.lem.ccholo.canvas.CanvasRoot;
import sh.lem.ccholo.networking.C2SCanvasStopCapturePacket;
import sh.lem.ccholo.networking.CCHoloPacketHandler;
import sh.lem.ccholo.objects.BaseObject;
import sh.lem.ccholo.objects.ObjectGroup;
import sh.lem.ccholo.objects.renderers.BaseObjectRenderer;
import sh.lem.ccholo.objects.renderers.ObjectRendererRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0007R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lsh/lem/ccholo/canvas/CanvasRootClient;", "Lsh/lem/ccholo/canvas/CanvasRoot;", "<init>", "()V", "objects", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lsh/lem/ccholo/objects/BaseObject;", "childrenOf", "Lit/unimi/dsi/fastutil/ints/IntSortedSet;", "capturePendingOpen", "", "getCapturePendingOpen", "()Z", "setCapturePendingOpen", "(Z)V", "initialise", "", "clientStopCapturing", "updateCaptureState", "capturing", "capturingMouseMove", "keyCaptures", "Lit/unimi/dsi/fastutil/ints/IntSet;", "updateObject", "obj", "remove", "id", "", "getObject", "getChildren", "drawChildren", "children", "Lit/unimi/dsi/fastutil/ints/IntIterator;", "gg", "Lnet/minecraft/client/gui/GuiGraphics;", "buf", "Lnet/minecraft/client/renderer/MultiBufferSource;", "CC-Holo"})
public final class CanvasRootClient
extends CanvasRoot {
    @NotNull
    public static final CanvasRootClient INSTANCE = new CanvasRootClient();
    @NotNull
    private static final Int2ObjectMap<BaseObject> objects = (Int2ObjectMap)new Int2ObjectOpenHashMap();
    @NotNull
    private static final Int2ObjectMap<IntSortedSet> childrenOf = (Int2ObjectMap)new Int2ObjectOpenHashMap();
    private static boolean capturePendingOpen;

    private CanvasRootClient() {
    }

    public final boolean getCapturePendingOpen() {
        return capturePendingOpen;
    }

    public final void setCapturePendingOpen(boolean bl) {
        capturePendingOpen = bl;
    }

    public final void initialise() {
        objects.clear();
        childrenOf.clear();
        childrenOf.put(0, (Object)new IntAVLTreeSet());
        childrenOf.put(1, (Object)new IntAVLTreeSet());
        this.setCapturing(false);
        this.setCapturingMouseMove(false);
        capturePendingOpen = false;
        this.getKeyCaptures().clear();
        if (Minecraft.getInstance().screen instanceof CanvasCapturingScreen) {
            Minecraft.getInstance().setScreen(null);
        }
    }

    public final void clientStopCapturing() {
        Minecraft.getInstance().setScreen(null);
        CCHoloPacketHandler.INSTANCE.getChannel().sendToServer((Object)new C2SCanvasStopCapturePacket(0, 1, null));
        this.setCapturing(false);
    }

    public final void updateCaptureState(boolean capturing, boolean capturingMouseMove, @NotNull IntSet keyCaptures) {
        Intrinsics.checkNotNullParameter((Object)keyCaptures, (String)"keyCaptures");
        this.setCapturing(capturing);
        this.setCapturingMouseMove(capturing && capturingMouseMove);
        if (capturing) {
            capturePendingOpen = true;
        }
        this.getKeyCaptures().clear();
        this.getKeyCaptures().addAll((IntCollection)keyCaptures);
    }

    public final void updateObject(@NotNull BaseObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        IntSet parent = (IntSet)childrenOf.get(obj.getParent());
        if (parent == null) {
            CCHolo.log.error("Trying to add " + obj.getId() + " to non-existent parent " + obj.getParent() + " (" + obj + ")");
            return;
        }
        if (objects.put(obj.getId(), (Object)obj) == null) {
            parent.add(obj.getId());
            if (obj instanceof ObjectGroup) {
                childrenOf.put(((ObjectGroup)((Object)obj)).getId(), (Object)new IntAVLTreeSet());
            }
        }
    }

    public final void remove(int id) {
        block1: {
            IntSet parent;
            BaseObject obj = (BaseObject)objects.remove(id);
            childrenOf.remove(id);
            if (obj == null) break block1;
            IntSet intSet = parent = (IntSet)childrenOf.get(obj.getParent());
            if (intSet != null) {
                intSet.remove(id);
            }
        }
    }

    @Nullable
    public final BaseObject getObject(int id) {
        return (BaseObject)objects.get(id);
    }

    @Nullable
    public final IntSet getChildren(int id) {
        IntSortedSet children = (IntSortedSet)childrenOf.get(id);
        return children.isEmpty() ? null : (IntSet)children;
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawChildren(@NotNull IntIterator children, @Nullable GuiGraphics gg, @Nullable MultiBufferSource buf) {
        Intrinsics.checkNotNullParameter((Object)children, (String)"children");
        while (children.hasNext()) {
            BaseObjectRenderer<BaseObject> renderer;
            BaseObject obj;
            int id = children.nextInt();
            if (this.getObject(id) == null || ObjectRendererRegistry.INSTANCE.getRenderer(obj.getType()) == null) continue;
            GuiGraphics guiGraphics = gg;
            Intrinsics.checkNotNull((Object)guiGraphics);
            renderer.draw(obj, this, guiGraphics, buf);
        }
    }

    static {
        INSTANCE.initialise();
    }
}

