/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.objects.renderers;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.objects.BaseObject;
import sh.lem.ccholo.objects.renderers.BaseObjectRenderer;
import sh.lem.ccholo.objects.renderers.object2d.Dot2dRenderer;
import sh.lem.ccholo.objects.renderers.object2d.Item2dRenderer;
import sh.lem.ccholo.objects.renderers.object2d.Line2dRenderer;
import sh.lem.ccholo.objects.renderers.object2d.Lines2dRenderer;
import sh.lem.ccholo.objects.renderers.object2d.ObjectGroup2dRenderer;
import sh.lem.ccholo.objects.renderers.object2d.Polygon2dRenderer;
import sh.lem.ccholo.objects.renderers.object2d.Rectangle2dRenderer;
import sh.lem.ccholo.objects.renderers.object2d.Text2dRenderer;
import sh.lem.ccholo.objects.renderers.object2d.Triangle2dRenderer;
import sh.lem.ccholo.objects.renderers.object3d.Box3dRenderer;
import sh.lem.ccholo.objects.renderers.object3d.Item3dRenderer;
import sh.lem.ccholo.objects.renderers.object3d.ObjectFrame3dRenderer;
import sh.lem.ccholo.objects.renderers.object3d.ObjectRoot3dRenderer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000f\u001a\n\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u0006\"\b\b\u0000\u0010\u0010*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000eR+\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lsh/lem/ccholo/objects/renderers/ObjectRendererRegistry;", "", "<init>", "()V", "renderers", "", "Lsh/lem/ccholo/objects/renderers/BaseObjectRenderer;", "Lsh/lem/ccholo/objects/BaseObject;", "getRenderers", "()[Lsh/lem/ccholo/objects/renderers/BaseObjectRenderer;", "renderers$delegate", "Lkotlin/Lazy;", "warnedRenderers", "", "", "getRenderer", "T", "type", "CC-Holo"})
public final class ObjectRendererRegistry {
    @NotNull
    public static final ObjectRendererRegistry INSTANCE = new ObjectRendererRegistry();
    @NotNull
    private static final Lazy renderers$delegate = LazyKt.lazy(ObjectRendererRegistry::renderers_delegate$lambda$0);
    @NotNull
    private static final Set<Byte> warnedRenderers = new LinkedHashSet();

    private ObjectRendererRegistry() {
    }

    private final BaseObjectRenderer<? extends BaseObject>[] getRenderers() {
        Lazy lazy = renderers$delegate;
        return (BaseObjectRenderer[])lazy.getValue();
    }

    @Nullable
    public final <T extends BaseObject> BaseObjectRenderer<T> getRenderer(byte type) {
        BaseObjectRenderer<? extends BaseObject> baseObjectRenderer;
        if (type < 0 || type >= this.getRenderers().length) {
            if (warnedRenderers.add(type)) {
                CCHolo.log.warn("Unknown renderer type " + type);
            }
            return null;
        }
        BaseObjectRenderer<? extends BaseObject> renderer = this.getRenderers()[type];
        if (renderer == null && warnedRenderers.add(type)) {
            CCHolo.log.warn("No renderer for type " + type);
        }
        if ((baseObjectRenderer = renderer) == null) {
            baseObjectRenderer = null;
        }
        return baseObjectRenderer;
    }

    private static final BaseObjectRenderer[] renderers_delegate$lambda$0() {
        BaseObjectRenderer[] baseObjectRendererArray = new BaseObjectRenderer[]{Rectangle2dRenderer.INSTANCE, Line2dRenderer.INSTANCE, Dot2dRenderer.INSTANCE, Text2dRenderer.INSTANCE, Triangle2dRenderer.INSTANCE, Polygon2dRenderer.INSTANCE, Lines2dRenderer.INSTANCE, Item2dRenderer.INSTANCE, ObjectGroup2dRenderer.INSTANCE, ObjectRoot3dRenderer.INSTANCE, ObjectFrame3dRenderer.INSTANCE, Box3dRenderer.INSTANCE, Item3dRenderer.INSTANCE, null};
        return baseObjectRendererArray;
    }
}

