/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.util;

import java.nio.ByteBuffer;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lsh/lem/ccholo/util/CCStringUtil;", "", "<init>", "()V", "MAX_PASTE_LENGTH", "", "unicodeToTerminal", "chr", "unicodeToCraftOsFallback", "c", "isTypableChar", "", "getClipboardString", "Ljava/nio/ByteBuffer;", "clipboard", "", "CC-Holo"})
public final class CCStringUtil {
    @NotNull
    public static final CCStringUtil INSTANCE = new CCStringUtil();
    public static final int MAX_PASTE_LENGTH = 512;

    private CCStringUtil() {
    }

    public final int unicodeToTerminal(int chr) {
        block6: {
            block5: {
                if (chr == 0 || chr == 9 || chr == 10 || chr == 13 || chr >= 32 && chr <= 126) break block5;
                boolean bl = 160 <= chr ? chr < 256 : false;
                if (!bl) break block6;
            }
            return chr;
        }
        boolean bl = 129792 <= chr ? chr < 129812 : false;
        if (bl) {
            return chr + -129663;
        }
        boolean bl2 = 129812 <= chr ? chr < 129822 : false;
        if (bl2) {
            return chr + -129662;
        }
        return this.unicodeToCraftOsFallback(chr);
    }

    private final int unicodeToCraftOsFallback(int c) {
        return switch (c) {
            case 9786 -> 1;
            case 9787 -> 2;
            case 9829 -> 3;
            case 9830 -> 4;
            case 9827 -> 5;
            case 9824 -> 6;
            case 8226 -> 7;
            case 9688 -> 8;
            case 9794 -> 11;
            case 9792 -> 12;
            case 9834 -> 14;
            case 9835 -> 15;
            case 9658 -> 16;
            case 9668 -> 17;
            case 8597 -> 18;
            case 8252 -> 19;
            case 9644 -> 22;
            case 8616 -> 23;
            case 8593 -> 24;
            case 8595 -> 25;
            case 8594 -> 26;
            case 8592 -> 27;
            case 8735 -> 28;
            case 8596 -> 29;
            case 9650 -> 30;
            case 9660 -> 31;
            case 129945 -> 127;
            case 9612 -> 149;
            default -> -1;
        };
    }

    public final boolean isTypableChar(int chr) {
        return (0 <= chr ? chr < 256 : false) && chr != 0 && chr != 13 && chr != 10;
    }

    @NotNull
    public final ByteBuffer getClipboardString(@NotNull String clipboard) {
        Intrinsics.checkNotNullParameter((Object)clipboard, (String)"clipboard");
        byte[] output = new byte[RangesKt.coerceAtMost((int)512, (int)clipboard.length())];
        int idx = 0;
        PrimitiveIterator.OfInt iterator = clipboard.codePoints().iterator();
        while (iterator.hasNext() && idx < output.length) {
            Integer n = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"next(...)");
            int chr = this.unicodeToTerminal(((Number)n).intValue());
            if (chr < 0) continue;
            if (!this.isTypableChar(chr)) break;
            output[idx++] = (byte)chr;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(output, 0, idx).asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
        return byteBuffer;
    }
}

