/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.canvas;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import sh.lem.ccholo.canvas.CanvasRootClient;
import sh.lem.ccholo.objects.renderers.FramebufferPool;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0007J\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lsh/lem/ccholo/canvas/CanvasRenderer;", "", "<init>", "()V", "mc", "Lnet/minecraft/client/Minecraft;", "kotlin.jvm.PlatformType", "getMc", "()Lnet/minecraft/client/Minecraft;", "mc$delegate", "Lkotlin/Lazy;", "onOverlayPre", "", "event", "Lnet/minecraftforge/client/event/RenderGuiOverlayEvent$Pre;", "onRenderLevelStage", "Lnet/minecraftforge/client/event/RenderLevelStageEvent;", "onRenderTick", "Lnet/minecraftforge/event/TickEvent$RenderTickEvent;", "renderCanvas2DOverlay", "renderCanvas3DOverlay", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "CC-Holo"})
public final class CanvasRenderer {
    @NotNull
    public static final CanvasRenderer INSTANCE = new CanvasRenderer();
    @NotNull
    private static final Lazy mc$delegate = LazyKt.lazy(CanvasRenderer::mc_delegate$lambda$0);

    private CanvasRenderer() {
    }

    private final Minecraft getMc() {
        Lazy lazy = mc$delegate;
        return (Minecraft)lazy.getValue();
    }

    @SubscribeEvent
    public final void onOverlayPre(@NotNull RenderGuiOverlayEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            this.getMc().getProfiler().push("plethora:renderCanvas2DOverlay");
            this.renderCanvas2DOverlay();
            this.getMc().getProfiler().pop();
        }
    }

    @SubscribeEvent
    public final void onRenderLevelStage(@NotNull RenderLevelStageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            this.getMc().getProfiler().push("plethora:renderCanvas3DOverlay");
            PoseStack poseStack = event.getPoseStack();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getPoseStack(...)");
            this.renderCanvas3DOverlay(poseStack);
            this.getMc().getProfiler().pop();
        }
    }

    @SubscribeEvent
    public final void onRenderTick(@NotNull TickEvent.RenderTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TickEvent.Phase phase = event.phase;
        switch (phase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
            case 1: {
                FramebufferPool.INSTANCE.beginFrame();
                break;
            }
            case 2: {
                FramebufferPool.INSTANCE.endFrame();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void renderCanvas2DOverlay() {
        IntSet intSet = CanvasRootClient.INSTANCE.getChildren(0);
        if (intSet == null) {
            return;
        }
        IntSet children = intSet;
        if (this.getMc().font == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack innerPoseStack = new PoseStack();
        innerPoseStack.setIdentity();
        innerPoseStack.translate(0.0, 0.0, -100.0);
        MultiBufferSource.BufferSource buf = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        GuiGraphics gg = new GuiGraphics(this.getMc(), innerPoseStack, buf);
        float currentFog = RenderSystem.getShaderFogEnd();
        float[] currentFogColor = RenderSystem.getShaderFogColor();
        RenderSystem.setShaderFogEnd((float)2000.0f);
        RenderSystem.setShaderFogColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        IntIterator intIterator = children.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        Intrinsics.checkNotNull((Object)buf);
        CanvasRootClient.INSTANCE.drawChildren(intIterator, gg, (MultiBufferSource)buf);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        RenderSystem.setShaderFogEnd((float)currentFog);
        RenderSystem.setShaderFogColor((float)currentFogColor[0], (float)currentFogColor[1], (float)currentFogColor[2], (float)currentFogColor[3]);
        innerPoseStack.popPose();
    }

    public final void renderCanvas3DOverlay(@NotNull PoseStack poseStack) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        IntSet intSet = CanvasRootClient.INSTANCE.getChildren(1);
        if (intSet == null) {
            return;
        }
        IntSet children = intSet;
        MultiBufferSource.BufferSource buf = this.getMc().renderBuffers().bufferSource();
        GuiGraphics gg = new GuiGraphics(this.getMc(), poseStack, buf);
        IntIterator intIterator = children.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        Intrinsics.checkNotNull((Object)buf);
        CanvasRootClient.INSTANCE.drawChildren(intIterator, gg, (MultiBufferSource)buf);
    }

    private static final Minecraft mc_delegate$lambda$0() {
        return Minecraft.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TickEvent.Phase.values().length];
            try {
                nArray[TickEvent.Phase.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TickEvent.Phase.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

