/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.canvas;

import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasCapturingScreen;
import sh.lem.ccholo.canvas.CanvasRoot;
import sh.lem.ccholo.networking.C2SCanvasScreenSizePacket;
import sh.lem.ccholo.networking.C2SCanvasStopCapturePacket;
import sh.lem.ccholo.networking.CCHoloPacket;
import sh.lem.ccholo.networking.CCHoloPacketHandler;
import sh.lem.ccholo.objects.BaseObject;
import sh.lem.ccholo.objects.ObjectGroup;
import sh.lem.ccholo.objects.renderers.BaseObjectRenderer;
import sh.lem.ccholo.objects.renderers.ObjectRendererRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\r\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0016J-\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\r\u0010\u001e\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001fJ\r\u0010 \u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b!J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'J\u001b\u0010(\u001a\n \f*\u0004\u0018\u00010$0$2\u0006\u0010&\u001a\u00020'\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u0004\u0018\u00010\u001c2\u0006\u0010&\u001a\u00020'J \u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u00062"}, d2={"Lsh/lem/ccholo/canvas/CanvasRootClient;", "Lsh/lem/ccholo/canvas/CanvasRoot;", "<init>", "()V", "capturePendingOpen", "", "getCapturePendingOpen", "()Z", "setCapturePendingOpen", "(Z)V", "mc", "Lnet/minecraft/client/Minecraft;", "kotlin.jvm.PlatformType", "getMc", "()Lnet/minecraft/client/Minecraft;", "mc$delegate", "Lkotlin/Lazy;", "makeChildSet", "Lit/unimi/dsi/fastutil/ints/IntAVLTreeSet;", "reset", "", "clientStopCapturing", "clientStopCapturing$CC_Holo", "updateCaptureState", "capturing", "capturingMouseMove", "hidingMouse", "keyCaptures", "Lit/unimi/dsi/fastutil/ints/IntSet;", "updateCaptureState$CC_Holo", "updateScreenSize", "updateScreenSize$CC_Holo", "sendScreenSizePacket", "sendScreenSizePacket$CC_Holo", "updateObject", "obj", "Lsh/lem/ccholo/objects/BaseObject;", "remove", "id", "", "getObject", "(I)Lsh/lem/ccholo/objects/BaseObject;", "getChildren", "drawChildren", "children", "Lit/unimi/dsi/fastutil/ints/IntIterator;", "gg", "Lnet/minecraft/client/gui/GuiGraphics;", "buf", "Lnet/minecraft/client/renderer/MultiBufferSource;", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nCanvasRootClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasRootClient.kt\nsh/lem/ccholo/canvas/CanvasRootClient\n+ 2 ClientPacketExt.kt\nsh/lem/ccholo/networking/ClientPacketExtKt\n*L\n1#1,134:1\n8#2,2:135\n8#2,2:137\n*S KotlinDebug\n*F\n+ 1 CanvasRootClient.kt\nsh/lem/ccholo/canvas/CanvasRootClient\n*L\n41#1:135,2\n86#1:137,2\n*E\n"})
public final class CanvasRootClient
extends CanvasRoot {
    @NotNull
    public static final CanvasRootClient INSTANCE = new CanvasRootClient();
    private static boolean capturePendingOpen;
    @NotNull
    private static final Lazy mc$delegate;

    private CanvasRootClient() {
    }

    public final boolean getCapturePendingOpen() {
        return capturePendingOpen;
    }

    public final void setCapturePendingOpen(boolean bl) {
        capturePendingOpen = bl;
    }

    private final Minecraft getMc() {
        Lazy lazy = mc$delegate;
        return (Minecraft)lazy.getValue();
    }

    @NotNull
    public IntAVLTreeSet makeChildSet() {
        return new IntAVLTreeSet();
    }

    @Override
    public void reset() {
        super.reset();
        this.updateScreenSize$CC_Holo();
        if (this.getMc().screen instanceof CanvasCapturingScreen) {
            this.getMc().setScreen(null);
        }
    }

    public final void clientStopCapturing$CC_Holo() {
        if (this.getMc().screen instanceof CanvasCapturingScreen) {
            this.getMc().setScreen(null);
        }
        CCHoloPacket $this$send$iv = new C2SCanvasStopCapturePacket(0, 1, null);
        boolean $i$f$send = false;
        CCHoloPacketHandler.INSTANCE.getChannel().sendToServer((Object)$this$send$iv);
        this.setCapturing(false);
    }

    public final void updateCaptureState$CC_Holo(boolean capturing, boolean capturingMouseMove, boolean hidingMouse, @NotNull IntSet keyCaptures) {
        Intrinsics.checkNotNullParameter((Object)keyCaptures, (String)"keyCaptures");
        Screen screen = this.getMc().screen;
        if (capturing && !this.getCapturing()) {
            capturePendingOpen = true;
        }
        this.setCapturing(capturing);
        this.setCapturingMouseMove(capturing && capturingMouseMove);
        this.setHidingMouse(capturing && hidingMouse);
        this.getKeyCaptures().clear();
        this.getKeyCaptures().addAll((IntCollection)keyCaptures);
        if (screen instanceof CanvasCapturingScreen) {
            if (capturing) {
                ((CanvasCapturingScreen)screen).reset();
            } else {
                this.getMc().setScreen(null);
            }
        }
    }

    public final void updateScreenSize$CC_Holo() {
        this.setScreenWidth(this.getMc().getWindow().getScreenWidth());
        this.setScreenHeight(this.getMc().getWindow().getScreenHeight());
        this.setGuiScaledWidth(this.getMc().getWindow().getGuiScaledWidth());
        this.setGuiScaledHeight(this.getMc().getWindow().getGuiScaledHeight());
        this.setGuiScale(this.getMc().getWindow().getGuiScale());
    }

    public final void sendScreenSizePacket$CC_Holo() {
        try {
            CCHoloPacket $this$send$iv = new C2SCanvasScreenSizePacket(0, this.getScreenWidth(), this.getScreenHeight(), this.getGuiScaledWidth(), this.getGuiScaledHeight(), this.getGuiScale());
            boolean $i$f$send = false;
            CCHoloPacketHandler.INSTANCE.getChannel().sendToServer((Object)$this$send$iv);
        }
        catch (Exception e) {
            CCHolo.log.error("Error while sending screen size packet", (Throwable)e);
        }
    }

    public final void updateObject(@NotNull BaseObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        IntSet parent = (IntSet)this.getChildrenOf().get(obj.getParent());
        if (parent == null) {
            CCHolo.log.error("Trying to add " + obj.getId() + " to non-existent parent " + obj.getParent() + " (" + obj + ")");
            return;
        }
        if (this.getObjects().put(obj.getId(), (Object)obj) == null) {
            parent.add(obj.getId());
            if (obj instanceof ObjectGroup) {
                this.getChildrenOf().put(((ObjectGroup)((Object)obj)).getId(), (Object)new IntAVLTreeSet());
            }
        }
    }

    public final void remove(int id) {
        block1: {
            IntSet parent;
            BaseObject obj = (BaseObject)this.getObjects().remove(id);
            this.getChildrenOf().remove(id);
            if (obj == null) break block1;
            IntSet intSet = parent = (IntSet)this.getChildrenOf().get(obj.getParent());
            if (intSet != null) {
                intSet.remove(id);
            }
        }
    }

    public final BaseObject getObject(int id) {
        return (BaseObject)this.getObjects().get(id);
    }

    @Nullable
    public final IntSet getChildren(int id) {
        IntSet children = (IntSet)this.getChildrenOf().get(id);
        return children.isEmpty() ? null : children;
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawChildren(@NotNull IntIterator children, @NotNull GuiGraphics gg, @NotNull MultiBufferSource buf) {
        Intrinsics.checkNotNullParameter((Object)children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)gg, (String)"gg");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        while (children.hasNext()) {
            BaseObjectRenderer<BaseObject> renderer;
            BaseObject obj;
            int id = children.nextInt();
            if (this.getObject(id) == null || ObjectRendererRegistry.INSTANCE.getRenderer(obj.getType()) == null) continue;
            renderer.draw(obj, this, gg, buf);
        }
    }

    private static final Minecraft mc_delegate$lambda$0() {
        return Minecraft.getInstance();
    }

    static {
        mc$delegate = LazyKt.lazy(CanvasRootClient::mc_delegate$lambda$0);
    }
}

