/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.networking;

import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.canvas.CanvasHandlerServer;
import sh.lem.ccholo.canvas.CanvasRootServer;
import sh.lem.ccholo.networking.CCHoloPacket;
import sh.lem.ccholo.networking.HitResultUtil;
import sh.lem.ccholo.util.BufExtKt;
import sh.lem.ccholo.util.EntityHitInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*BG\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JI\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Lsh/lem/ccholo/networking/C2SCanvasCaptureScrollPacket;", "Lsh/lem/ccholo/networking/CCHoloPacket;", "canvasId", "", "direction", "x", "", "y", "blockHit", "Lnet/minecraft/world/phys/BlockHitResult;", "entityHit", "Lsh/lem/ccholo/util/EntityHitInfo;", "<init>", "(IIDDLnet/minecraft/world/phys/BlockHitResult;Lsh/lem/ccholo/util/EntityHitInfo;)V", "getCanvasId", "()I", "getDirection", "getX", "()D", "getY", "getBlockHit", "()Lnet/minecraft/world/phys/BlockHitResult;", "getEntityHit", "()Lsh/lem/ccholo/util/EntityHitInfo;", "encode", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "CC-Holo"})
public final class C2SCanvasCaptureScrollPacket
implements CCHoloPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int canvasId;
    private final int direction;
    private final double x;
    private final double y;
    @Nullable
    private final BlockHitResult blockHit;
    @Nullable
    private final EntityHitInfo entityHit;

    public C2SCanvasCaptureScrollPacket(int canvasId, int direction, double x, double y, @Nullable BlockHitResult blockHit, @Nullable EntityHitInfo entityHit) {
        this.canvasId = canvasId;
        this.direction = direction;
        this.x = x;
        this.y = y;
        this.blockHit = blockHit;
        this.entityHit = entityHit;
    }

    public /* synthetic */ C2SCanvasCaptureScrollPacket(int n, int n2, double d, double d2, BlockHitResult blockHitResult, EntityHitInfo entityHitInfo, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            d = 0.0;
        }
        if ((n3 & 8) != 0) {
            d2 = 0.0;
        }
        if ((n3 & 0x10) != 0) {
            blockHitResult = null;
        }
        if ((n3 & 0x20) != 0) {
            entityHitInfo = null;
        }
        this(n, n2, d, d2, blockHitResult, entityHitInfo);
    }

    public final int getCanvasId() {
        return this.canvasId;
    }

    public final int getDirection() {
        return this.direction;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    @Nullable
    public final BlockHitResult getBlockHit() {
        return this.blockHit;
    }

    @Nullable
    public final EntityHitInfo getEntityHit() {
        return this.entityHit;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeInt(this.canvasId);
        buf.writeInt(this.direction);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        BufExtKt.writeOptBlockHitResult(buf, this.blockHit);
        BufExtKt.writeOptEntityHitInfo(buf, this.entityHit);
    }

    public final int component1() {
        return this.canvasId;
    }

    public final int component2() {
        return this.direction;
    }

    public final double component3() {
        return this.x;
    }

    public final double component4() {
        return this.y;
    }

    @Nullable
    public final BlockHitResult component5() {
        return this.blockHit;
    }

    @Nullable
    public final EntityHitInfo component6() {
        return this.entityHit;
    }

    @NotNull
    public final C2SCanvasCaptureScrollPacket copy(int canvasId, int direction, double x, double y, @Nullable BlockHitResult blockHit, @Nullable EntityHitInfo entityHit) {
        return new C2SCanvasCaptureScrollPacket(canvasId, direction, x, y, blockHit, entityHit);
    }

    public static /* synthetic */ C2SCanvasCaptureScrollPacket copy$default(C2SCanvasCaptureScrollPacket c2SCanvasCaptureScrollPacket, int n, int n2, double d, double d2, BlockHitResult blockHitResult, EntityHitInfo entityHitInfo, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = c2SCanvasCaptureScrollPacket.canvasId;
        }
        if ((n3 & 2) != 0) {
            n2 = c2SCanvasCaptureScrollPacket.direction;
        }
        if ((n3 & 4) != 0) {
            d = c2SCanvasCaptureScrollPacket.x;
        }
        if ((n3 & 8) != 0) {
            d2 = c2SCanvasCaptureScrollPacket.y;
        }
        if ((n3 & 0x10) != 0) {
            blockHitResult = c2SCanvasCaptureScrollPacket.blockHit;
        }
        if ((n3 & 0x20) != 0) {
            entityHitInfo = c2SCanvasCaptureScrollPacket.entityHit;
        }
        return c2SCanvasCaptureScrollPacket.copy(n, n2, d, d2, blockHitResult, entityHitInfo);
    }

    @NotNull
    public String toString() {
        return "C2SCanvasCaptureScrollPacket(canvasId=" + this.canvasId + ", direction=" + this.direction + ", x=" + this.x + ", y=" + this.y + ", blockHit=" + this.blockHit + ", entityHit=" + this.entityHit + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.canvasId);
        result = result * 31 + Integer.hashCode(this.direction);
        result = result * 31 + Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + (this.blockHit == null ? 0 : this.blockHit.hashCode());
        result = result * 31 + (this.entityHit == null ? 0 : this.entityHit.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof C2SCanvasCaptureScrollPacket)) {
            return false;
        }
        C2SCanvasCaptureScrollPacket c2SCanvasCaptureScrollPacket = (C2SCanvasCaptureScrollPacket)other;
        if (this.canvasId != c2SCanvasCaptureScrollPacket.canvasId) {
            return false;
        }
        if (this.direction != c2SCanvasCaptureScrollPacket.direction) {
            return false;
        }
        if (Double.compare(this.x, c2SCanvasCaptureScrollPacket.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, c2SCanvasCaptureScrollPacket.y) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.blockHit, (Object)c2SCanvasCaptureScrollPacket.blockHit)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.entityHit, (Object)c2SCanvasCaptureScrollPacket.entityHit);
    }

    public C2SCanvasCaptureScrollPacket() {
        this(0, 0, 0.0, 0.0, null, null, 63, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u000e"}, d2={"Lsh/lem/ccholo/networking/C2SCanvasCaptureScrollPacket$Companion;", "", "<init>", "()V", "decode", "Lsh/lem/ccholo/networking/C2SCanvasCaptureScrollPacket;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "handle", "", "msg", "ctx", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "CC-Holo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final C2SCanvasCaptureScrollPacket decode(@NotNull FriendlyByteBuf buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return new C2SCanvasCaptureScrollPacket(buf.readInt(), buf.readInt(), buf.readDouble(), buf.readDouble(), BufExtKt.readOptBlockHitResult(buf), BufExtKt.readOptEntityHitInfo(buf));
        }

        public final void handle(@NotNull C2SCanvasCaptureScrollPacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            NetworkEvent.Context context = ctx.get();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"get(...)");
            NetworkEvent.Context c = context;
            c.enqueueWork(() -> Companion.handle$lambda$0(c, msg));
            c.setPacketHandled(true);
        }

        private static final void handle$lambda$0(NetworkEvent.Context $c, C2SCanvasCaptureScrollPacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$c, (String)"$c");
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            ServerPlayer serverPlayer = $c.getSender();
            if (serverPlayer == null) {
                return;
            }
            ServerPlayer player = serverPlayer;
            CanvasRootServer root = CanvasHandlerServer.INSTANCE.getRootForPlayer(player);
            BlockHitResult blockHitResult = $msg.getBlockHit();
            EntityHitInfo entityHitInfo = $msg.getEntityHit();
            Level level = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            Map<String, Object> hitTable = HitResultUtil.INSTANCE.createHitResultTable(blockHitResult, entityHitInfo, level);
            Object[] objectArray = new Object[]{$msg.getDirection(), $msg.getX(), $msg.getY(), hitTable};
            root.queuePlayerEvent("hologram_mouse_scroll", player, objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

