/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.objects.object2d;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasRootClient;
import sh.lem.ccholo.canvas.CanvasRootServer;
import sh.lem.ccholo.objects.ObjectGroup;
import sh.lem.ccholo.objects.object2d.Dot2d;
import sh.lem.ccholo.objects.object2d.Item2d;
import sh.lem.ccholo.objects.object2d.Line2d;
import sh.lem.ccholo.objects.object2d.Lines2d;
import sh.lem.ccholo.objects.object2d.ObjectFrame2d;
import sh.lem.ccholo.objects.object2d.ObjectGroup2d;
import sh.lem.ccholo.objects.object2d.Polygon2d;
import sh.lem.ccholo.objects.object2d.Rectangle2d;
import sh.lem.ccholo.objects.object2d.Text2d;
import sh.lem.ccholo.objects.object2d.Triangle2d;
import sh.lem.ccholo.util.ArgumentExtKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0018"}, d2={"Lsh/lem/ccholo/objects/object2d/Group2d;", "Lsh/lem/ccholo/objects/ObjectGroup;", "addRectangle", "Lsh/lem/ccholo/objects/object2d/Rectangle2d;", "args", "Ldan200/computercraft/api/lua/IArguments;", "addLine", "Lsh/lem/ccholo/objects/object2d/Line2d;", "addDot", "Lsh/lem/ccholo/objects/object2d/Dot2d;", "addText", "Lsh/lem/ccholo/objects/object2d/Text2d;", "addTriangle", "Lsh/lem/ccholo/objects/object2d/Triangle2d;", "addPolygon", "Lsh/lem/ccholo/objects/object2d/Polygon2d;", "addLines", "Lsh/lem/ccholo/objects/object2d/Lines2d;", "addItem", "Lsh/lem/ccholo/objects/object2d/Item2d;", "addGroup", "Lsh/lem/ccholo/objects/object2d/ObjectGroup2d;", "addFrame", "Lsh/lem/ccholo/objects/object2d/ObjectFrame2d;", "CC-Holo"})
public interface Group2d
extends ObjectGroup {
    @LuaFunction
    @NotNull
    public Rectangle2d addRectangle(@NotNull IArguments var1);

    @LuaFunction
    @NotNull
    public Line2d addLine(@NotNull IArguments var1);

    @LuaFunction
    @NotNull
    public Dot2d addDot(@NotNull IArguments var1);

    @LuaFunction
    @NotNull
    public Text2d addText(@NotNull IArguments var1);

    @LuaFunction
    @NotNull
    public Triangle2d addTriangle(@NotNull IArguments var1);

    @LuaFunction
    @NotNull
    public Polygon2d addPolygon(@NotNull IArguments var1);

    @LuaFunction
    @NotNull
    public Lines2d addLines(@NotNull IArguments var1);

    @LuaFunction
    @NotNull
    public Item2d addItem(@NotNull IArguments var1);

    @LuaFunction
    @NotNull
    public ObjectGroup2d addGroup(@NotNull IArguments var1);

    @LuaFunction
    @NotNull
    public ObjectFrame2d addFrame(@NotNull IArguments var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @LuaFunction
        @NotNull
        public static Rectangle2d addRectangle(@NotNull Group2d $this, @NotNull IArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Vec2 pos = ArgumentExtKt.getVec2(args, 0);
            Vec2 size = ArgumentExtKt.getVec2(args, 2);
            int colour = args.optInt(4, -1);
            Rectangle2d rect = new Rectangle2d($this.getCanvasRootServer().newObjectId(), $this.getId(), $this.getCanvasRootServer());
            rect.setPosition(pos);
            rect.setSize(size);
            rect.setColour(colour);
            $this.getCanvasRootServer().add(rect);
            return rect;
        }

        @LuaFunction
        @NotNull
        public static Line2d addLine(@NotNull Group2d $this, @NotNull IArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Vec2 start = ArgumentExtKt.getVec2(args, 0);
            Vec2 end = ArgumentExtKt.getVec2(args, 2);
            int colour = args.optInt(4, -1);
            float thickness = (float)args.optDouble(5, 1.0);
            Line2d line = new Line2d($this.getCanvasRootServer().newObjectId(), $this.getId(), $this.getCanvasRootServer());
            line.setVertex(0, start);
            line.setVertex(1, end);
            line.setColour(colour);
            line.setScale(thickness);
            $this.getCanvasRootServer().add(line);
            return line;
        }

        @LuaFunction
        @NotNull
        public static Dot2d addDot(@NotNull Group2d $this, @NotNull IArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Vec2 position = ArgumentExtKt.getVec2(args, 0);
            int colour = args.optInt(2, -1);
            float size = (float)args.optDouble(3, 1.0);
            Dot2d dot = new Dot2d($this.getCanvasRootServer().newObjectId(), $this.getId(), $this.getCanvasRootServer());
            dot.setPosition(position);
            dot.setColour(colour);
            dot.setScale(size);
            $this.getCanvasRootServer().add(dot);
            return dot;
        }

        @LuaFunction
        @NotNull
        public static Text2d addText(@NotNull Group2d $this, @NotNull IArguments args) {
            MutableComponent mutableComponent;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Vec2 position = ArgumentExtKt.getVec2(args, 0);
            String contents = ArgumentExtKt.assertUtf8StringLength$default(args, 2, 0, Short.MAX_VALUE, null, 8, null);
            int colour = args.optInt(3, -1);
            float size = (float)args.optDouble(4, 1.0);
            boolean json = args.optBoolean(5, false);
            if (json) {
                MutableComponent mutableComponent2;
                try {
                    mutableComponent2 = Component.Serializer.fromJson((String)contents);
                }
                catch (Exception e) {
                    CCHolo.log.error("Invalid JSON string: " + contents, (Throwable)e);
                    throw new LuaException("Invalid JSON string");
                }
                mutableComponent = mutableComponent2;
            } else {
                mutableComponent = null;
            }
            MutableComponent component = mutableComponent;
            Text2d text = new Text2d($this.getCanvasRootServer().newObjectId(), $this.getId(), $this.getCanvasRootServer());
            text.setPosition(position);
            text.setColour(colour);
            text.setScale(size);
            if (json) {
                text.setComponent((Component)component);
            } else {
                text.setPlaintext(contents);
            }
            $this.getCanvasRootServer().add(text);
            return text;
        }

        @LuaFunction
        @NotNull
        public static Triangle2d addTriangle(@NotNull Group2d $this, @NotNull IArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Vec2 p1 = ArgumentExtKt.getVec2Table(args, 0);
            Vec2 p2 = ArgumentExtKt.getVec2Table(args, 1);
            Vec2 p3 = ArgumentExtKt.getVec2Table(args, 2);
            int colour = args.optInt(3, -1);
            Triangle2d triangle = new Triangle2d($this.getCanvasRootServer().newObjectId(), $this.getId(), $this.getCanvasRootServer());
            triangle.setVertex(0, p1);
            triangle.setVertex(1, p2);
            triangle.setVertex(2, p3);
            triangle.setColour(colour);
            $this.getCanvasRootServer().add(triangle);
            return triangle;
        }

        @LuaFunction
        @NotNull
        public static Polygon2d addPolygon(@NotNull Group2d $this, @NotNull IArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            List<Vec2> points = ArgumentExtKt.getVec2Tables(args, 1);
            int colour = args.optInt(points.size(), -1);
            Polygon2d polygon = new Polygon2d($this.getCanvasRootServer().newObjectId(), $this.getId(), $this.getCanvasRootServer(), 0, 8, null);
            polygon.setPoints(points);
            $this.getCanvasRootServer().add(polygon);
            return polygon;
        }

        @LuaFunction
        @NotNull
        public static Lines2d addLines(@NotNull Group2d $this, @NotNull IArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            List<Vec2> points = ArgumentExtKt.getVec2Tables(args, 2);
            int colour = args.optInt(points.size(), -1);
            float thickness = (float)args.optDouble(points.size() + 1, 1.0);
            Lines2d lines = new Lines2d($this.getCanvasRootServer().newObjectId(), $this.getId(), $this.getCanvasRootServer());
            lines.setPoints(points);
            lines.setColour(colour);
            lines.setScale(thickness);
            $this.getCanvasRootServer().add(lines);
            return lines;
        }

        @LuaFunction
        @NotNull
        public static Item2d addItem(@NotNull Group2d $this, @NotNull IArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Vec2 pos = ArgumentExtKt.getVec2(args, 0);
            Pair<Item, CompoundTag> pair = ArgumentExtKt.getItem(args, 2);
            Item item = (Item)pair.component1();
            CompoundTag nbt = (CompoundTag)pair.component2();
            float scale = (float)args.optDouble(3, 1.0);
            Item2d item2d = new Item2d($this.getCanvasRootServer().newObjectId(), $this.getId(), $this.getCanvasRootServer());
            item2d.setPosition(pos);
            item2d.setItem(item);
            item2d.setNbt(nbt);
            item2d.setScale(scale);
            $this.getCanvasRootServer().add(item2d);
            return item2d;
        }

        @LuaFunction
        @NotNull
        public static ObjectGroup2d addGroup(@NotNull Group2d $this, @NotNull IArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Vec2 pos = ArgumentExtKt.getVec2(args, 0);
            ObjectGroup2d group = new ObjectGroup2d($this.getCanvasRootServer().newObjectId(), $this.getId(), $this.getCanvasRootServer());
            group.setPosition(pos);
            $this.getCanvasRootServer().add(group);
            return group;
        }

        @LuaFunction
        @NotNull
        public static ObjectFrame2d addFrame(@NotNull Group2d $this, @NotNull IArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Vec2 pos = ArgumentExtKt.getVec2(args, 0);
            int width = args.optInt(2, 512);
            int height = args.optInt(3, 288);
            ObjectFrame2d frame = new ObjectFrame2d($this.getCanvasRootServer().newObjectId(), $this.getId(), $this.getCanvasRootServer());
            frame.setPosition(pos);
            frame.setSize(width, height);
            $this.getCanvasRootServer().add(frame);
            return frame;
        }

        @NotNull
        public static CanvasRootClient getCanvasRootClient(@NotNull Group2d $this) {
            return ObjectGroup.DefaultImpls.getCanvasRootClient($this);
        }

        @NotNull
        public static CanvasRootServer getCanvasRootServer(@NotNull Group2d $this) {
            return ObjectGroup.DefaultImpls.getCanvasRootServer($this);
        }

        @LuaFunction
        public static void clear(@NotNull Group2d $this) {
            ObjectGroup.DefaultImpls.clear($this);
        }
    }
}

