/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.objects.renderers;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import sh.lem.ccholo.CCHolo;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002#$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\"\u0010\u0018\u001a\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00190\u0019J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\"\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lsh/lem/ccholo/objects/renderers/FramebufferPool;", "", "<init>", "()V", "MAX_POOL_SIZE", "", "DISPOSAL_DELAY_FRAMES", "MAX_FRAMEBUFFER_WIDTH", "MAX_FRAMEBUFFER_HEIGHT", "pool", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lsh/lem/ccholo/objects/renderers/FramebufferPool$PooledFramebuffer;", "usedThisFrame", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "activeFramebuffers", "frameCounter", "", "framebufferStack", "Ljava/util/LinkedList;", "Lsh/lem/ccholo/objects/renderers/FramebufferPool$FramebufferStackEntry;", "acquire", "Lcom/mojang/blaze3d/pipeline/TextureTarget;", "width", "height", "release", "Lkotlin/Pair;", "Lorg/joml/Matrix4f;", "Lcom/mojang/blaze3d/vertex/VertexSorting;", "beginFrame", "", "endFrame", "clear", "packDimensions", "unpackDimensions", "key", "FramebufferStackEntry", "PooledFramebuffer", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nFramebufferPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FramebufferPool.kt\nsh/lem/ccholo/objects/renderers/FramebufferPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1863#2,2:190\n*S KotlinDebug\n*F\n+ 1 FramebufferPool.kt\nsh/lem/ccholo/objects/renderers/FramebufferPool\n*L\n172#1:190,2\n*E\n"})
public final class FramebufferPool {
    @NotNull
    public static final FramebufferPool INSTANCE = new FramebufferPool();
    private static final int MAX_POOL_SIZE = 256;
    private static final int DISPOSAL_DELAY_FRAMES = 1800;
    private static final int MAX_FRAMEBUFFER_WIDTH = 8192;
    private static final int MAX_FRAMEBUFFER_HEIGHT = 8192;
    @NotNull
    private static final Long2ObjectOpenHashMap<PooledFramebuffer> pool = new Long2ObjectOpenHashMap();
    @NotNull
    private static final LongOpenHashSet usedThisFrame = new LongOpenHashSet(256);
    @NotNull
    private static final LongOpenHashSet activeFramebuffers = new LongOpenHashSet(256);
    private static long frameCounter;
    @NotNull
    private static final LinkedList<FramebufferStackEntry> framebufferStack;

    private FramebufferPool() {
    }

    @Nullable
    public final TextureTarget acquire(int width, int height) {
        int w = RangesKt.coerceIn((int)width, (int)1, (int)Math.min(8192, 8192));
        int h = RangesKt.coerceIn((int)height, (int)1, (int)Math.min(8192, 8192));
        long key = this.packDimensions(w, h);
        int nestingLevel = 0;
        for (FramebufferStackEntry entry : CollectionsKt.reversed((Iterable)framebufferStack)) {
            long entryKey = entry.getKey() & 0x3FFFFFFL;
            if (entryKey != key) continue;
            ++nestingLevel;
            break;
        }
        if (nestingLevel > 0) {
            key |= ((long)nestingLevel & 0x3FFFFFFFFL) << 26;
        }
        Integer previousFramebuffer = nestingLevel > 0 ? Integer.valueOf(GlStateManager.getBoundFramebuffer()) : null;
        Matrix4f savedProjectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        VertexSorting savedVertexSorting = RenderSystem.getVertexSorting();
        if (activeFramebuffers.contains(key)) {
            CCHolo.log.warn("Refusing to acquire framebuffer " + w + " x " + h + " - already active (nested frame?)");
            return null;
        }
        usedThisFrame.add(key);
        PooledFramebuffer pooled = (PooledFramebuffer)pool.get(key);
        if (pooled != null) {
            pooled.setLastUsedFrame(frameCounter);
            pooled.setSavedProjectionMatrix(savedProjectionMatrix);
            pooled.setSavedVertexSorting(savedVertexSorting);
            activeFramebuffers.add(key);
            Intrinsics.checkNotNull((Object)savedVertexSorting);
            framebufferStack.addLast(new FramebufferStackEntry(key, previousFramebuffer, savedProjectionMatrix, savedVertexSorting));
            return pooled.getFramebuffer();
        }
        if (pool.size() >= 256) {
            CCHolo.log.warn("Framebuffer pool is full (" + pool.size() + "/256), refusing to create " + w + " x " + h + " framebuffer");
            return null;
        }
        CCHolo.log.debug("Creating framebuffer with size " + w + " x " + h + " (pool size: " + (pool.size() + 1) + "/256)");
        TextureTarget framebuffer = new TextureTarget(w, h, true, true);
        Intrinsics.checkNotNull((Object)savedVertexSorting);
        pool.put(key, (Object)new PooledFramebuffer(framebuffer, frameCounter, savedProjectionMatrix, savedVertexSorting));
        activeFramebuffers.add(key);
        framebufferStack.addLast(new FramebufferStackEntry(key, previousFramebuffer, savedProjectionMatrix, savedVertexSorting));
        return framebuffer;
    }

    @NotNull
    public final Pair<Integer, Pair<Matrix4f, VertexSorting>> release() {
        if (framebufferStack.isEmpty()) {
            return new Pair(null, null);
        }
        FramebufferStackEntry entry = framebufferStack.removeLast();
        activeFramebuffers.remove(entry.getKey());
        Pair projectionState = TuplesKt.to((Object)entry.getSavedProjectionMatrix(), (Object)entry.getSavedVertexSorting());
        return new Pair((Object)entry.getPreviousFramebuffer(), (Object)projectionState);
    }

    public final void beginFrame() {
        long l = frameCounter;
        frameCounter = l + 1L;
        usedThisFrame.clear();
    }

    public final void endFrame() {
        ObjectIterator objectIterator = pool.long2ObjectEntrySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator iterator = objectIterator;
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long key = entry.getLongKey();
            PooledFramebuffer pooled = (PooledFramebuffer)entry.getValue();
            if (usedThisFrame.contains(key) || frameCounter - pooled.getLastUsedFrame() <= 1800L) continue;
            Pair<Integer, Integer> pair = this.unpackDimensions(key);
            int width = ((Number)pair.component1()).intValue();
            int height = ((Number)pair.component2()).intValue();
            CCHolo.log.debug("Disposing unused framebuffer " + width + " x " + height + " (last used " + (frameCounter - pooled.getLastUsedFrame()) + " frames ago)");
            pooled.getFramebuffer().destroyBuffers();
            iterator.remove();
        }
    }

    public final void clear() {
        Collection collection = pool.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PooledFramebuffer it = (PooledFramebuffer)element$iv;
            boolean bl = false;
            it.getFramebuffer().destroyBuffers();
        }
        pool.clear();
        usedThisFrame.clear();
        activeFramebuffers.clear();
        framebufferStack.clear();
    }

    private final long packDimensions(int width, int height) {
        return ((long)width & 0x1FFFL) << 13 | (long)height & 0x1FFFL;
    }

    private final Pair<Integer, Integer> unpackDimensions(long key) {
        int width = (int)(key >> 13 & 0x1FFFL);
        int height = (int)(key & 0x1FFFL);
        return TuplesKt.to((Object)width, (Object)height);
    }

    static {
        framebufferStack = new LinkedList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J8\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lsh/lem/ccholo/objects/renderers/FramebufferPool$FramebufferStackEntry;", "", "key", "", "previousFramebuffer", "", "savedProjectionMatrix", "Lorg/joml/Matrix4f;", "savedVertexSorting", "Lcom/mojang/blaze3d/vertex/VertexSorting;", "<init>", "(JLjava/lang/Integer;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/vertex/VertexSorting;)V", "getKey", "()J", "getPreviousFramebuffer", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSavedProjectionMatrix", "()Lorg/joml/Matrix4f;", "getSavedVertexSorting", "()Lcom/mojang/blaze3d/vertex/VertexSorting;", "component1", "component2", "component3", "component4", "copy", "(JLjava/lang/Integer;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/vertex/VertexSorting;)Lsh/lem/ccholo/objects/renderers/FramebufferPool$FramebufferStackEntry;", "equals", "", "other", "hashCode", "toString", "", "CC-Holo"})
    public static final class FramebufferStackEntry {
        private final long key;
        @Nullable
        private final Integer previousFramebuffer;
        @NotNull
        private final Matrix4f savedProjectionMatrix;
        @NotNull
        private final VertexSorting savedVertexSorting;

        public FramebufferStackEntry(long key, @Nullable Integer previousFramebuffer, @NotNull Matrix4f savedProjectionMatrix, @NotNull VertexSorting savedVertexSorting) {
            Intrinsics.checkNotNullParameter((Object)savedProjectionMatrix, (String)"savedProjectionMatrix");
            Intrinsics.checkNotNullParameter((Object)savedVertexSorting, (String)"savedVertexSorting");
            this.key = key;
            this.previousFramebuffer = previousFramebuffer;
            this.savedProjectionMatrix = savedProjectionMatrix;
            this.savedVertexSorting = savedVertexSorting;
        }

        public final long getKey() {
            return this.key;
        }

        @Nullable
        public final Integer getPreviousFramebuffer() {
            return this.previousFramebuffer;
        }

        @NotNull
        public final Matrix4f getSavedProjectionMatrix() {
            return this.savedProjectionMatrix;
        }

        @NotNull
        public final VertexSorting getSavedVertexSorting() {
            return this.savedVertexSorting;
        }

        public final long component1() {
            return this.key;
        }

        @Nullable
        public final Integer component2() {
            return this.previousFramebuffer;
        }

        @NotNull
        public final Matrix4f component3() {
            return this.savedProjectionMatrix;
        }

        @NotNull
        public final VertexSorting component4() {
            return this.savedVertexSorting;
        }

        @NotNull
        public final FramebufferStackEntry copy(long key, @Nullable Integer previousFramebuffer, @NotNull Matrix4f savedProjectionMatrix, @NotNull VertexSorting savedVertexSorting) {
            Intrinsics.checkNotNullParameter((Object)savedProjectionMatrix, (String)"savedProjectionMatrix");
            Intrinsics.checkNotNullParameter((Object)savedVertexSorting, (String)"savedVertexSorting");
            return new FramebufferStackEntry(key, previousFramebuffer, savedProjectionMatrix, savedVertexSorting);
        }

        public static /* synthetic */ FramebufferStackEntry copy$default(FramebufferStackEntry framebufferStackEntry, long l, Integer n, Matrix4f matrix4f, VertexSorting vertexSorting, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = framebufferStackEntry.key;
            }
            if ((n2 & 2) != 0) {
                n = framebufferStackEntry.previousFramebuffer;
            }
            if ((n2 & 4) != 0) {
                matrix4f = framebufferStackEntry.savedProjectionMatrix;
            }
            if ((n2 & 8) != 0) {
                vertexSorting = framebufferStackEntry.savedVertexSorting;
            }
            return framebufferStackEntry.copy(l, n, matrix4f, vertexSorting);
        }

        @NotNull
        public String toString() {
            return "FramebufferStackEntry(key=" + this.key + ", previousFramebuffer=" + this.previousFramebuffer + ", savedProjectionMatrix=" + this.savedProjectionMatrix + ", savedVertexSorting=" + this.savedVertexSorting + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.key);
            result = result * 31 + (this.previousFramebuffer == null ? 0 : ((Object)this.previousFramebuffer).hashCode());
            result = result * 31 + this.savedProjectionMatrix.hashCode();
            result = result * 31 + this.savedVertexSorting.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FramebufferStackEntry)) {
                return false;
            }
            FramebufferStackEntry framebufferStackEntry = (FramebufferStackEntry)other;
            if (this.key != framebufferStackEntry.key) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previousFramebuffer, (Object)framebufferStackEntry.previousFramebuffer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.savedProjectionMatrix, (Object)framebufferStackEntry.savedProjectionMatrix)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.savedVertexSorting, (Object)framebufferStackEntry.savedVertexSorting);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J1\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lsh/lem/ccholo/objects/renderers/FramebufferPool$PooledFramebuffer;", "", "framebuffer", "Lcom/mojang/blaze3d/pipeline/TextureTarget;", "lastUsedFrame", "", "savedProjectionMatrix", "Lorg/joml/Matrix4f;", "savedVertexSorting", "Lcom/mojang/blaze3d/vertex/VertexSorting;", "<init>", "(Lcom/mojang/blaze3d/pipeline/TextureTarget;JLorg/joml/Matrix4f;Lcom/mojang/blaze3d/vertex/VertexSorting;)V", "getFramebuffer", "()Lcom/mojang/blaze3d/pipeline/TextureTarget;", "getLastUsedFrame", "()J", "setLastUsedFrame", "(J)V", "getSavedProjectionMatrix", "()Lorg/joml/Matrix4f;", "setSavedProjectionMatrix", "(Lorg/joml/Matrix4f;)V", "getSavedVertexSorting", "()Lcom/mojang/blaze3d/vertex/VertexSorting;", "setSavedVertexSorting", "(Lcom/mojang/blaze3d/vertex/VertexSorting;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "CC-Holo"})
    public static final class PooledFramebuffer {
        @NotNull
        private final TextureTarget framebuffer;
        private long lastUsedFrame;
        @NotNull
        private Matrix4f savedProjectionMatrix;
        @NotNull
        private VertexSorting savedVertexSorting;

        public PooledFramebuffer(@NotNull TextureTarget framebuffer, long lastUsedFrame, @NotNull Matrix4f savedProjectionMatrix, @NotNull VertexSorting savedVertexSorting) {
            Intrinsics.checkNotNullParameter((Object)framebuffer, (String)"framebuffer");
            Intrinsics.checkNotNullParameter((Object)savedProjectionMatrix, (String)"savedProjectionMatrix");
            Intrinsics.checkNotNullParameter((Object)savedVertexSorting, (String)"savedVertexSorting");
            this.framebuffer = framebuffer;
            this.lastUsedFrame = lastUsedFrame;
            this.savedProjectionMatrix = savedProjectionMatrix;
            this.savedVertexSorting = savedVertexSorting;
        }

        @NotNull
        public final TextureTarget getFramebuffer() {
            return this.framebuffer;
        }

        public final long getLastUsedFrame() {
            return this.lastUsedFrame;
        }

        public final void setLastUsedFrame(long l) {
            this.lastUsedFrame = l;
        }

        @NotNull
        public final Matrix4f getSavedProjectionMatrix() {
            return this.savedProjectionMatrix;
        }

        public final void setSavedProjectionMatrix(@NotNull Matrix4f matrix4f) {
            Intrinsics.checkNotNullParameter((Object)matrix4f, (String)"<set-?>");
            this.savedProjectionMatrix = matrix4f;
        }

        @NotNull
        public final VertexSorting getSavedVertexSorting() {
            return this.savedVertexSorting;
        }

        public final void setSavedVertexSorting(@NotNull VertexSorting vertexSorting) {
            Intrinsics.checkNotNullParameter((Object)vertexSorting, (String)"<set-?>");
            this.savedVertexSorting = vertexSorting;
        }

        @NotNull
        public final TextureTarget component1() {
            return this.framebuffer;
        }

        public final long component2() {
            return this.lastUsedFrame;
        }

        @NotNull
        public final Matrix4f component3() {
            return this.savedProjectionMatrix;
        }

        @NotNull
        public final VertexSorting component4() {
            return this.savedVertexSorting;
        }

        @NotNull
        public final PooledFramebuffer copy(@NotNull TextureTarget framebuffer, long lastUsedFrame, @NotNull Matrix4f savedProjectionMatrix, @NotNull VertexSorting savedVertexSorting) {
            Intrinsics.checkNotNullParameter((Object)framebuffer, (String)"framebuffer");
            Intrinsics.checkNotNullParameter((Object)savedProjectionMatrix, (String)"savedProjectionMatrix");
            Intrinsics.checkNotNullParameter((Object)savedVertexSorting, (String)"savedVertexSorting");
            return new PooledFramebuffer(framebuffer, lastUsedFrame, savedProjectionMatrix, savedVertexSorting);
        }

        public static /* synthetic */ PooledFramebuffer copy$default(PooledFramebuffer pooledFramebuffer, TextureTarget textureTarget, long l, Matrix4f matrix4f, VertexSorting vertexSorting, int n, Object object) {
            if ((n & 1) != 0) {
                textureTarget = pooledFramebuffer.framebuffer;
            }
            if ((n & 2) != 0) {
                l = pooledFramebuffer.lastUsedFrame;
            }
            if ((n & 4) != 0) {
                matrix4f = pooledFramebuffer.savedProjectionMatrix;
            }
            if ((n & 8) != 0) {
                vertexSorting = pooledFramebuffer.savedVertexSorting;
            }
            return pooledFramebuffer.copy(textureTarget, l, matrix4f, vertexSorting);
        }

        @NotNull
        public String toString() {
            return "PooledFramebuffer(framebuffer=" + this.framebuffer + ", lastUsedFrame=" + this.lastUsedFrame + ", savedProjectionMatrix=" + this.savedProjectionMatrix + ", savedVertexSorting=" + this.savedVertexSorting + ")";
        }

        public int hashCode() {
            int result = this.framebuffer.hashCode();
            result = result * 31 + Long.hashCode(this.lastUsedFrame);
            result = result * 31 + this.savedProjectionMatrix.hashCode();
            result = result * 31 + this.savedVertexSorting.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PooledFramebuffer)) {
                return false;
            }
            PooledFramebuffer pooledFramebuffer = (PooledFramebuffer)other;
            if (!Intrinsics.areEqual((Object)this.framebuffer, (Object)pooledFramebuffer.framebuffer)) {
                return false;
            }
            if (this.lastUsedFrame != pooledFramebuffer.lastUsedFrame) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.savedProjectionMatrix, (Object)pooledFramebuffer.savedProjectionMatrix)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.savedVertexSorting, (Object)pooledFramebuffer.savedVertexSorting);
        }
    }
}

