/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.canvas;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasHandlerServer;
import sh.lem.ccholo.canvas.CanvasRoot;
import sh.lem.ccholo.canvas.CanvasRootClient;
import sh.lem.ccholo.networking.CCHoloPacketHandler;
import sh.lem.ccholo.networking.S2CCanvasCaptureStatePacket;
import sh.lem.ccholo.networking.S2CCanvasInitPacket;
import sh.lem.ccholo.networking.S2CCanvasRemovePacket;
import sh.lem.ccholo.networking.S2CCanvasUpdatePacket;
import sh.lem.ccholo.objects.BaseObject;
import sh.lem.ccholo.objects.ObjectGroup;
import sh.lem.ccholo.objects.object2d.Dot2d;
import sh.lem.ccholo.objects.object2d.Frame2d;
import sh.lem.ccholo.objects.object2d.Item2d;
import sh.lem.ccholo.objects.object2d.Line2d;
import sh.lem.ccholo.objects.object2d.Lines2d;
import sh.lem.ccholo.objects.object2d.ObjectGroup2d;
import sh.lem.ccholo.objects.object2d.Polygon2d;
import sh.lem.ccholo.objects.object2d.Rectangle2d;
import sh.lem.ccholo.objects.object2d.Text2d;
import sh.lem.ccholo.objects.object2d.Triangle2d;
import sh.lem.ccholo.objects.object3d.Origin3d;
import sh.lem.ccholo.peripheral.HologramPeripheral;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0019\u001a\u00020\u0005J\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\bJ\u000e\u0010(\u001a\u00020#2\u0006\u0010'\u001a\u00020\bJ\u000e\u0010)\u001a\u00020#2\u0006\u0010'\u001a\u00020*J \u0010+\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u0010-\u001a\u00020.J \u0010/\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u00100\u001a\u00020.J \u00101\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u00102\u001a\u00020\u0005J \u00103\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u00102\u001a\u00020\u0005J\u0018\u00104\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020%J'\u00105\u001a\u00020#2\u0006\u00106\u001a\u0002072\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020:09\"\u00020:\u00a2\u0006\u0002\u0010;J/\u0010<\u001a\u00020#2\u0006\u00106\u001a\u0002072\u0006\u0010$\u001a\u00020%2\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020:09\"\u00020:\u00a2\u0006\u0002\u0010=J\u0015\u0010>\u001a\u00020#2\u0006\u0010,\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b?J\u0010\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020\u0005H\u0002J\u0010\u0010B\u001a\u00020#2\u0006\u0010\u0006\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006C"}, d2={"Lsh/lem/ccholo/canvas/CanvasRootServer;", "Lsh/lem/ccholo/canvas/CanvasRoot;", "<init>", "()V", "rootId", "", "objects", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lsh/lem/ccholo/objects/BaseObject;", "childrenOf", "Lit/unimi/dsi/fastutil/ints/IntSet;", "removed", "listeners", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lsh/lem/ccholo/peripheral/HologramPeripheral;", "lastId", "Ljava/util/concurrent/atomic/AtomicInteger;", "canvas2d", "Lsh/lem/ccholo/objects/object2d/Frame2d;", "getCanvas2d", "()Lsh/lem/ccholo/objects/object2d/Frame2d;", "canvas3d", "Lsh/lem/ccholo/objects/object3d/Origin3d;", "getCanvas3d", "()Lsh/lem/ccholo/objects/object3d/Origin3d;", "newObjectId", "makeInitPacket", "Lsh/lem/ccholo/networking/S2CCanvasInitPacket;", "makeRemovePacket", "Lsh/lem/ccholo/networking/S2CCanvasRemovePacket;", "makeUpdatePacket", "Lsh/lem/ccholo/networking/S2CCanvasUpdatePacket;", "makeCaptureStatePacket", "Lsh/lem/ccholo/networking/S2CCanvasCaptureStatePacket;", "sendCaptureStatePacket", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "add", "obj", "remove", "clear", "Lsh/lem/ccholo/objects/ObjectGroup;", "startCapture", "peripheral", "includeMouseMove", "", "stopCapture", "sendPacket", "startKeyCapture", "keyCode", "stopKeyCapture", "clearKeyCaptures", "queueEvent", "event", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "queuePlayerEvent", "(Ljava/lang/String;Lnet/minecraft/server/level/ServerPlayer;[Ljava/lang/Object;)V", "removeListener", "removeListener$CC_Holo", "removeImpl", "id", "clearImpl", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nCanvasRootServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasRootServer.kt\nsh/lem/ccholo/canvas/CanvasRootServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n1#2:204\n1863#3,2:205\n*S KotlinDebug\n*F\n+ 1 CanvasRootServer.kt\nsh/lem/ccholo/canvas/CanvasRootServer\n*L\n171#1:205,2\n*E\n"})
public final class CanvasRootServer
extends CanvasRoot {
    private final int rootId = CanvasHandlerServer.INSTANCE.nextId();
    @NotNull
    private final Int2ObjectMap<BaseObject> objects = (Int2ObjectMap)new Int2ObjectOpenHashMap();
    @NotNull
    private final Int2ObjectMap<IntSet> childrenOf = (Int2ObjectMap)new Int2ObjectOpenHashMap();
    @NotNull
    private final IntSet removed = (IntSet)new IntOpenHashSet();
    @NotNull
    private final ObjectOpenHashSet<HologramPeripheral> listeners = new ObjectOpenHashSet();
    @NotNull
    private final AtomicInteger lastId = new AtomicInteger(1);
    @NotNull
    private final Frame2d canvas2d = new Frame2d(this){
        private final int id;
        private final CanvasRootServer canvasRoot;
        {
            this.canvasRoot = $receiver;
        }

        public int getId() {
            return this.id;
        }

        public CanvasRootServer getCanvasRoot() {
            return this.canvasRoot;
        }

        public int getWidth() {
            return Frame2d.DefaultImpls.getWidth(this);
        }

        public int getHeight() {
            return Frame2d.DefaultImpls.getHeight(this);
        }

        @LuaFunction
        public MethodResult getSize() {
            return Frame2d.DefaultImpls.getSize(this);
        }

        @LuaFunction
        public Rectangle2d addRectangle(IArguments args) {
            return Frame2d.DefaultImpls.addRectangle(this, args);
        }

        @LuaFunction
        public Line2d addLine(IArguments args) {
            return Frame2d.DefaultImpls.addLine(this, args);
        }

        @LuaFunction
        public Dot2d addDot(IArguments args) {
            return Frame2d.DefaultImpls.addDot(this, args);
        }

        @LuaFunction
        public Text2d addText(IArguments args) {
            return Frame2d.DefaultImpls.addText(this, args);
        }

        @LuaFunction
        public Triangle2d addTriangle(IArguments args) {
            return Frame2d.DefaultImpls.addTriangle(this, args);
        }

        @LuaFunction
        public Polygon2d addPolygon(IArguments args) {
            return Frame2d.DefaultImpls.addPolygon(this, args);
        }

        @LuaFunction
        public Lines2d addLines(IArguments args) {
            return Frame2d.DefaultImpls.addLines(this, args);
        }

        @LuaFunction
        public Item2d addItem(IArguments args) {
            return Frame2d.DefaultImpls.addItem(this, args);
        }

        @LuaFunction
        public ObjectGroup2d addGroup(IArguments args) {
            return Frame2d.DefaultImpls.addGroup(this, args);
        }

        public CanvasRootClient getCanvasRootClient() {
            return Frame2d.DefaultImpls.getCanvasRootClient(this);
        }

        public CanvasRootServer getCanvasRootServer() {
            return Frame2d.DefaultImpls.getCanvasRootServer(this);
        }

        @LuaFunction
        public void clear() {
            Frame2d.DefaultImpls.clear(this);
        }
    };
    @NotNull
    private final Origin3d canvas3d = new Origin3d(this){
        private final int id;
        private final CanvasRootServer canvasRoot;
        {
            this.id = 1;
            this.canvasRoot = $receiver;
        }

        public int getId() {
            return this.id;
        }

        public CanvasRootServer getCanvasRoot() {
            return this.canvasRoot;
        }
    };

    public CanvasRootServer() {
        this.childrenOf.put(0, (Object)new IntOpenHashSet());
        this.childrenOf.put(1, (Object)new IntOpenHashSet());
    }

    @NotNull
    public final Frame2d getCanvas2d() {
        return this.canvas2d;
    }

    @NotNull
    public final Origin3d getCanvas3d() {
        return this.canvas3d;
    }

    public final int newObjectId() {
        return this.lastId.incrementAndGet();
    }

    @Nullable
    public final synchronized S2CCanvasInitPacket makeInitPacket() {
        S2CCanvasInitPacket s2CCanvasInitPacket;
        try {
            Collection collection = this.objects.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            s2CCanvasInitPacket = new S2CCanvasInitPacket(this.rootId, collection, this.getCapturing(), this.getCapturingMouseMove(), (IntSet)this.getKeyCaptures());
        }
        catch (Exception e) {
            CCHolo.log.error("Error while making add packet. Object list was abandoned", (Throwable)e);
            s2CCanvasInitPacket = null;
        }
        return s2CCanvasInitPacket;
    }

    @NotNull
    public final synchronized S2CCanvasRemovePacket makeRemovePacket() {
        return new S2CCanvasRemovePacket(this.rootId);
    }

    @Nullable
    public final synchronized S2CCanvasUpdatePacket makeUpdatePacket() {
        try {
            List changed = null;
            ObjectIterator objectIterator = ((ObjectCollection)this.objects.values()).iterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
            ObjectIterator objectIterator2 = objectIterator;
            while (objectIterator2.hasNext()) {
                BaseObject obj = (BaseObject)objectIterator2.next();
                try {
                    BaseObject baseObject = obj;
                    Intrinsics.checkNotNull((Object)baseObject);
                    if (!baseObject.pollDirty()) continue;
                    if (changed == null) {
                        changed = new ArrayList();
                    }
                    changed.add(obj);
                }
                catch (Exception e) {
                    CCHolo.log.error("Error while polling object for changes. Object was skipped", (Throwable)e);
                }
            }
            if (changed == null && this.removed.isEmpty()) {
                return null;
            }
            if (changed == null) {
                changed = new ArrayList();
            }
            int[] nArray = this.removed.toIntArray();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"toIntArray(...)");
            S2CCanvasUpdatePacket packet = new S2CCanvasUpdatePacket(this.rootId, changed, nArray);
            this.removed.clear();
            return packet;
        }
        catch (Exception e) {
            CCHolo.log.error("Error while making update packet. Changelist was abandoned", (Throwable)e);
            return null;
        }
    }

    private final synchronized S2CCanvasCaptureStatePacket makeCaptureStatePacket() {
        return new S2CCanvasCaptureStatePacket(this.rootId, this.getCapturing(), this.getCapturingMouseMove(), (IntSet)this.getKeyCaptures());
    }

    private final void sendCaptureStatePacket(ServerPlayer player) {
        CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(() -> CanvasRootServer.sendCaptureStatePacket$lambda$0(player)), (Object)this.makeCaptureStatePacket());
    }

    public final synchronized void add(@NotNull BaseObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        IntSet intSet = (IntSet)this.childrenOf.get(obj.getParent());
        if (intSet == null) {
            throw new IllegalArgumentException("No such parent");
        }
        IntSet parent = intSet;
        if (!(this.objects.put(obj.getId(), (Object)obj) == null)) {
            boolean bl = false;
            String string = "An object already exists with that key";
            throw new IllegalStateException(string.toString());
        }
        parent.add(obj.getId());
        if (obj instanceof ObjectGroup) {
            this.childrenOf.put(((ObjectGroup)((Object)obj)).getId(), (Object)new IntOpenHashSet());
        }
    }

    public final synchronized void remove(@NotNull BaseObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (!this.removeImpl(obj.getId())) {
            boolean bl = false;
            String string = "No such object with this key";
            throw new IllegalStateException(string.toString());
        }
    }

    public final synchronized void clear(@NotNull ObjectGroup obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        IntSet intSet = (IntSet)this.childrenOf.get(obj.getId());
        if (intSet == null) {
            throw new IllegalStateException("Object has no children");
        }
        IntSet children = intSet;
        this.clearImpl(children);
    }

    public final synchronized void startCapture(@Nullable HologramPeripheral peripheral, @NotNull ServerPlayer player, boolean includeMouseMove) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HologramPeripheral hologramPeripheral = peripheral;
        if (hologramPeripheral != null) {
            HologramPeripheral it = hologramPeripheral;
            boolean bl = false;
            this.listeners.add((Object)it);
        }
        if (this.getCapturing()) {
            this.queuePlayerEvent("hologram_capture_stop", player, new Object[0]);
        }
        this.setCapturing(true);
        this.setCapturingMouseMove(includeMouseMove);
        this.sendCaptureStatePacket(player);
    }

    public final synchronized void stopCapture(@Nullable HologramPeripheral peripheral, @NotNull ServerPlayer player, boolean sendPacket) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HologramPeripheral hologramPeripheral = peripheral;
        if (hologramPeripheral != null) {
            HologramPeripheral it = hologramPeripheral;
            boolean bl = false;
            this.listeners.add((Object)it);
        }
        if (!this.getCapturing()) {
            return;
        }
        this.setCapturing(false);
        this.setCapturingMouseMove(false);
        this.queuePlayerEvent("hologram_capture_stop", player, new Object[0]);
        if (sendPacket) {
            this.sendCaptureStatePacket(player);
        }
    }

    public final synchronized void startKeyCapture(@Nullable HologramPeripheral peripheral, @NotNull ServerPlayer player, int keyCode) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HologramPeripheral hologramPeripheral = peripheral;
        if (hologramPeripheral != null) {
            HologramPeripheral it = hologramPeripheral;
            boolean bl = false;
            this.listeners.add((Object)it);
        }
        this.getKeyCaptures().add(keyCode);
        this.sendCaptureStatePacket(player);
    }

    public final synchronized void stopKeyCapture(@Nullable HologramPeripheral peripheral, @NotNull ServerPlayer player, int keyCode) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HologramPeripheral hologramPeripheral = peripheral;
        if (hologramPeripheral != null) {
            HologramPeripheral it = hologramPeripheral;
            boolean bl = false;
            this.listeners.add((Object)it);
        }
        this.getKeyCaptures().remove(keyCode);
        this.sendCaptureStatePacket(player);
    }

    public final synchronized void clearKeyCaptures(@Nullable HologramPeripheral peripheral, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HologramPeripheral hologramPeripheral = peripheral;
        if (hologramPeripheral != null) {
            HologramPeripheral it = hologramPeripheral;
            boolean bl = false;
            this.listeners.add((Object)it);
        }
        this.getKeyCaptures().clear();
        this.sendCaptureStatePacket(player);
    }

    public final void queueEvent(@NotNull String event, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Iterable $this$forEach$iv = (Iterable)this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HologramPeripheral it = (HologramPeripheral)element$iv;
            boolean bl = false;
            it.queueEvent(event, Arrays.copyOf(args, args.length));
        }
    }

    public final void queuePlayerEvent(@NotNull String event, @NotNull ServerPlayer player, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)player.getGameProfile().getName());
        spreadBuilder.add((Object)player.getGameProfile().getId().toString());
        spreadBuilder.addSpread((Object)args);
        this.queueEvent(event, spreadBuilder.toArray(new Object[spreadBuilder.size()]));
    }

    public final void removeListener$CC_Holo(@NotNull HologramPeripheral peripheral) {
        Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
        this.listeners.remove((Object)peripheral);
    }

    private final boolean removeImpl(int id) {
        IntSet children;
        if (this.objects.remove(id) == null) {
            return false;
        }
        IntSet intSet = children = (IntSet)this.childrenOf.remove(id);
        if (intSet != null) {
            IntSet it = intSet;
            boolean bl = false;
            this.clearImpl(it);
        }
        this.removed.add(id);
        return true;
    }

    private final void clearImpl(IntSet objects) {
        IntIterator intIterator = objects.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator = intIterator;
        while (iterator.hasNext()) {
            int childId = iterator.nextInt();
            this.removeImpl(childId);
            iterator.remove();
        }
    }

    private static final ServerPlayer sendCaptureStatePacket$lambda$0(ServerPlayer $player) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        return $player;
    }
}

