/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasHandlerServer;
import sh.lem.ccholo.canvas.CanvasRootServer;
import sh.lem.ccholo.objects.object2d.Frame2d;
import sh.lem.ccholo.objects.object3d.WrappedOrigin3d;
import sh.lem.ccholo.peripheral.HologramBlockEntity;
import sh.lem.ccholo.util.ArgumentExtKt;
import sh.lem.ccholo.util.CCAttachedComputerSet;
import sh.lem.ccholo.util.UtilsKt;
import sh.lem.ccholo.util.VecExtKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\rH\u0007J\b\u0010\u0018\u001a\u00020\u000bH\u0007J\u001e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\rH\u0007J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\rH\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J'\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\r2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0+\"\u00020,\u00a2\u0006\u0002\u0010-J\u0006\u0010.\u001a\u00020$J\b\u0010/\u001a\u00020\rH\u0016J\u0013\u00100\u001a\u00020\u001c2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lsh/lem/ccholo/peripheral/HologramPeripheral;", "Ldan200/computercraft/api/peripheral/IPeripheral;", "blockEntity", "Lsh/lem/ccholo/peripheral/HologramBlockEntity;", "<init>", "(Lsh/lem/ccholo/peripheral/HologramBlockEntity;)V", "getBlockEntity", "()Lsh/lem/ccholo/peripheral/HologramBlockEntity;", "attachedComputers", "Lsh/lem/ccholo/util/CCAttachedComputerSet;", "getPosition", "Ldan200/computercraft/api/lua/MethodResult;", "getDimension", "", "getPlayerCanvasRoot", "Lkotlin/Pair;", "Lnet/minecraft/server/level/ServerPlayer;", "Lsh/lem/ccholo/canvas/CanvasRootServer;", "nameOrUuid", "getCanvas2d", "Lsh/lem/ccholo/objects/object2d/Frame2d;", "playerName", "getCanvas3d", "Lsh/lem/ccholo/objects/object3d/WrappedOrigin3d;", "clearAllCanvasesGlobally", "startCapture", "includeMouseMove", "Ljava/util/Optional;", "", "stopCapture", "startKeyCapture", "keyCode", "", "stopKeyCapture", "clearKeyCaptures", "attach", "", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "detach", "queueEvent", "event", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "onBreak", "getType", "equals", "other", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nHologramPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramPeripheral.kt\nsh/lem/ccholo/peripheral/HologramPeripheral\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n295#2,2:158\n*S KotlinDebug\n*F\n+ 1 HologramPeripheral.kt\nsh/lem/ccholo/peripheral/HologramPeripheral\n*L\n44#1:158,2\n*E\n"})
public final class HologramPeripheral
implements IPeripheral {
    @NotNull
    private final HologramBlockEntity blockEntity;
    @NotNull
    private final CCAttachedComputerSet attachedComputers;

    public HologramPeripheral(@NotNull HologramBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        this.blockEntity = blockEntity;
        this.attachedComputers = new CCAttachedComputerSet();
    }

    @NotNull
    public final HologramBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @LuaFunction
    @NotNull
    public final MethodResult getPosition() {
        return VecExtKt.toResult(this.blockEntity.getBlockPos());
    }

    @LuaFunction
    @NotNull
    public final String getDimension() {
        Level level = this.blockEntity.getLevel();
        return String.valueOf(level != null && (level = level.dimension()) != null ? level.location() : null);
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<ServerPlayer, CanvasRootServer> getPlayerCanvasRoot(String nameOrUuid) {
        block6: {
            block5: {
                block4: {
                    uuid = UtilsKt.tryParseUuid(nameOrUuid);
                    v0 = StringsKt.trim((CharSequence)nameOrUuid).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toLowerCase(...)");
                    name = v0;
                    var7_4 = this.blockEntity.getLevel();
                    if (var7_4 == null || (var8_5 = var7_4.players()) == null) break block5;
                    var9_6 = var8_5;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (Player)element$iv;
                        $i$a$-firstOrNull-HologramPeripheral$getPlayerCanvasRoot$player$1 = false;
                        if (Intrinsics.areEqual((Object)it.getGameProfile().getId(), (Object)uuid)) ** GOTO lbl-1000
                        v1 = it.getGameProfile().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
                        v2 = v1.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
                        if (Intrinsics.areEqual((Object)v2, (Object)name)) lbl-1000:
                        // 2 sources

                        {
                            v3 = true;
                        } else {
                            v3 = false;
                        }
                        if (!v3) continue;
                        v4 = element$iv;
                        break block4;
                    }
                    v4 = null;
                }
                v5 = v4;
                break block6;
            }
            v5 = null;
        }
        var6_12 = v5;
        v6 = var6_12 instanceof ServerPlayer != false ? (ServerPlayer)var6_12 : null;
        if (v6 == null) {
            throw new LuaException("Player '" + nameOrUuid + "' not found");
        }
        player = v6;
        root = CanvasHandlerServer.INSTANCE.getRootForPlayer(player);
        return new Pair((Object)player, (Object)root);
    }

    @LuaFunction(unsafe=true)
    @NotNull
    public final Frame2d getCanvas2d(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        CanvasRootServer root = (CanvasRootServer)this.getPlayerCanvasRoot(playerName).component2();
        return root.getCanvas2d();
    }

    @LuaFunction(unsafe=true)
    @NotNull
    public final WrappedOrigin3d getCanvas3d(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        CanvasRootServer root = (CanvasRootServer)this.getPlayerCanvasRoot(playerName).component2();
        return new WrappedOrigin3d(this, root.getCanvas3d());
    }

    @LuaFunction(unsafe=true)
    @NotNull
    public final MethodResult clearAllCanvasesGlobally() {
        CanvasHandlerServer.INSTANCE.removeAllRoots();
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(unsafe=true)
    @NotNull
    public final MethodResult startCapture(@NotNull String playerName, @NotNull Optional<Boolean> includeMouseMove) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter(includeMouseMove, (String)"includeMouseMove");
        Pair<ServerPlayer, CanvasRootServer> pair = this.getPlayerCanvasRoot(playerName);
        ServerPlayer player = (ServerPlayer)pair.component1();
        CanvasRootServer root = (CanvasRootServer)pair.component2();
        Boolean bl = includeMouseMove.orElse(false);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"orElse(...)");
        root.startCapture(this, player, bl);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(unsafe=true)
    @NotNull
    public final MethodResult stopCapture(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Pair<ServerPlayer, CanvasRootServer> pair = this.getPlayerCanvasRoot(playerName);
        ServerPlayer player = (ServerPlayer)pair.component1();
        CanvasRootServer root = (CanvasRootServer)pair.component2();
        root.stopCapture(this, player, true);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(unsafe=true)
    @NotNull
    public final MethodResult startKeyCapture(@NotNull String playerName, int keyCode) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        ArgumentExtKt.assertIntBetweenImpl(keyCode, 0, 512, "key code out of bounds (%s)");
        Pair<ServerPlayer, CanvasRootServer> pair = this.getPlayerCanvasRoot(playerName);
        ServerPlayer player = (ServerPlayer)pair.component1();
        CanvasRootServer root = (CanvasRootServer)pair.component2();
        root.startKeyCapture(this, player, keyCode);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(unsafe=true)
    @NotNull
    public final MethodResult stopKeyCapture(@NotNull String playerName, int keyCode) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        ArgumentExtKt.assertIntBetweenImpl(keyCode, 0, 512, "key code out of bounds (%s)");
        Pair<ServerPlayer, CanvasRootServer> pair = this.getPlayerCanvasRoot(playerName);
        ServerPlayer player = (ServerPlayer)pair.component1();
        CanvasRootServer root = (CanvasRootServer)pair.component2();
        root.stopKeyCapture(this, player, keyCode);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(unsafe=true)
    @NotNull
    public final MethodResult clearKeyCaptures(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Pair<ServerPlayer, CanvasRootServer> pair = this.getPlayerCanvasRoot(playerName);
        ServerPlayer player = (ServerPlayer)pair.component1();
        CanvasRootServer root = (CanvasRootServer)pair.component2();
        root.clearKeyCaptures(this, player);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    public void attach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        this.attachedComputers.add(computer);
    }

    public void detach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        this.attachedComputers.remove(computer);
    }

    public final void queueEvent(@NotNull String event, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.attachedComputers.queueEvent(event, Arrays.copyOf(args, args.length));
    }

    public final void onBreak() {
        CanvasHandlerServer.INSTANCE.removeListener(this);
    }

    @NotNull
    public String getType() {
        String string = CCHolo.Peripherals.INSTANCE.getHOLOGRAM_PERIPHERAL_ID().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof HologramPeripheral && Intrinsics.areEqual((Object)((Object)this.blockEntity), (Object)((Object)((HologramPeripheral)other).blockEntity));
    }
}

