/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.canvas;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasRootServer;
import sh.lem.ccholo.networking.CCHoloPacket;
import sh.lem.ccholo.networking.CCHoloPacketHandler;
import sh.lem.ccholo.networking.S2CCanvasInitPacket;
import sh.lem.ccholo.networking.S2CCanvasUpdatePacket;
import sh.lem.ccholo.peripheral.HologramPeripheral;

@Mod.EventBusSubscriber
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0010H\u0007J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lsh/lem/ccholo/canvas/CanvasHandlerServer;", "", "<init>", "()V", "lastId", "Ljava/util/concurrent/atomic/AtomicInteger;", "roots", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lsh/lem/ccholo/canvas/CanvasRootServer;", "nextId", "", "getRootForPlayer", "p", "Lnet/minecraft/server/level/ServerPlayer;", "onServerStarting", "", "event", "Lnet/minecraftforge/event/server/ServerAboutToStartEvent;", "onPlayerLogin", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "update", "Lnet/minecraftforge/event/TickEvent$ServerTickEvent;", "clearAllRoots", "removeListener", "listener", "Lsh/lem/ccholo/peripheral/HologramPeripheral;", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nCanvasHandlerServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasHandlerServer.kt\nsh/lem/ccholo/canvas/CanvasHandlerServer\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 ServerPacketExt.kt\nsh/lem/ccholo/networking/ServerPacketExtKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,101:1\n72#2,2:102\n10#3,2:104\n10#3,2:107\n10#3,2:110\n10#3,2:114\n1#4:106\n1863#5:109\n1864#5:112\n1863#5,2:117\n216#6:113\n217#6:116\n*S KotlinDebug\n*F\n+ 1 CanvasHandlerServer.kt\nsh/lem/ccholo/canvas/CanvasHandlerServer\n*L\n34#1:102,2\n41#1:104,2\n63#1:107,2\n75#1:110,2\n91#1:114,2\n34#1:106\n73#1:109\n73#1:112\n98#1:117,2\n86#1:113\n86#1:116\n*E\n"})
public final class CanvasHandlerServer {
    @NotNull
    public static final CanvasHandlerServer INSTANCE = new CanvasHandlerServer();
    @NotNull
    private static final AtomicInteger lastId = new AtomicInteger(0);
    @NotNull
    private static final ConcurrentHashMap<UUID, CanvasRootServer> roots = new ConcurrentHashMap();

    private CanvasHandlerServer() {
    }

    public final int nextId() {
        return lastId.getAndIncrement();
    }

    /*
     * WARNING - void declaration
     */
    @SideOnly(value=Side.SERVER)
    @NotNull
    public final CanvasRootServer getRootForPlayer(@NotNull ServerPlayer p) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        ConcurrentMap concurrentMap = roots;
        UUID key$iv = p.getGameProfile().getId();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            CanvasRootServer canvasRootServer;
            boolean bl = false;
            CCHolo.log.debug("Creating new canvas root for player {} ({})", (Object)p.getGameProfile().getName(), (Object)p.getGameProfile().getId());
            CanvasRootServer it = canvasRootServer = new CanvasRootServer();
            boolean bl2 = false;
            it.reset();
            S2CCanvasInitPacket s2CCanvasInitPacket = it.makeInitPacket();
            if (s2CCanvasInitPacket != null) {
                CCHoloPacket $this$send$iv = s2CCanvasInitPacket;
                boolean $i$f$send = false;
                CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(new Supplier(p){
                    final /* synthetic */ ServerPlayer $player;
                    {
                        this.$player = $player;
                    }

                    public final ServerPlayer get() {
                        return this.$player;
                    }
                }), (Object)$this$send$iv);
            }
            CanvasRootServer default$iv = canvasRootServer;
            boolean bl3 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (CanvasRootServer)object;
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public final void onServerStarting(@NotNull ServerAboutToStartEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CCHolo.log.debug("Clearing canvas roots map");
        roots.clear();
        lastId.set(0);
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public final void onPlayerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Player player = event.getEntity();
            ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
            if (serverPlayer == null) {
                return;
            }
            ServerPlayer p = serverPlayer;
            CanvasRootServer canvasRootServer = roots.get(p.getGameProfile().getId());
            if (canvasRootServer == null) {
                return;
            }
            CanvasRootServer root = canvasRootServer;
            CCHolo.log.debug("Player {} ({}) logged in, sending canvas init packet", (Object)p.getGameProfile().getName(), (Object)p.getGameProfile().getId());
            S2CCanvasInitPacket s2CCanvasInitPacket = root.makeInitPacket();
            if (s2CCanvasInitPacket == null) break block2;
            CCHoloPacket $this$send$iv = s2CCanvasInitPacket;
            boolean $i$f$send = false;
            CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(new /* invalid duplicate definition of identical inner class */), (Object)$this$send$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public final void update(@NotNull TickEvent.ServerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List list = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$send$iv;
            CanvasRootServer root;
            ServerPlayer p = (ServerPlayer)element$iv;
            boolean bl = false;
            if (roots.get(p.getGameProfile().getId()) == null) continue;
            S2CCanvasUpdatePacket s2CCanvasUpdatePacket = root.makeUpdatePacket();
            if (s2CCanvasUpdatePacket == null) continue;
            CCHoloPacket cCHoloPacket = s2CCanvasUpdatePacket;
            Intrinsics.checkNotNull((Object)p);
            ServerPlayer player$iv = p;
            boolean $i$f$send = false;
            CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(new /* invalid duplicate definition of identical inner class */), (Object)$this$send$iv);
        }
    }

    @SideOnly(value=Side.SERVER)
    public final void clearAllRoots() {
        CCHolo.log.debug("Resetting all canvas roots");
        Map $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ServerPlayer p;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            UUID uuid = (UUID)entry.getKey();
            CanvasRootServer root = (CanvasRootServer)entry.getValue();
            root.reset();
            if (ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(uuid) == null) continue;
            CCHolo.log.debug("Sending canvas removal packet to player {} ({})", (Object)p.getGameProfile().getName(), (Object)p.getGameProfile().getId());
            S2CCanvasInitPacket s2CCanvasInitPacket = root.makeInitPacket();
            if (s2CCanvasInitPacket == null) continue;
            CCHoloPacket $this$send$iv = s2CCanvasInitPacket;
            boolean $i$f$send = false;
            CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(new /* invalid duplicate definition of identical inner class */), (Object)$this$send$iv);
        }
    }

    @SideOnly(value=Side.SERVER)
    public final void removeListener(@NotNull HologramPeripheral listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Collection<CanvasRootServer> collection = roots.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CanvasRootServer it = (CanvasRootServer)element$iv;
            boolean bl = false;
            it.removeListener$CC_Holo(listener);
        }
    }
}

