/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.networking;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.canvas.CanvasHandlerServer;
import sh.lem.ccholo.canvas.CanvasRootServer;
import sh.lem.ccholo.networking.CCHoloPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003JE\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lsh/lem/ccholo/networking/C2SCanvasScreenSizePacket;", "Lsh/lem/ccholo/networking/CCHoloPacket;", "canvasId", "", "screenWidth", "screenHeight", "guiScaledWidth", "guiScaledHeight", "guiScale", "", "<init>", "(IIIIID)V", "getCanvasId", "()I", "getScreenWidth", "getScreenHeight", "getGuiScaledWidth", "getGuiScaledHeight", "getGuiScale", "()D", "encode", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "CC-Holo"})
public final class C2SCanvasScreenSizePacket
implements CCHoloPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int canvasId;
    private final int screenWidth;
    private final int screenHeight;
    private final int guiScaledWidth;
    private final int guiScaledHeight;
    private final double guiScale;

    public C2SCanvasScreenSizePacket(int canvasId, int screenWidth, int screenHeight, int guiScaledWidth, int guiScaledHeight, double guiScale) {
        this.canvasId = canvasId;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.guiScaledWidth = guiScaledWidth;
        this.guiScaledHeight = guiScaledHeight;
        this.guiScale = guiScale;
    }

    public /* synthetic */ C2SCanvasScreenSizePacket(int n, int n2, int n3, int n4, int n5, double d, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            n = 0;
        }
        this(n, n2, n3, n4, n5, d);
    }

    public final int getCanvasId() {
        return this.canvasId;
    }

    public final int getScreenWidth() {
        return this.screenWidth;
    }

    public final int getScreenHeight() {
        return this.screenHeight;
    }

    public final int getGuiScaledWidth() {
        return this.guiScaledWidth;
    }

    public final int getGuiScaledHeight() {
        return this.guiScaledHeight;
    }

    public final double getGuiScale() {
        return this.guiScale;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeInt(this.canvasId);
        buf.writeInt(this.screenWidth);
        buf.writeInt(this.screenHeight);
        buf.writeInt(this.guiScaledWidth);
        buf.writeInt(this.guiScaledHeight);
        buf.writeDouble(this.guiScale);
    }

    public final int component1() {
        return this.canvasId;
    }

    public final int component2() {
        return this.screenWidth;
    }

    public final int component3() {
        return this.screenHeight;
    }

    public final int component4() {
        return this.guiScaledWidth;
    }

    public final int component5() {
        return this.guiScaledHeight;
    }

    public final double component6() {
        return this.guiScale;
    }

    @NotNull
    public final C2SCanvasScreenSizePacket copy(int canvasId, int screenWidth, int screenHeight, int guiScaledWidth, int guiScaledHeight, double guiScale) {
        return new C2SCanvasScreenSizePacket(canvasId, screenWidth, screenHeight, guiScaledWidth, guiScaledHeight, guiScale);
    }

    public static /* synthetic */ C2SCanvasScreenSizePacket copy$default(C2SCanvasScreenSizePacket c2SCanvasScreenSizePacket, int n, int n2, int n3, int n4, int n5, double d, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = c2SCanvasScreenSizePacket.canvasId;
        }
        if ((n6 & 2) != 0) {
            n2 = c2SCanvasScreenSizePacket.screenWidth;
        }
        if ((n6 & 4) != 0) {
            n3 = c2SCanvasScreenSizePacket.screenHeight;
        }
        if ((n6 & 8) != 0) {
            n4 = c2SCanvasScreenSizePacket.guiScaledWidth;
        }
        if ((n6 & 0x10) != 0) {
            n5 = c2SCanvasScreenSizePacket.guiScaledHeight;
        }
        if ((n6 & 0x20) != 0) {
            d = c2SCanvasScreenSizePacket.guiScale;
        }
        return c2SCanvasScreenSizePacket.copy(n, n2, n3, n4, n5, d);
    }

    @NotNull
    public String toString() {
        return "C2SCanvasScreenSizePacket(canvasId=" + this.canvasId + ", screenWidth=" + this.screenWidth + ", screenHeight=" + this.screenHeight + ", guiScaledWidth=" + this.guiScaledWidth + ", guiScaledHeight=" + this.guiScaledHeight + ", guiScale=" + this.guiScale + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.canvasId);
        result = result * 31 + Integer.hashCode(this.screenWidth);
        result = result * 31 + Integer.hashCode(this.screenHeight);
        result = result * 31 + Integer.hashCode(this.guiScaledWidth);
        result = result * 31 + Integer.hashCode(this.guiScaledHeight);
        result = result * 31 + Double.hashCode(this.guiScale);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof C2SCanvasScreenSizePacket)) {
            return false;
        }
        C2SCanvasScreenSizePacket c2SCanvasScreenSizePacket = (C2SCanvasScreenSizePacket)other;
        if (this.canvasId != c2SCanvasScreenSizePacket.canvasId) {
            return false;
        }
        if (this.screenWidth != c2SCanvasScreenSizePacket.screenWidth) {
            return false;
        }
        if (this.screenHeight != c2SCanvasScreenSizePacket.screenHeight) {
            return false;
        }
        if (this.guiScaledWidth != c2SCanvasScreenSizePacket.guiScaledWidth) {
            return false;
        }
        if (this.guiScaledHeight != c2SCanvasScreenSizePacket.guiScaledHeight) {
            return false;
        }
        return Double.compare(this.guiScale, c2SCanvasScreenSizePacket.guiScale) == 0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u000e"}, d2={"Lsh/lem/ccholo/networking/C2SCanvasScreenSizePacket$Companion;", "", "<init>", "()V", "decode", "Lsh/lem/ccholo/networking/C2SCanvasScreenSizePacket;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "handle", "", "msg", "ctx", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "CC-Holo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final C2SCanvasScreenSizePacket decode(@NotNull FriendlyByteBuf buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return new C2SCanvasScreenSizePacket(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readDouble());
        }

        public final void handle(@NotNull C2SCanvasScreenSizePacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            NetworkEvent.Context context = ctx.get();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"get(...)");
            NetworkEvent.Context c = context;
            c.enqueueWork(() -> Companion.handle$lambda$0(c, msg));
            c.setPacketHandled(true);
        }

        private static final void handle$lambda$0(NetworkEvent.Context $c, C2SCanvasScreenSizePacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$c, (String)"$c");
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            ServerPlayer serverPlayer = $c.getSender();
            if (serverPlayer == null) {
                return;
            }
            ServerPlayer player = serverPlayer;
            CanvasRootServer root = CanvasHandlerServer.INSTANCE.getRootForPlayer(player);
            root.setScreenWidth(RangesKt.coerceAtLeast((int)$msg.getScreenWidth(), (int)1));
            root.setScreenHeight(RangesKt.coerceAtLeast((int)$msg.getScreenHeight(), (int)1));
            root.setGuiScaledWidth(RangesKt.coerceAtLeast((int)$msg.getGuiScaledWidth(), (int)1));
            root.setGuiScaledHeight(RangesKt.coerceAtLeast((int)$msg.getGuiScaledHeight(), (int)1));
            root.setGuiScale(RangesKt.coerceAtLeast((double)$msg.getGuiScale(), (double)0.1));
            if (root.pollScreenSizeDirty()) {
                Object[] objectArray = new Object[]{root.getScreenWidth(), root.getScreenHeight(), root.getGuiScaledWidth(), root.getGuiScaledHeight(), root.getGuiScale()};
                root.queuePlayerEvent("hologram_screen_size", player, objectArray);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

