/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.networking;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasHandlerClient;
import sh.lem.ccholo.networking.CCHoloPacket;
import sh.lem.ccholo.networking.CCHoloPacketHandler;
import sh.lem.ccholo.objects.BaseObject;
import sh.lem.ccholo.objects.ObjectRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003JK\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010$\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lsh/lem/ccholo/networking/S2CCanvasInitPacket;", "Lsh/lem/ccholo/networking/CCHoloPacket;", "canvasId", "", "objects", "", "Lsh/lem/ccholo/objects/BaseObject;", "capturing", "", "capturingMouseMove", "hidingMouse", "keyCaptures", "Lit/unimi/dsi/fastutil/ints/IntSet;", "<init>", "(ILjava/util/Collection;ZZZLit/unimi/dsi/fastutil/ints/IntSet;)V", "getCanvasId", "()I", "getObjects", "()Ljava/util/Collection;", "getCapturing", "()Z", "getCapturingMouseMove", "getHidingMouse", "getKeyCaptures", "()Lit/unimi/dsi/fastutil/ints/IntSet;", "encode", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "toString", "", "Companion", "CC-Holo"})
public final class S2CCanvasInitPacket
implements CCHoloPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int canvasId;
    @NotNull
    private final Collection<BaseObject> objects;
    private final boolean capturing;
    private final boolean capturingMouseMove;
    private final boolean hidingMouse;
    @NotNull
    private final IntSet keyCaptures;

    public S2CCanvasInitPacket(int canvasId, @NotNull Collection<? extends BaseObject> objects, boolean capturing, boolean capturingMouseMove, boolean hidingMouse, @NotNull IntSet keyCaptures) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)keyCaptures, (String)"keyCaptures");
        this.canvasId = canvasId;
        this.objects = objects;
        this.capturing = capturing;
        this.capturingMouseMove = capturingMouseMove;
        this.hidingMouse = hidingMouse;
        this.keyCaptures = keyCaptures;
    }

    public final int getCanvasId() {
        return this.canvasId;
    }

    @NotNull
    public final Collection<BaseObject> getObjects() {
        return this.objects;
    }

    public final boolean getCapturing() {
        return this.capturing;
    }

    public final boolean getCapturingMouseMove() {
        return this.capturingMouseMove;
    }

    public final boolean getHidingMouse() {
        return this.hidingMouse;
    }

    @NotNull
    public final IntSet getKeyCaptures() {
        return this.keyCaptures;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeInt(this.canvasId);
        buf.writeCollection(this.objects, ObjectRegistry.INSTANCE::write);
        buf.writeBoolean(this.capturing);
        buf.writeBoolean(this.capturingMouseMove);
        buf.writeBoolean(this.hidingMouse);
        buf.writeVarIntArray(this.keyCaptures.toIntArray());
    }

    public final int component1() {
        return this.canvasId;
    }

    @NotNull
    public final Collection<BaseObject> component2() {
        return this.objects;
    }

    public final boolean component3() {
        return this.capturing;
    }

    public final boolean component4() {
        return this.capturingMouseMove;
    }

    public final boolean component5() {
        return this.hidingMouse;
    }

    @NotNull
    public final IntSet component6() {
        return this.keyCaptures;
    }

    @NotNull
    public final S2CCanvasInitPacket copy(int canvasId, @NotNull Collection<? extends BaseObject> objects, boolean capturing, boolean capturingMouseMove, boolean hidingMouse, @NotNull IntSet keyCaptures) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)keyCaptures, (String)"keyCaptures");
        return new S2CCanvasInitPacket(canvasId, objects, capturing, capturingMouseMove, hidingMouse, keyCaptures);
    }

    public static /* synthetic */ S2CCanvasInitPacket copy$default(S2CCanvasInitPacket s2CCanvasInitPacket, int n, Collection collection, boolean bl, boolean bl2, boolean bl3, IntSet intSet, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = s2CCanvasInitPacket.canvasId;
        }
        if ((n2 & 2) != 0) {
            collection = s2CCanvasInitPacket.objects;
        }
        if ((n2 & 4) != 0) {
            bl = s2CCanvasInitPacket.capturing;
        }
        if ((n2 & 8) != 0) {
            bl2 = s2CCanvasInitPacket.capturingMouseMove;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = s2CCanvasInitPacket.hidingMouse;
        }
        if ((n2 & 0x20) != 0) {
            intSet = s2CCanvasInitPacket.keyCaptures;
        }
        return s2CCanvasInitPacket.copy(n, collection, bl, bl2, bl3, intSet);
    }

    @NotNull
    public String toString() {
        return "S2CCanvasInitPacket(canvasId=" + this.canvasId + ", objects=" + this.objects + ", capturing=" + this.capturing + ", capturingMouseMove=" + this.capturingMouseMove + ", hidingMouse=" + this.hidingMouse + ", keyCaptures=" + this.keyCaptures + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.canvasId);
        result = result * 31 + ((Object)this.objects).hashCode();
        result = result * 31 + Boolean.hashCode(this.capturing);
        result = result * 31 + Boolean.hashCode(this.capturingMouseMove);
        result = result * 31 + Boolean.hashCode(this.hidingMouse);
        result = result * 31 + this.keyCaptures.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof S2CCanvasInitPacket)) {
            return false;
        }
        S2CCanvasInitPacket s2CCanvasInitPacket = (S2CCanvasInitPacket)other;
        if (this.canvasId != s2CCanvasInitPacket.canvasId) {
            return false;
        }
        if (!Intrinsics.areEqual(this.objects, s2CCanvasInitPacket.objects)) {
            return false;
        }
        if (this.capturing != s2CCanvasInitPacket.capturing) {
            return false;
        }
        if (this.capturingMouseMove != s2CCanvasInitPacket.capturingMouseMove) {
            return false;
        }
        if (this.hidingMouse != s2CCanvasInitPacket.hidingMouse) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keyCaptures, (Object)s2CCanvasInitPacket.keyCaptures);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u000e"}, d2={"Lsh/lem/ccholo/networking/S2CCanvasInitPacket$Companion;", "", "<init>", "()V", "decode", "Lsh/lem/ccholo/networking/S2CCanvasInitPacket;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "handle", "", "msg", "ctx", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "CC-Holo"})
    @SourceDebugExtension(value={"SMAP\nS2CCanvasInitPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 S2CCanvasInitPacket.kt\nsh/lem/ccholo/networking/S2CCanvasInitPacket$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CCHoloPacketHandler.kt\nsh/lem/ccholo/networking/CCHoloPacketHandler\n*L\n1#1,54:1\n1#2:55\n98#3,9:56\n*S KotlinDebug\n*F\n+ 1 S2CCanvasInitPacket.kt\nsh/lem/ccholo/networking/S2CCanvasInitPacket$Companion\n*L\n43#1:56,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final S2CCanvasInitPacket decode(@NotNull FriendlyByteBuf buf) {
            void $this$decode_u24lambda_u241;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Collection collection = buf.readCollection(Companion::decode$lambda$0, ObjectRegistry.INSTANCE::read);
            List list = (List)collection;
            int n = buf.readInt();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$decode_u24lambda_u241);
            CollectionsKt.sortWith((List)$this$decode_u24lambda_u241, BaseObject.Companion.getSORTING_ORDER());
            Unit unit = Unit.INSTANCE;
            Collection collection2 = collection;
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"apply(...)");
            IntSet intSet = (IntSet)new IntOpenHashSet(buf.readVarIntArray());
            boolean bl2 = buf.readBoolean();
            boolean bl3 = buf.readBoolean();
            boolean bl4 = buf.readBoolean();
            Collection collection3 = collection2;
            int n2 = n;
            return new S2CCanvasInitPacket(n2, collection3, bl4, bl3, bl2, intSet);
        }

        public final void handle(@NotNull S2CCanvasInitPacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            CCHoloPacketHandler this_$iv = CCHoloPacketHandler.INSTANCE;
            boolean $i$f$wrapPacketHandler = false;
            try {
                boolean bl = false;
                NetworkEvent.Context context = ctx.get();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"get(...)");
                NetworkEvent.Context c = context;
                c.enqueueWork(() -> Companion.handle$lambda$5$lambda$4(msg));
                c.setPacketHandled(true);
            }
            catch (Exception e$iv) {
                CCHolo.log.error("Error while handling packet", (Throwable)e$iv);
            }
            catch (LinkageError e$iv) {
                CCHolo.log.error("Critical error while handling packet (LinkageError)", (Throwable)e$iv);
            }
            catch (VirtualMachineError e$iv) {
                CCHolo.log.error("Critical error while handling packet (VirtualMachineError)", (Throwable)e$iv);
            }
        }

        private static final List decode$lambda$0(int it) {
            return new ArrayList();
        }

        private static final void handle$lambda$5$lambda$4$lambda$3$lambda$2(S2CCanvasInitPacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            CanvasHandlerClient.INSTANCE.onCanvasInitPacket$CC_Holo($msg);
        }

        private static final Runnable handle$lambda$5$lambda$4$lambda$3(S2CCanvasInitPacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            return () -> Companion.handle$lambda$5$lambda$4$lambda$3$lambda$2($msg);
        }

        private static final void handle$lambda$5$lambda$4(S2CCanvasInitPacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Companion.handle$lambda$5$lambda$4$lambda$3($msg));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

