/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.objects.renderers.object3d;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lsh/lem/ccholo/objects/renderers/object3d/Rotatable3dRenderer;", "", "<init>", "()V", "applyRotation", "", "gg", "Lnet/minecraft/client/gui/GuiGraphics;", "rot", "Lnet/minecraft/world/phys/Vec3;", "flipPitch", "", "CC-Holo"})
public final class Rotatable3dRenderer {
    @NotNull
    public static final Rotatable3dRenderer INSTANCE = new Rotatable3dRenderer();

    private Rotatable3dRenderer() {
    }

    public final void applyRotation(@NotNull GuiGraphics gg, @Nullable Vec3 rot, boolean flipPitch) {
        Intrinsics.checkNotNullParameter((Object)gg, (String)"gg");
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = gg.pose();
        if (rot == null) {
            Camera cam = mc.gameRenderer.getMainCamera();
            poseStack.mulPose(Axis.YP.rotationDegrees((float)180 - cam.getYRot()));
            poseStack.mulPose(Axis.XP.rotationDegrees(flipPitch ? -cam.getXRot() : cam.getXRot()));
        } else {
            poseStack.mulPose(Axis.XP.rotationDegrees((float)rot.x));
            poseStack.mulPose(Axis.YP.rotationDegrees((float)rot.y));
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)rot.z));
        }
    }
}

