/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.canvas;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasHandlerServer;
import sh.lem.ccholo.canvas.CanvasRoot;
import sh.lem.ccholo.canvas.CanvasRootClient;
import sh.lem.ccholo.networking.CCHoloPacket;
import sh.lem.ccholo.networking.CCHoloPacketHandler;
import sh.lem.ccholo.networking.S2CCanvasCaptureStatePacket;
import sh.lem.ccholo.networking.S2CCanvasInitPacket;
import sh.lem.ccholo.networking.S2CCanvasOpenLinkPacket;
import sh.lem.ccholo.networking.S2CCanvasSetClipboardPacket;
import sh.lem.ccholo.networking.S2CCanvasUpdatePacket;
import sh.lem.ccholo.objects.BaseObject;
import sh.lem.ccholo.objects.ObjectGroup;
import sh.lem.ccholo.objects.object2d.Dot2d;
import sh.lem.ccholo.objects.object2d.Item2d;
import sh.lem.ccholo.objects.object2d.Line2d;
import sh.lem.ccholo.objects.object2d.Lines2d;
import sh.lem.ccholo.objects.object2d.ObjectGroup2d;
import sh.lem.ccholo.objects.object2d.Polygon2d;
import sh.lem.ccholo.objects.object2d.Rectangle2d;
import sh.lem.ccholo.objects.object2d.RootFrame2d;
import sh.lem.ccholo.objects.object2d.Text2d;
import sh.lem.ccholo.objects.object2d.Triangle2d;
import sh.lem.ccholo.objects.object3d.Origin3d;
import sh.lem.ccholo.peripheral.HologramPeripheral;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0015\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020%J\u001e\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\u0016\u0010*\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020(J\u0016\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u0005J\u0016\u0010.\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u0005J\u000e\u0010/\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u00100\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00104\u001a\u000202J'\u00105\u001a\u00020\u001d2\u0006\u00106\u001a\u0002022\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020908\"\u000209\u00a2\u0006\u0002\u0010:J/\u0010;\u001a\u00020\u001d2\u0006\u00106\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020908\"\u000209\u00a2\u0006\u0002\u0010<J\u0015\u0010=\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b?J\u0015\u0010@\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bAJ\u0010\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020\u0005H\u0002J\u0010\u0010D\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006F"}, d2={"Lsh/lem/ccholo/canvas/CanvasRootServer;", "Lsh/lem/ccholo/canvas/CanvasRoot;", "<init>", "()V", "rootId", "", "removed", "Lit/unimi/dsi/fastutil/ints/IntSet;", "lastId", "Ljava/util/concurrent/atomic/AtomicInteger;", "listeners", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lsh/lem/ccholo/peripheral/HologramPeripheral;", "canvas2d", "Lsh/lem/ccholo/objects/object2d/RootFrame2d;", "getCanvas2d", "()Lsh/lem/ccholo/objects/object2d/RootFrame2d;", "canvas3d", "Lsh/lem/ccholo/objects/object3d/Origin3d;", "getCanvas3d", "()Lsh/lem/ccholo/objects/object3d/Origin3d;", "newObjectId", "makeChildSet", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "makeInitPacket", "Lsh/lem/ccholo/networking/S2CCanvasInitPacket;", "makeUpdatePacket", "Lsh/lem/ccholo/networking/S2CCanvasUpdatePacket;", "sendCaptureStatePacket", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "add", "obj", "Lsh/lem/ccholo/objects/BaseObject;", "remove", "clear", "Lsh/lem/ccholo/objects/ObjectGroup;", "startCapture", "includeMouseMove", "", "hideMouse", "stopCapture", "sendPacket", "startKeyCapture", "keyCode", "stopKeyCapture", "clearKeyCaptures", "setClipboard", "text", "", "openLink", "url", "queueEvent", "event", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "queuePlayerEvent", "(Ljava/lang/String;Lnet/minecraft/server/level/ServerPlayer;[Ljava/lang/Object;)V", "addListener", "peripheral", "addListener$CC_Holo", "removeListener", "removeListener$CC_Holo", "removeImpl", "id", "clearImpl", "objects", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nCanvasRootServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasRootServer.kt\nsh/lem/ccholo/canvas/CanvasRootServer\n+ 2 ServerPacketExt.kt\nsh/lem/ccholo/networking/ServerPacketExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n10#2,2:198\n10#2,2:201\n10#2,2:203\n1#3:200\n1863#4,2:205\n*S KotlinDebug\n*F\n+ 1 CanvasRootServer.kt\nsh/lem/ccholo/canvas/CanvasRootServer\n*L\n88#1:198,2\n152#1:201,2\n157#1:203,2\n161#1:205,2\n*E\n"})
public final class CanvasRootServer
extends CanvasRoot {
    private final int rootId = CanvasHandlerServer.INSTANCE.nextId();
    @NotNull
    private final IntSet removed = (IntSet)new IntOpenHashSet();
    @NotNull
    private final AtomicInteger lastId = new AtomicInteger(1);
    @NotNull
    private final ObjectOpenHashSet<HologramPeripheral> listeners = new ObjectOpenHashSet();
    @NotNull
    private final RootFrame2d canvas2d = new RootFrame2d(this){
        private final int id;
        private final CanvasRootServer canvasRoot;
        {
            this.canvasRoot = $receiver;
        }

        public int getId() {
            return this.id;
        }

        public CanvasRootServer getCanvasRoot() {
            return this.canvasRoot;
        }

        @LuaFunction
        public MethodResult getScreenSize() {
            return RootFrame2d.DefaultImpls.getScreenSize(this);
        }

        public int getWidth() {
            return RootFrame2d.DefaultImpls.getWidth(this);
        }

        public int getHeight() {
            return RootFrame2d.DefaultImpls.getHeight(this);
        }

        @LuaFunction
        public MethodResult getSize() {
            return RootFrame2d.DefaultImpls.getSize(this);
        }

        @LuaFunction
        public Rectangle2d addRectangle(IArguments args) {
            return RootFrame2d.DefaultImpls.addRectangle(this, args);
        }

        @LuaFunction
        public Line2d addLine(IArguments args) {
            return RootFrame2d.DefaultImpls.addLine(this, args);
        }

        @LuaFunction
        public Dot2d addDot(IArguments args) {
            return RootFrame2d.DefaultImpls.addDot(this, args);
        }

        @LuaFunction
        public Text2d addText(IArguments args) {
            return RootFrame2d.DefaultImpls.addText(this, args);
        }

        @LuaFunction
        public Triangle2d addTriangle(IArguments args) {
            return RootFrame2d.DefaultImpls.addTriangle(this, args);
        }

        @LuaFunction
        public Polygon2d addPolygon(IArguments args) {
            return RootFrame2d.DefaultImpls.addPolygon(this, args);
        }

        @LuaFunction
        public Lines2d addLines(IArguments args) {
            return RootFrame2d.DefaultImpls.addLines(this, args);
        }

        @LuaFunction
        public Item2d addItem(IArguments args) {
            return RootFrame2d.DefaultImpls.addItem(this, args);
        }

        @LuaFunction
        public ObjectGroup2d addGroup(IArguments args) {
            return RootFrame2d.DefaultImpls.addGroup(this, args);
        }

        @LuaFunction
        public void clear() {
            RootFrame2d.DefaultImpls.clear(this);
        }

        public CanvasRootClient getCanvasRootClient() {
            return RootFrame2d.DefaultImpls.getCanvasRootClient(this);
        }

        public CanvasRootServer getCanvasRootServer() {
            return RootFrame2d.DefaultImpls.getCanvasRootServer(this);
        }
    };
    @NotNull
    private final Origin3d canvas3d = new Origin3d(this){
        private final int id;
        private final CanvasRootServer canvasRoot;
        {
            this.id = 1;
            this.canvasRoot = $receiver;
        }

        public int getId() {
            return this.id;
        }

        public CanvasRootServer getCanvasRoot() {
            return this.canvasRoot;
        }
    };

    @NotNull
    public final RootFrame2d getCanvas2d() {
        return this.canvas2d;
    }

    @NotNull
    public final Origin3d getCanvas3d() {
        return this.canvas3d;
    }

    public final int newObjectId() {
        return this.lastId.incrementAndGet();
    }

    @NotNull
    public IntOpenHashSet makeChildSet() {
        return new IntOpenHashSet();
    }

    @Nullable
    public final synchronized S2CCanvasInitPacket makeInitPacket() {
        S2CCanvasInitPacket s2CCanvasInitPacket;
        try {
            Collection collection = this.getObjects().values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            s2CCanvasInitPacket = new S2CCanvasInitPacket(this.rootId, collection, this.getCapturing(), this.getCapturingMouseMove(), this.getHidingMouse(), (IntSet)this.getKeyCaptures());
        }
        catch (Exception e) {
            CCHolo.log.error("Error while making add packet. Object list was abandoned", (Throwable)e);
            s2CCanvasInitPacket = null;
        }
        return s2CCanvasInitPacket;
    }

    @Nullable
    public final synchronized S2CCanvasUpdatePacket makeUpdatePacket() {
        try {
            List changed = null;
            ObjectIterator objectIterator = ((ObjectCollection)this.getObjects().values()).iterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
            ObjectIterator objectIterator2 = objectIterator;
            while (objectIterator2.hasNext()) {
                BaseObject obj = (BaseObject)objectIterator2.next();
                try {
                    BaseObject baseObject = obj;
                    Intrinsics.checkNotNull((Object)baseObject);
                    if (!baseObject.pollDirty()) continue;
                    if (changed == null) {
                        changed = new ArrayList();
                    }
                    changed.add(obj);
                }
                catch (Exception e) {
                    CCHolo.log.error("Error while polling object for changes. Object was skipped", (Throwable)e);
                }
            }
            if (changed == null && this.removed.isEmpty()) {
                return null;
            }
            if (changed == null) {
                changed = new ArrayList();
            }
            int[] nArray = this.removed.toIntArray();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"toIntArray(...)");
            S2CCanvasUpdatePacket packet = new S2CCanvasUpdatePacket(this.rootId, changed, nArray);
            this.removed.clear();
            return packet;
        }
        catch (Exception e) {
            CCHolo.log.error("Error while making update packet. Changelist was abandoned", (Throwable)e);
            return null;
        }
    }

    private final synchronized void sendCaptureStatePacket(ServerPlayer player) {
        CCHoloPacket $this$send$iv = new S2CCanvasCaptureStatePacket(this.rootId, this.getCapturing(), this.getCapturingMouseMove(), this.getHidingMouse(), (IntSet)this.getKeyCaptures());
        boolean $i$f$send = false;
        CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(new Supplier(player){
            final /* synthetic */ ServerPlayer $player;
            {
                this.$player = $player;
            }

            public final ServerPlayer get() {
                return this.$player;
            }
        }), (Object)$this$send$iv);
    }

    public final synchronized void add(@NotNull BaseObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        IntSet intSet = (IntSet)this.getChildrenOf().get(obj.getParent());
        if (intSet == null) {
            throw new IllegalArgumentException("No such parent");
        }
        IntSet parent = intSet;
        if (!(this.getObjects().put(obj.getId(), (Object)obj) == null)) {
            boolean bl = false;
            String string = "An object already exists with that key";
            throw new IllegalStateException(string.toString());
        }
        parent.add(obj.getId());
        if (obj instanceof ObjectGroup) {
            this.getChildrenOf().put(((ObjectGroup)((Object)obj)).getId(), (Object)new IntOpenHashSet());
        }
    }

    public final synchronized void remove(@NotNull BaseObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (!this.removeImpl(obj.getId())) {
            boolean bl = false;
            String string = "No such object with this key";
            throw new IllegalStateException(string.toString());
        }
    }

    public final synchronized void clear(@NotNull ObjectGroup obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        IntSet intSet = (IntSet)this.getChildrenOf().get(obj.getId());
        if (intSet == null) {
            throw new IllegalStateException("Object has no children");
        }
        IntSet children = intSet;
        this.clearImpl(children);
    }

    public final synchronized void startCapture(@NotNull ServerPlayer player, boolean includeMouseMove, boolean hideMouse) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.setCapturing(true);
        this.setCapturingMouseMove(includeMouseMove);
        this.setHidingMouse(hideMouse);
        this.sendCaptureStatePacket(player);
    }

    public final synchronized void stopCapture(@NotNull ServerPlayer player, boolean sendPacket) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.getCapturing()) {
            return;
        }
        this.setCapturing(false);
        this.setCapturingMouseMove(false);
        this.setHidingMouse(false);
        this.queuePlayerEvent("hologram_capture_stop", player, new Object[0]);
        if (sendPacket) {
            this.sendCaptureStatePacket(player);
        }
    }

    public final synchronized void startKeyCapture(@NotNull ServerPlayer player, int keyCode) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.getKeyCaptures().add(keyCode);
        this.sendCaptureStatePacket(player);
    }

    public final synchronized void stopKeyCapture(@NotNull ServerPlayer player, int keyCode) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.getKeyCaptures().remove(keyCode);
        this.sendCaptureStatePacket(player);
    }

    public final synchronized void clearKeyCaptures(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.getKeyCaptures().clear();
        this.sendCaptureStatePacket(player);
    }

    public final synchronized void setClipboard(@NotNull ServerPlayer player, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CCHoloPacket $this$send$iv = new S2CCanvasSetClipboardPacket(text);
        boolean $i$f$send = false;
        CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(new /* invalid duplicate definition of identical inner class */), (Object)$this$send$iv);
    }

    public final synchronized void openLink(@NotNull ServerPlayer player, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CCHoloPacket $this$send$iv = new S2CCanvasOpenLinkPacket(url);
        boolean $i$f$send = false;
        CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(new /* invalid duplicate definition of identical inner class */), (Object)$this$send$iv);
    }

    public final void queueEvent(@NotNull String event, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Iterable $this$forEach$iv = (Iterable)this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HologramPeripheral it = (HologramPeripheral)element$iv;
            boolean bl = false;
            it.queueEvent(event, Arrays.copyOf(args, args.length));
        }
    }

    public final void queuePlayerEvent(@NotNull String event, @NotNull ServerPlayer player, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)player.getGameProfile().getName());
        spreadBuilder.add((Object)player.getGameProfile().getId().toString());
        spreadBuilder.addSpread((Object)args);
        this.queueEvent(event, spreadBuilder.toArray(new Object[spreadBuilder.size()]));
    }

    public final void addListener$CC_Holo(@NotNull HologramPeripheral peripheral) {
        Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
        this.listeners.add((Object)peripheral);
    }

    public final void removeListener$CC_Holo(@NotNull HologramPeripheral peripheral) {
        Intrinsics.checkNotNullParameter((Object)peripheral, (String)"peripheral");
        this.listeners.remove((Object)peripheral);
    }

    private final boolean removeImpl(int id) {
        IntSet children;
        if (this.getObjects().remove(id) == null) {
            return false;
        }
        IntSet intSet = children = (IntSet)this.getChildrenOf().remove(id);
        if (intSet != null) {
            IntSet it = intSet;
            boolean bl = false;
            this.clearImpl(it);
        }
        this.removed.add(id);
        return true;
    }

    private final void clearImpl(IntSet objects) {
        IntIterator intIterator = objects.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator = intIterator;
        while (iterator.hasNext()) {
            int childId = iterator.nextInt();
            this.removeImpl(childId);
            iterator.remove();
        }
    }
}

