/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.networking;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasHandlerClient;
import sh.lem.ccholo.networking.CCHoloPacket;
import sh.lem.ccholo.networking.CCHoloPacketHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lsh/lem/ccholo/networking/S2CCanvasOpenLinkPacket;", "Lsh/lem/ccholo/networking/CCHoloPacket;", "url", "", "<init>", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "encode", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "CC-Holo"})
public final class S2CCanvasOpenLinkPacket
implements CCHoloPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    public static final int URL_LIMIT = 512;

    public S2CCanvasOpenLinkPacket(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeUtf(this.url);
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    @NotNull
    public final S2CCanvasOpenLinkPacket copy(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new S2CCanvasOpenLinkPacket(url);
    }

    public static /* synthetic */ S2CCanvasOpenLinkPacket copy$default(S2CCanvasOpenLinkPacket s2CCanvasOpenLinkPacket, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = s2CCanvasOpenLinkPacket.url;
        }
        return s2CCanvasOpenLinkPacket.copy(string);
    }

    @NotNull
    public String toString() {
        return "S2CCanvasOpenLinkPacket(url=" + this.url + ")";
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof S2CCanvasOpenLinkPacket)) {
            return false;
        }
        S2CCanvasOpenLinkPacket s2CCanvasOpenLinkPacket = (S2CCanvasOpenLinkPacket)other;
        return Intrinsics.areEqual((Object)this.url, (Object)s2CCanvasOpenLinkPacket.url);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lsh/lem/ccholo/networking/S2CCanvasOpenLinkPacket$Companion;", "", "<init>", "()V", "URL_LIMIT", "", "decode", "Lsh/lem/ccholo/networking/S2CCanvasOpenLinkPacket;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "handle", "", "msg", "ctx", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "CC-Holo"})
    @SourceDebugExtension(value={"SMAP\nS2CCanvasOpenLinkPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 S2CCanvasOpenLinkPacket.kt\nsh/lem/ccholo/networking/S2CCanvasOpenLinkPacket$Companion\n+ 2 CCHoloPacketHandler.kt\nsh/lem/ccholo/networking/CCHoloPacketHandler\n*L\n1#1,36:1\n98#2,9:37\n*S KotlinDebug\n*F\n+ 1 S2CCanvasOpenLinkPacket.kt\nsh/lem/ccholo/networking/S2CCanvasOpenLinkPacket$Companion\n*L\n25#1:37,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final S2CCanvasOpenLinkPacket decode(@NotNull FriendlyByteBuf buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            String string = buf.readUtf(512);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUtf(...)");
            return new S2CCanvasOpenLinkPacket(string);
        }

        public final void handle(@NotNull S2CCanvasOpenLinkPacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            CCHoloPacketHandler this_$iv = CCHoloPacketHandler.INSTANCE;
            boolean $i$f$wrapPacketHandler = false;
            try {
                boolean bl = false;
                NetworkEvent.Context context = ctx.get();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"get(...)");
                NetworkEvent.Context c = context;
                c.enqueueWork(() -> Companion.handle$lambda$3$lambda$2(msg));
                c.setPacketHandled(true);
            }
            catch (Exception e$iv) {
                CCHolo.log.error("Error while handling packet", (Throwable)e$iv);
            }
            catch (LinkageError e$iv) {
                CCHolo.log.error("Critical error while handling packet (LinkageError)", (Throwable)e$iv);
            }
            catch (VirtualMachineError e$iv) {
                CCHolo.log.error("Critical error while handling packet (VirtualMachineError)", (Throwable)e$iv);
            }
        }

        private static final void handle$lambda$3$lambda$2$lambda$1$lambda$0(S2CCanvasOpenLinkPacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            CanvasHandlerClient.INSTANCE.onCanvasOpenLinkPacket$CC_Holo($msg);
        }

        private static final Runnable handle$lambda$3$lambda$2$lambda$1(S2CCanvasOpenLinkPacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            return () -> Companion.handle$lambda$3$lambda$2$lambda$1$lambda$0($msg);
        }

        private static final void handle$lambda$3$lambda$2(S2CCanvasOpenLinkPacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Companion.handle$lambda$3$lambda$2$lambda$1($msg));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

