/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.networking;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasHandlerClient;
import sh.lem.ccholo.networking.CCHoloPacket;
import sh.lem.ccholo.networking.CCHoloPacketHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J;\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lsh/lem/ccholo/networking/S2CCanvasCaptureStatePacket;", "Lsh/lem/ccholo/networking/CCHoloPacket;", "canvasId", "", "capturing", "", "capturingMouseMove", "hidingMouse", "keyCaptures", "Lit/unimi/dsi/fastutil/ints/IntSet;", "<init>", "(IZZZLit/unimi/dsi/fastutil/ints/IntSet;)V", "getCanvasId", "()I", "getCapturing", "()Z", "getCapturingMouseMove", "getHidingMouse", "getKeyCaptures", "()Lit/unimi/dsi/fastutil/ints/IntSet;", "encode", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "", "Companion", "CC-Holo"})
public final class S2CCanvasCaptureStatePacket
implements CCHoloPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int canvasId;
    private final boolean capturing;
    private final boolean capturingMouseMove;
    private final boolean hidingMouse;
    @NotNull
    private final IntSet keyCaptures;

    public S2CCanvasCaptureStatePacket(int canvasId, boolean capturing, boolean capturingMouseMove, boolean hidingMouse, @NotNull IntSet keyCaptures) {
        Intrinsics.checkNotNullParameter((Object)keyCaptures, (String)"keyCaptures");
        this.canvasId = canvasId;
        this.capturing = capturing;
        this.capturingMouseMove = capturingMouseMove;
        this.hidingMouse = hidingMouse;
        this.keyCaptures = keyCaptures;
    }

    public final int getCanvasId() {
        return this.canvasId;
    }

    public final boolean getCapturing() {
        return this.capturing;
    }

    public final boolean getCapturingMouseMove() {
        return this.capturingMouseMove;
    }

    public final boolean getHidingMouse() {
        return this.hidingMouse;
    }

    @NotNull
    public final IntSet getKeyCaptures() {
        return this.keyCaptures;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeInt(this.canvasId);
        buf.writeBoolean(this.capturing);
        buf.writeBoolean(this.capturingMouseMove);
        buf.writeBoolean(this.hidingMouse);
        buf.writeVarIntArray(this.keyCaptures.toIntArray());
    }

    public final int component1() {
        return this.canvasId;
    }

    public final boolean component2() {
        return this.capturing;
    }

    public final boolean component3() {
        return this.capturingMouseMove;
    }

    public final boolean component4() {
        return this.hidingMouse;
    }

    @NotNull
    public final IntSet component5() {
        return this.keyCaptures;
    }

    @NotNull
    public final S2CCanvasCaptureStatePacket copy(int canvasId, boolean capturing, boolean capturingMouseMove, boolean hidingMouse, @NotNull IntSet keyCaptures) {
        Intrinsics.checkNotNullParameter((Object)keyCaptures, (String)"keyCaptures");
        return new S2CCanvasCaptureStatePacket(canvasId, capturing, capturingMouseMove, hidingMouse, keyCaptures);
    }

    public static /* synthetic */ S2CCanvasCaptureStatePacket copy$default(S2CCanvasCaptureStatePacket s2CCanvasCaptureStatePacket, int n, boolean bl, boolean bl2, boolean bl3, IntSet intSet, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = s2CCanvasCaptureStatePacket.canvasId;
        }
        if ((n2 & 2) != 0) {
            bl = s2CCanvasCaptureStatePacket.capturing;
        }
        if ((n2 & 4) != 0) {
            bl2 = s2CCanvasCaptureStatePacket.capturingMouseMove;
        }
        if ((n2 & 8) != 0) {
            bl3 = s2CCanvasCaptureStatePacket.hidingMouse;
        }
        if ((n2 & 0x10) != 0) {
            intSet = s2CCanvasCaptureStatePacket.keyCaptures;
        }
        return s2CCanvasCaptureStatePacket.copy(n, bl, bl2, bl3, intSet);
    }

    @NotNull
    public String toString() {
        return "S2CCanvasCaptureStatePacket(canvasId=" + this.canvasId + ", capturing=" + this.capturing + ", capturingMouseMove=" + this.capturingMouseMove + ", hidingMouse=" + this.hidingMouse + ", keyCaptures=" + this.keyCaptures + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.canvasId);
        result = result * 31 + Boolean.hashCode(this.capturing);
        result = result * 31 + Boolean.hashCode(this.capturingMouseMove);
        result = result * 31 + Boolean.hashCode(this.hidingMouse);
        result = result * 31 + this.keyCaptures.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof S2CCanvasCaptureStatePacket)) {
            return false;
        }
        S2CCanvasCaptureStatePacket s2CCanvasCaptureStatePacket = (S2CCanvasCaptureStatePacket)other;
        if (this.canvasId != s2CCanvasCaptureStatePacket.canvasId) {
            return false;
        }
        if (this.capturing != s2CCanvasCaptureStatePacket.capturing) {
            return false;
        }
        if (this.capturingMouseMove != s2CCanvasCaptureStatePacket.capturingMouseMove) {
            return false;
        }
        if (this.hidingMouse != s2CCanvasCaptureStatePacket.hidingMouse) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keyCaptures, (Object)s2CCanvasCaptureStatePacket.keyCaptures);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u000e"}, d2={"Lsh/lem/ccholo/networking/S2CCanvasCaptureStatePacket$Companion;", "", "<init>", "()V", "decode", "Lsh/lem/ccholo/networking/S2CCanvasCaptureStatePacket;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "handle", "", "msg", "ctx", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "CC-Holo"})
    @SourceDebugExtension(value={"SMAP\nS2CCanvasCaptureStatePacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 S2CCanvasCaptureStatePacket.kt\nsh/lem/ccholo/networking/S2CCanvasCaptureStatePacket$Companion\n+ 2 CCHoloPacketHandler.kt\nsh/lem/ccholo/networking/CCHoloPacketHandler\n*L\n1#1,48:1\n98#2,9:49\n*S KotlinDebug\n*F\n+ 1 S2CCanvasCaptureStatePacket.kt\nsh/lem/ccholo/networking/S2CCanvasCaptureStatePacket$Companion\n*L\n37#1:49,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final S2CCanvasCaptureStatePacket decode(@NotNull FriendlyByteBuf buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return new S2CCanvasCaptureStatePacket(buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), (IntSet)new IntOpenHashSet(buf.readVarIntArray()));
        }

        public final void handle(@NotNull S2CCanvasCaptureStatePacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            CCHoloPacketHandler this_$iv = CCHoloPacketHandler.INSTANCE;
            boolean $i$f$wrapPacketHandler = false;
            try {
                boolean bl = false;
                NetworkEvent.Context context = ctx.get();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"get(...)");
                NetworkEvent.Context c = context;
                c.enqueueWork(() -> Companion.handle$lambda$3$lambda$2(msg));
                c.setPacketHandled(true);
            }
            catch (Exception e$iv) {
                CCHolo.log.error("Error while handling packet", (Throwable)e$iv);
            }
            catch (LinkageError e$iv) {
                CCHolo.log.error("Critical error while handling packet (LinkageError)", (Throwable)e$iv);
            }
            catch (VirtualMachineError e$iv) {
                CCHolo.log.error("Critical error while handling packet (VirtualMachineError)", (Throwable)e$iv);
            }
        }

        private static final void handle$lambda$3$lambda$2$lambda$1$lambda$0(S2CCanvasCaptureStatePacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            CanvasHandlerClient.INSTANCE.onCanvasCaptureStatePacket$CC_Holo($msg);
        }

        private static final Runnable handle$lambda$3$lambda$2$lambda$1(S2CCanvasCaptureStatePacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            return () -> Companion.handle$lambda$3$lambda$2$lambda$1$lambda$0($msg);
        }

        private static final void handle$lambda$3$lambda$2(S2CCanvasCaptureStatePacket $msg) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Companion.handle$lambda$3$lambda$2$lambda$1($msg));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

