/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.objects;

import dan200.computercraft.api.lua.LuaFunction;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import sh.lem.ccholo.canvas.CanvasRoot;
import sh.lem.ccholo.canvas.CanvasRootClient;
import sh.lem.ccholo.canvas.CanvasRootServer;
import sh.lem.ccholo.util.BaseDirtyable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 '2\u00020\u0001:\u0002&'B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H&J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H&J\b\u0010%\u001a\u00020!H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lsh/lem/ccholo/objects/BaseObject;", "Lsh/lem/ccholo/util/BaseDirtyable;", "id", "", "parent", "type", "", "canvasRoot", "Lsh/lem/ccholo/canvas/CanvasRoot;", "<init>", "(IIBLsh/lem/ccholo/canvas/CanvasRoot;)V", "getId", "()I", "getParent", "getType", "()B", "getCanvasRoot", "()Lsh/lem/ccholo/canvas/CanvasRoot;", "dirty", "", "getDirty", "()Z", "setDirty", "(Z)V", "canvasRootClient", "Lsh/lem/ccholo/canvas/CanvasRootClient;", "getCanvasRootClient", "()Lsh/lem/ccholo/canvas/CanvasRootClient;", "canvasRootServer", "Lsh/lem/ccholo/canvas/CanvasRootServer;", "getCanvasRootServer", "()Lsh/lem/ccholo/canvas/CanvasRootServer;", "readInitial", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "writeInitial", "remove", "Factory", "Companion", "CC-Holo"})
public abstract class BaseObject
implements BaseDirtyable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    private final int parent;
    private final byte type;
    @NotNull
    private final CanvasRoot canvasRoot;
    private boolean dirty;
    @NotNull
    private static final Comparator<BaseObject> SORTING_ORDER;

    public BaseObject(int id, int parent, byte type, @NotNull CanvasRoot canvasRoot) {
        Intrinsics.checkNotNullParameter((Object)canvasRoot, (String)"canvasRoot");
        this.id = id;
        this.parent = parent;
        this.type = type;
        this.canvasRoot = canvasRoot;
        this.dirty = true;
    }

    public final int getId() {
        return this.id;
    }

    public final int getParent() {
        return this.parent;
    }

    public final byte getType() {
        return this.type;
    }

    @NotNull
    public final CanvasRoot getCanvasRoot() {
        return this.canvasRoot;
    }

    @Override
    public boolean getDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @NotNull
    public CanvasRootClient getCanvasRootClient() {
        CanvasRoot canvasRoot = this.canvasRoot;
        CanvasRootClient canvasRootClient = canvasRoot instanceof CanvasRootClient ? (CanvasRootClient)canvasRoot : null;
        if (canvasRootClient == null) {
            throw new IllegalStateException("Tried to access client canvas from server context".toString());
        }
        return canvasRootClient;
    }

    @NotNull
    public CanvasRootServer getCanvasRootServer() {
        CanvasRoot canvasRoot = this.canvasRoot;
        CanvasRootServer canvasRootServer = canvasRoot instanceof CanvasRootServer ? (CanvasRootServer)canvasRoot : null;
        if (canvasRootServer == null) {
            throw new IllegalStateException("Tried to access server canvas from client context".toString());
        }
        return canvasRootServer;
    }

    public abstract void readInitial(@NotNull FriendlyByteBuf var1);

    public abstract void writeInitial(@NotNull FriendlyByteBuf var1);

    @LuaFunction
    public final void remove() {
        this.getCanvasRootServer().remove(this);
    }

    @Override
    public boolean pollDirty() {
        return BaseDirtyable.DefaultImpls.pollDirty(this);
    }

    @Override
    public void setDirty() {
        BaseDirtyable.DefaultImpls.setDirty(this);
    }

    private static final int SORTING_ORDER$lambda$0(BaseObject a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return a.id;
    }

    private static final int SORTING_ORDER$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    static {
        Comparator<Object> comparator = Comparator.comparingInt(arg_0 -> BaseObject.SORTING_ORDER$lambda$1(BaseObject::SORTING_ORDER$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparingInt(...)");
        SORTING_ORDER = comparator;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0007j\b\u0012\u0004\u0012\u00020\u0006`\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lsh/lem/ccholo/objects/BaseObject$Companion;", "", "<init>", "()V", "SORTING_ORDER", "Lkotlin/Comparator;", "Lsh/lem/ccholo/objects/BaseObject;", "Ljava/util/Comparator;", "getSORTING_ORDER", "()Ljava/util/Comparator;", "Ljava/util/Comparator;", "CC-Holo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<BaseObject> getSORTING_ORDER() {
            return SORTING_ORDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lsh/lem/ccholo/objects/BaseObject$Factory;", "", "create", "Lsh/lem/ccholo/objects/BaseObject;", "id", "", "parent", "root", "Lsh/lem/ccholo/canvas/CanvasRoot;", "CC-Holo"})
    public static interface Factory {
        @NotNull
        public BaseObject create(int var1, int var2, @NotNull CanvasRoot var3);
    }
}

