/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.objects.object3d;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.canvas.CanvasRoot;
import sh.lem.ccholo.canvas.CanvasRootClient;
import sh.lem.ccholo.canvas.CanvasRootServer;
import sh.lem.ccholo.objects.BaseObject;
import sh.lem.ccholo.objects.object3d.Box3d;
import sh.lem.ccholo.objects.object3d.Group3d;
import sh.lem.ccholo.objects.object3d.Item3d;
import sh.lem.ccholo.objects.object3d.ObjectFrame3d;
import sh.lem.ccholo.util.BufExtKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lsh/lem/ccholo/objects/object3d/ObjectRoot3d;", "Lsh/lem/ccholo/objects/BaseObject;", "Lsh/lem/ccholo/objects/object3d/Group3d;", "id", "", "parent", "canvasRoot", "Lsh/lem/ccholo/canvas/CanvasRoot;", "<init>", "(IILsh/lem/ccholo/canvas/CanvasRoot;)V", "origin", "Lnet/minecraft/world/phys/Vec3;", "getOrigin$CC_Holo", "()Lnet/minecraft/world/phys/Vec3;", "setOrigin$CC_Holo", "(Lnet/minecraft/world/phys/Vec3;)V", "levelKey", "Lnet/minecraft/resources/ResourceLocation;", "getLevelKey$CC_Holo", "()Lnet/minecraft/resources/ResourceLocation;", "setLevelKey$CC_Holo", "(Lnet/minecraft/resources/ResourceLocation;)V", "canvasRootClient", "Lsh/lem/ccholo/canvas/CanvasRootClient;", "getCanvasRootClient", "()Lsh/lem/ccholo/canvas/CanvasRootClient;", "canvasRootServer", "Lsh/lem/ccholo/canvas/CanvasRootServer;", "getCanvasRootServer", "()Lsh/lem/ccholo/canvas/CanvasRootServer;", "init", "", "level", "Lnet/minecraft/world/level/Level;", "readInitial", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "writeInitial", "CC-Holo"})
public final class ObjectRoot3d
extends BaseObject
implements Group3d {
    @NotNull
    private Vec3 origin;
    @Nullable
    private ResourceLocation levelKey;

    public ObjectRoot3d(int id, int parent, @NotNull CanvasRoot canvasRoot) {
        Intrinsics.checkNotNullParameter((Object)canvasRoot, (String)"canvasRoot");
        super(id, parent, (byte)9, canvasRoot);
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.origin = vec3;
        this.levelKey = ResourceLocation.tryBuild((String)"minecraft", (String)"overworld");
    }

    @NotNull
    public final Vec3 getOrigin$CC_Holo() {
        return this.origin;
    }

    public final void setOrigin$CC_Holo(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.origin = vec3;
    }

    @Nullable
    public final ResourceLocation getLevelKey$CC_Holo() {
        return this.levelKey;
    }

    public final void setLevelKey$CC_Holo(@Nullable ResourceLocation resourceLocation) {
        this.levelKey = resourceLocation;
    }

    @Override
    @NotNull
    public CanvasRootClient getCanvasRootClient() {
        CanvasRoot canvasRoot = this.getCanvasRoot();
        CanvasRootClient canvasRootClient = canvasRoot instanceof CanvasRootClient ? (CanvasRootClient)canvasRoot : null;
        if (canvasRootClient == null) {
            throw new IllegalStateException("Tried to access client canvas from server context".toString());
        }
        return canvasRootClient;
    }

    @Override
    @NotNull
    public CanvasRootServer getCanvasRootServer() {
        CanvasRoot canvasRoot = this.getCanvasRoot();
        CanvasRootServer canvasRootServer = canvasRoot instanceof CanvasRootServer ? (CanvasRootServer)canvasRoot : null;
        if (canvasRootServer == null) {
            throw new IllegalStateException("Tried to access server canvas from client context".toString());
        }
        return canvasRootServer;
    }

    public final void init(@NotNull Level level, @NotNull Vec3 origin) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        ResourceLocation levelKey = level.dimension().location();
        if (!Intrinsics.areEqual((Object)origin, (Object)this.origin) || !Intrinsics.areEqual((Object)levelKey, (Object)this.levelKey)) {
            this.origin = origin;
            this.levelKey = levelKey;
            this.setDirty();
        }
    }

    @Override
    public void readInitial(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.origin = BufExtKt.readVec3(buf);
        this.levelKey = BufExtKt.readOptResourceLocation(buf);
    }

    @Override
    public void writeInitial(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        BufExtKt.writeVec3(buf, this.origin);
        BufExtKt.writeOptResourceLocation(buf, this.levelKey);
    }

    @Override
    @LuaFunction
    @NotNull
    public Box3d addBox(@NotNull IArguments args) {
        return Group3d.DefaultImpls.addBox(this, args);
    }

    @Override
    @LuaFunction
    @NotNull
    public Item3d addItem(@NotNull IArguments args) {
        return Group3d.DefaultImpls.addItem(this, args);
    }

    @Override
    @LuaFunction
    @NotNull
    public ObjectFrame3d addFrame(@NotNull IArguments args) {
        return Group3d.DefaultImpls.addFrame(this, args);
    }

    @Override
    @LuaFunction
    public void clear() {
        Group3d.DefaultImpls.clear(this);
    }
}

