/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaValues;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.objects.ItemObject;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u001a\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t*\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u0004\u001a\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\r\u001a\u00020\f*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u000e\u001a\u00020\f*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u001a&\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014\u001a*\u0010\u0015\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014\u001a&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014\u001a*\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014\u001a,\u0010\u0018\u001a\u00020\u0014*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a \u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u0012\u0010\u001d\u001a\u00020\u0014*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004\u001a,\u0010\u001e\u001a\u00020\u0014*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u001c\u0010\u001f\u001a\u00020\u0017*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030 2\u0006\u0010!\u001a\u00020\"H\u0002\u001a\"\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\"2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0014H\u0002\u00a8\u0006'"}, d2={"getVec2", "Lnet/minecraft/world/phys/Vec2;", "Ldan200/computercraft/api/lua/IArguments;", "startIndex", "", "getVec2Nullable", "getVec2Table", "index", "getVec2Tables", "", "optArgCount", "getVec3Nullable", "Lnet/minecraft/world/phys/Vec3;", "getVec3", "getVec3Table", "assertIntBetweenImpl", "value", "min", "max", "message", "", "assertIntBetween", "assertDoubleBetween", "", "assertStringLength", "getItem", "Lkotlin/Pair;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/nbt/CompoundTag;", "getUtf8String", "assertUtf8StringLength", "getFiniteDouble", "", "key", "", "badKey", "Ldan200/computercraft/api/lua/LuaException;", "obj", "expected", "CC-Holo"})
public final class ArgumentExtKt {
    @NotNull
    public static final Vec2 getVec2(@NotNull IArguments $this$getVec2, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getVec2, (String)"<this>");
        Vec2 vec2 = ArgumentExtKt.getVec2Nullable($this$getVec2, startIndex);
        if (vec2 == null) {
            throw LuaValues.badArgumentOf((IArguments)$this$getVec2, (int)startIndex, (String)"number");
        }
        return vec2;
    }

    public static /* synthetic */ Vec2 getVec2$default(IArguments iArguments, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ArgumentExtKt.getVec2(iArguments, n);
    }

    @Nullable
    public static final Vec2 getVec2Nullable(@NotNull IArguments $this$getVec2Nullable, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getVec2Nullable, (String)"<this>");
        return $this$getVec2Nullable.count() < startIndex || $this$getVec2Nullable.count() == startIndex && $this$getVec2Nullable.get(0) == null ? null : new Vec2((float)$this$getVec2Nullable.getDouble(startIndex), (float)$this$getVec2Nullable.getDouble(startIndex + 1));
    }

    public static /* synthetic */ Vec2 getVec2Nullable$default(IArguments iArguments, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ArgumentExtKt.getVec2Nullable(iArguments, n);
    }

    @NotNull
    public static final Vec2 getVec2Table(@NotNull IArguments $this$getVec2Table, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getVec2Table, (String)"<this>");
        Map point = $this$getVec2Table.getTable(index);
        Intrinsics.checkNotNull((Object)point);
        return point.containsKey("x") ? new Vec2((float)ArgumentExtKt.getFiniteDouble(point, "x"), (float)ArgumentExtKt.getFiniteDouble(point, "y")) : new Vec2((float)ArgumentExtKt.getFiniteDouble(point, 1.0), (float)ArgumentExtKt.getFiniteDouble(point, 2.0));
    }

    public static /* synthetic */ Vec2 getVec2Table$default(IArguments iArguments, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ArgumentExtKt.getVec2Table(iArguments, n);
    }

    @NotNull
    public static final List<Vec2> getVec2Tables(@NotNull IArguments $this$getVec2Tables, int optArgCount) {
        Intrinsics.checkNotNullParameter((Object)$this$getVec2Tables, (String)"<this>");
        List points = new ArrayList();
        for (int i = 0; i < $this$getVec2Tables.count(); ++i) {
            Object arg = $this$getVec2Tables.get(i);
            if (i >= $this$getVec2Tables.count() - optArgCount && !(arg instanceof Map)) break;
            points.add(ArgumentExtKt.getVec2Table($this$getVec2Tables, i));
        }
        return points;
    }

    public static /* synthetic */ List getVec2Tables$default(IArguments iArguments, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ArgumentExtKt.getVec2Tables(iArguments, n);
    }

    @Nullable
    public static final Vec3 getVec3Nullable(@NotNull IArguments $this$getVec3Nullable, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getVec3Nullable, (String)"<this>");
        return $this$getVec3Nullable.count() < startIndex || $this$getVec3Nullable.count() == startIndex && $this$getVec3Nullable.get(0) == null ? null : new Vec3($this$getVec3Nullable.getDouble(startIndex), $this$getVec3Nullable.getDouble(startIndex + 1), $this$getVec3Nullable.getDouble(startIndex + 2));
    }

    public static /* synthetic */ Vec3 getVec3Nullable$default(IArguments iArguments, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ArgumentExtKt.getVec3Nullable(iArguments, n);
    }

    @NotNull
    public static final Vec3 getVec3(@NotNull IArguments $this$getVec3, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getVec3, (String)"<this>");
        Vec3 vec3 = ArgumentExtKt.getVec3Nullable($this$getVec3, startIndex);
        if (vec3 == null) {
            throw LuaValues.badArgumentOf((IArguments)$this$getVec3, (int)startIndex, (String)"number");
        }
        return vec3;
    }

    public static /* synthetic */ Vec3 getVec3$default(IArguments iArguments, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ArgumentExtKt.getVec3(iArguments, n);
    }

    @NotNull
    public static final Vec3 getVec3Table(@NotNull IArguments $this$getVec3Table, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getVec3Table, (String)"<this>");
        Map point = $this$getVec3Table.getTable(index);
        Intrinsics.checkNotNull((Object)point);
        return point.containsKey("x") ? new Vec3(ArgumentExtKt.getFiniteDouble(point, "x"), ArgumentExtKt.getFiniteDouble(point, "y"), ArgumentExtKt.getFiniteDouble(point, "z")) : new Vec3(ArgumentExtKt.getFiniteDouble(point, 1), ArgumentExtKt.getFiniteDouble(point, 2), ArgumentExtKt.getFiniteDouble(point, 3));
    }

    public static /* synthetic */ Vec3 getVec3Table$default(IArguments iArguments, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ArgumentExtKt.getVec3Table(iArguments, n);
    }

    public static final int assertIntBetweenImpl(int value, int min, int max, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (value < min || value > max) {
            Object[] objectArray = new Object[]{"between " + min + " and " + max};
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            throw new LuaException(string);
        }
        return value;
    }

    public static final int assertIntBetween(@NotNull IArguments $this$assertIntBetween, int index, int min, int max, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIntBetween, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return ArgumentExtKt.assertIntBetweenImpl($this$assertIntBetween.getInt(index), min, max, message);
    }

    public static final double assertDoubleBetween(double value, double min, double max, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (value < min || value > max || Double.isNaN(value)) {
            Object[] objectArray = new Object[]{"between " + min + " and " + max};
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            throw new LuaException(string);
        }
        return value;
    }

    public static final double assertDoubleBetween(@NotNull IArguments $this$assertDoubleBetween, int index, double min, double max, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$assertDoubleBetween, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return ArgumentExtKt.assertDoubleBetween($this$assertDoubleBetween.getFiniteDouble(index), min, max, message);
    }

    @NotNull
    public static final String assertStringLength(@NotNull IArguments $this$assertStringLength, int index, int min, int max, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$assertStringLength, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String value = $this$assertStringLength.getString(index);
        ArgumentExtKt.assertIntBetweenImpl(value.length(), min, max, message);
        Intrinsics.checkNotNull((Object)value);
        return value;
    }

    public static /* synthetic */ String assertStringLength$default(IArguments iArguments, int n, int n2, int n3, String string, int n4, Object object) {
        if ((n4 & 8) != 0) {
            string = "string length out of bounds (%s)";
        }
        return ArgumentExtKt.assertStringLength(iArguments, n, n2, n3, string);
    }

    @NotNull
    public static final Pair<Item, CompoundTag> getItem(@NotNull IArguments $this$getItem, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getItem, (String)"<this>");
        String def = $this$getItem.getString(index);
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            RegistryAccess.Frozen registryAccess = server.registryAccess();
            FeatureFlagSet enabledFeatures = server.getWorldData().enabledFeatures();
            Intrinsics.checkNotNull((Object)registryAccess);
            HolderLookup.Provider provider = (HolderLookup.Provider)registryAccess;
            Intrinsics.checkNotNull((Object)enabledFeatures);
            Intrinsics.checkNotNull((Object)def);
            return ItemObject.Companion.parseObject(provider, enabledFeatures, def);
        }
        catch (CommandSyntaxException e) {
            CCHolo.log.error("Could not construct item (CommandSyntaxException) " + def + ":", (Throwable)e);
            throw new LuaException("Invalid item or NBT '" + def + "'");
        }
        catch (Exception e) {
            CCHolo.log.error("Could not construct item " + def + ":", (Throwable)e);
            throw new LuaException("Unexpected error while parsing item");
        }
    }

    @NotNull
    public static final String getUtf8String(@NotNull IArguments $this$getUtf8String, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getUtf8String, (String)"<this>");
        ByteBuffer buf = $this$getUtf8String.getBytes(index);
        String string = StandardCharsets.UTF_8.decode(buf).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String assertUtf8StringLength(@NotNull IArguments $this$assertUtf8StringLength, int index, int min, int max, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$assertUtf8StringLength, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String value = ArgumentExtKt.getUtf8String($this$assertUtf8StringLength, index);
        ArgumentExtKt.assertIntBetweenImpl(value.length(), min, max, message);
        return value;
    }

    public static /* synthetic */ String assertUtf8StringLength$default(IArguments iArguments, int n, int n2, int n3, String string, int n4, Object object) {
        if ((n4 & 8) != 0) {
            string = "string length out of bounds (%s)";
        }
        return ArgumentExtKt.assertUtf8StringLength(iArguments, n, n2, n3, string);
    }

    private static final double getFiniteDouble(Map<?, ?> $this$getFiniteDouble, Object key) {
        Object obj = $this$getFiniteDouble.get(key);
        if (obj == null) {
            throw new LuaException("Expected number for key " + key + ", got nil");
        }
        Object obj2 = obj;
        if (!(obj2 instanceof Number)) {
            throw ArgumentExtKt.badKey(obj2, key.toString(), "number");
        }
        double value = ((Number)obj2).doubleValue();
        double d = value;
        if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
            throw ArgumentExtKt.badKey(obj2, key.toString(), "number");
        }
        return value;
    }

    private static final LuaException badKey(Object obj, String key, String expected) {
        return new LuaException("Expected " + expected + " for key " + key + ", got " + LuaValues.getType((Object)obj));
    }
}

