/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.canvas;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasRootServer;
import sh.lem.ccholo.networking.CCHoloPacketHandler;
import sh.lem.ccholo.networking.S2CCanvasInitPacket;
import sh.lem.ccholo.networking.S2CCanvasRemovePacket;
import sh.lem.ccholo.networking.S2CCanvasUpdatePacket;
import sh.lem.ccholo.peripheral.HologramPeripheral;

@Mod.EventBusSubscriber
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0010H\u0007J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lsh/lem/ccholo/canvas/CanvasHandlerServer;", "", "<init>", "()V", "lastId", "Ljava/util/concurrent/atomic/AtomicInteger;", "roots", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lsh/lem/ccholo/canvas/CanvasRootServer;", "nextId", "", "getRootForPlayer", "p", "Lnet/minecraft/server/level/ServerPlayer;", "onPlayerLogin", "", "event", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "update", "Lnet/minecraftforge/event/TickEvent$ServerTickEvent;", "removeAllRoots", "removeListener", "listener", "Lsh/lem/ccholo/peripheral/HologramPeripheral;", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nCanvasHandlerServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasHandlerServer.kt\nsh/lem/ccholo/canvas/CanvasHandlerServer\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,100:1\n72#2,2:101\n1#3:103\n1863#4,2:104\n1863#4,2:108\n216#5,2:106\n*S KotlinDebug\n*F\n+ 1 CanvasHandlerServer.kt\nsh/lem/ccholo/canvas/CanvasHandlerServer\n*L\n34#1:101,2\n34#1:103\n66#1:104,2\n97#1:108,2\n82#1:106,2\n*E\n"})
public final class CanvasHandlerServer {
    @NotNull
    public static final CanvasHandlerServer INSTANCE = new CanvasHandlerServer();
    @NotNull
    private static final AtomicInteger lastId = new AtomicInteger(0);
    @NotNull
    private static final ConcurrentHashMap<UUID, CanvasRootServer> roots = new ConcurrentHashMap();

    private CanvasHandlerServer() {
    }

    public final int nextId() {
        return lastId.getAndIncrement();
    }

    /*
     * WARNING - void declaration
     */
    @SideOnly(value=Side.SERVER)
    @NotNull
    public final CanvasRootServer getRootForPlayer(@NotNull ServerPlayer p) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        ConcurrentMap concurrentMap = roots;
        UUID key$iv = p.getGameProfile().getId();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            CanvasRootServer canvasRootServer;
            boolean bl = false;
            CCHolo.log.debug("Creating new canvas root for player {} ({})", (Object)p.getGameProfile().getName(), (Object)p.getGameProfile().getId());
            CanvasRootServer it = canvasRootServer = new CanvasRootServer();
            boolean bl2 = false;
            S2CCanvasInitPacket s2CCanvasInitPacket = it.makeInitPacket();
            if (s2CCanvasInitPacket != null) {
                S2CCanvasInitPacket pkt = s2CCanvasInitPacket;
                boolean bl3 = false;
                CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(() -> CanvasHandlerServer.getRootForPlayer$lambda$3$lambda$2$lambda$1$lambda$0(p)), (Object)pkt);
            }
            CanvasRootServer default$iv = canvasRootServer;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (CanvasRootServer)object;
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public final void onPlayerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Player player = event.getEntity();
            ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
            if (serverPlayer == null) {
                return;
            }
            ServerPlayer p = serverPlayer;
            CanvasRootServer canvasRootServer = roots.get(p.getGameProfile().getId());
            if (canvasRootServer == null) {
                return;
            }
            CanvasRootServer root = canvasRootServer;
            CCHolo.log.debug("Player {} ({}) logged in, sending canvas init packet", (Object)p.getGameProfile().getName(), (Object)p.getGameProfile().getId());
            S2CCanvasInitPacket s2CCanvasInitPacket = root.makeInitPacket();
            if (s2CCanvasInitPacket == null) break block2;
            S2CCanvasInitPacket pkt = s2CCanvasInitPacket;
            boolean bl = false;
            CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(() -> CanvasHandlerServer.onPlayerLogin$lambda$5$lambda$4(p)), (Object)pkt);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public final void update(@NotNull TickEvent.ServerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List list = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            S2CCanvasUpdatePacket pkt;
            CanvasRootServer root;
            ServerPlayer p = (ServerPlayer)element$iv;
            boolean bl = false;
            if (roots.get(p.getGameProfile().getId()) == null) continue;
            if (root.makeUpdatePacket() == null) continue;
            boolean bl2 = false;
            CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(() -> CanvasHandlerServer.update$lambda$8$lambda$7$lambda$6(p)), (Object)pkt);
        }
    }

    @SideOnly(value=Side.SERVER)
    public final void removeAllRoots() {
        CCHolo.log.debug("Removing all canvas roots");
        Map $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ServerPlayer p;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            UUID uuid = (UUID)entry.getKey();
            CanvasRootServer root = (CanvasRootServer)entry.getValue();
            if (ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(uuid) == null) continue;
            CCHolo.log.debug("Sending canvas removal packet to player {} ({})", (Object)p.getGameProfile().getName(), (Object)p.getGameProfile().getId());
            S2CCanvasRemovePacket pkt = root.makeRemovePacket();
            CCHoloPacketHandler.INSTANCE.getChannel().send(PacketDistributor.PLAYER.with(() -> CanvasHandlerServer.removeAllRoots$lambda$10$lambda$9(p)), (Object)pkt);
        }
        roots.clear();
    }

    @SideOnly(value=Side.SERVER)
    public final void removeListener(@NotNull HologramPeripheral listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Collection<CanvasRootServer> collection = roots.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CanvasRootServer it = (CanvasRootServer)element$iv;
            boolean bl = false;
            it.removeListener$CC_Holo(listener);
        }
    }

    private static final ServerPlayer getRootForPlayer$lambda$3$lambda$2$lambda$1$lambda$0(ServerPlayer $p) {
        Intrinsics.checkNotNullParameter((Object)$p, (String)"$p");
        return $p;
    }

    private static final ServerPlayer onPlayerLogin$lambda$5$lambda$4(ServerPlayer $p) {
        Intrinsics.checkNotNullParameter((Object)$p, (String)"$p");
        return $p;
    }

    private static final ServerPlayer update$lambda$8$lambda$7$lambda$6(ServerPlayer $p) {
        return $p;
    }

    private static final ServerPlayer removeAllRoots$lambda$10$lambda$9(ServerPlayer $p) {
        Intrinsics.checkNotNullParameter((Object)$p, (String)"$p");
        return $p;
    }
}

