/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.objects.renderers.object3d;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasRootClient;
import sh.lem.ccholo.objects.object3d.ObjectFrame3d;
import sh.lem.ccholo.objects.renderers.BaseObjectRenderer;
import sh.lem.ccholo.objects.renderers.object3d.Rotatable3dRenderer;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lsh/lem/ccholo/objects/renderers/object3d/ObjectFrame3dRenderer;", "Lsh/lem/ccholo/objects/renderers/BaseObjectRenderer;", "Lsh/lem/ccholo/objects/object3d/ObjectFrame3d;", "<init>", "()V", "framebuffer", "Lcom/mojang/blaze3d/pipeline/TextureTarget;", "getFramebuffer", "()Lcom/mojang/blaze3d/pipeline/TextureTarget;", "framebuffer$delegate", "Lkotlin/Lazy;", "draw", "", "obj", "root", "Lsh/lem/ccholo/canvas/CanvasRootClient;", "gg", "Lnet/minecraft/client/gui/GuiGraphics;", "buf", "Lnet/minecraft/client/renderer/MultiBufferSource;", "CC-Holo"})
public final class ObjectFrame3dRenderer
implements BaseObjectRenderer<ObjectFrame3d> {
    @NotNull
    public static final ObjectFrame3dRenderer INSTANCE = new ObjectFrame3dRenderer();
    @NotNull
    private static final Lazy framebuffer$delegate = LazyKt.lazy(ObjectFrame3dRenderer::framebuffer_delegate$lambda$0);

    private ObjectFrame3dRenderer() {
    }

    @NotNull
    public final TextureTarget getFramebuffer() {
        Lazy lazy = framebuffer$delegate;
        return (TextureTarget)lazy.getValue();
    }

    @Override
    public void draw(@NotNull ObjectFrame3d obj, @NotNull CanvasRootClient root, @NotNull GuiGraphics gg, @Nullable MultiBufferSource buf) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)gg, (String)"gg");
        ObjectFrame3d $this$draw_u24lambda_u241 = obj;
        boolean bl = false;
        IntSet intSet = $this$draw_u24lambda_u241.getCanvasRootClient().getChildren($this$draw_u24lambda_u241.getId());
        if (intSet == null) {
            return;
        }
        IntSet children = intSet;
        Minecraft mc = Minecraft.getInstance();
        float w = 512.0f;
        float h = 288.0f;
        int currentBuffer = GlStateManager.getBoundFramebuffer();
        float currentFog = RenderSystem.getShaderFogEnd();
        float[] currentFogColor = RenderSystem.getShaderFogColor();
        RenderSystem.setShaderFogEnd((float)2000.0f);
        RenderSystem.setShaderFogColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.backupProjectionMatrix();
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, w, h, 0.0f, 100.0f, 300.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        PoseStack innerPoseStack = new PoseStack();
        innerPoseStack.setIdentity();
        innerPoseStack.translate(0.0, 0.0, -100.0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        INSTANCE.getFramebuffer().setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        INSTANCE.getFramebuffer().clear(Minecraft.ON_OSX);
        INSTANCE.getFramebuffer().bindWrite(true);
        RenderSystem.disableDepthTest();
        GuiGraphics innerGg = new GuiGraphics(mc, innerPoseStack, mc.renderBuffers().bufferSource());
        CanvasRootClient canvasRootClient = $this$draw_u24lambda_u241.getCanvasRootClient();
        IntIterator intIterator = children.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        canvasRootClient.drawChildren(intIterator, innerGg, buf);
        RenderSystem.viewport((int)0, (int)0, (int)mc.getWindow().getWidth(), (int)mc.getWindow().getHeight());
        RenderSystem.restoreProjectionMatrix();
        INSTANCE.getFramebuffer().unbindWrite();
        GlStateManager._glBindFramebuffer((int)36160, (int)currentBuffer);
        PoseStack poseStack = gg.pose();
        poseStack.pushPose();
        poseStack.translate($this$draw_u24lambda_u241.getPosition().x, $this$draw_u24lambda_u241.getPosition().y, $this$draw_u24lambda_u241.getPosition().z);
        poseStack.scale($this$draw_u24lambda_u241.getScale(), -$this$draw_u24lambda_u241.getScale(), $this$draw_u24lambda_u241.getScale());
        Rotatable3dRenderer.INSTANCE.applyRotation(gg, $this$draw_u24lambda_u241.getRotation(), true);
        if ($this$draw_u24lambda_u241.getHasDepthTest()) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        BufferBuilder builder = Tesselator.getInstance().getBuilder();
        Matrix4f pose = poseStack.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (int)INSTANCE.getFramebuffer().getColorTextureId());
        RenderSystem.enableBlend();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.vertex(pose, 0.0f, h, 0.0f).uv(0.0f, 0.0f).endVertex();
        builder.vertex(pose, w, h, 0.0f).uv(1.0f, 0.0f).endVertex();
        builder.vertex(pose, w, 0.0f, 0.0f).uv(1.0f, 1.0f).endVertex();
        builder.vertex(pose, 0.0f, 0.0f, 0.0f).uv(0.0f, 1.0f).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)builder.end());
        RenderSystem.setShaderFogEnd((float)currentFog);
        RenderSystem.setShaderFogColor((float)currentFogColor[0], (float)currentFogColor[1], (float)currentFogColor[2], (float)currentFogColor[3]);
        poseStack.popPose();
    }

    private static final TextureTarget framebuffer_delegate$lambda$0() {
        CCHolo.log.debug("Creating ObjectFrame3d framebuffer with size 512 x 288");
        return new TextureTarget(512, 288, true, true);
    }
}

