/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.canvas;

import java.net.URI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import sh.lem.ccholo.CCHolo;
import sh.lem.ccholo.canvas.CanvasRootClient;
import sh.lem.ccholo.networking.S2CCanvasCaptureStatePacket;
import sh.lem.ccholo.networking.S2CCanvasInitPacket;
import sh.lem.ccholo.networking.S2CCanvasOpenLinkPacket;
import sh.lem.ccholo.networking.S2CCanvasSetClipboardPacket;
import sh.lem.ccholo.networking.S2CCanvasUpdatePacket;
import sh.lem.ccholo.objects.BaseObject;
import sh.lem.ccholo.objects.renderers.FramebufferPool;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010!\u001a\u00020$H\u0007R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006%"}, d2={"Lsh/lem/ccholo/canvas/CanvasHandlerClient;", "", "<init>", "()V", "mc", "Lnet/minecraft/client/Minecraft;", "kotlin.jvm.PlatformType", "getMc", "()Lnet/minecraft/client/Minecraft;", "mc$delegate", "Lkotlin/Lazy;", "checkMainThread", "", "name", "", "onCanvasInitPacket", "", "msg", "Lsh/lem/ccholo/networking/S2CCanvasInitPacket;", "onCanvasInitPacket$CC_Holo", "onCanvasUpdatePacket", "Lsh/lem/ccholo/networking/S2CCanvasUpdatePacket;", "onCanvasUpdatePacket$CC_Holo", "onCanvasCaptureStatePacket", "Lsh/lem/ccholo/networking/S2CCanvasCaptureStatePacket;", "onCanvasCaptureStatePacket$CC_Holo", "onCanvasSetClipboardPacket", "Lsh/lem/ccholo/networking/S2CCanvasSetClipboardPacket;", "onCanvasSetClipboardPacket$CC_Holo", "onCanvasOpenLinkPacket", "Lsh/lem/ccholo/networking/S2CCanvasOpenLinkPacket;", "onCanvasOpenLinkPacket$CC_Holo", "onLogIn", "event", "Lnet/minecraftforge/client/event/ClientPlayerNetworkEvent$LoggingIn;", "onLogOut", "Lnet/minecraftforge/client/event/ClientPlayerNetworkEvent$LoggingOut;", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nCanvasHandlerClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasHandlerClient.kt\nsh/lem/ccholo/canvas/CanvasHandlerClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n2642#2:108\n2642#2:110\n1#3:109\n1#3:111\n1#3:112\n*S KotlinDebug\n*F\n+ 1 CanvasHandlerClient.kt\nsh/lem/ccholo/canvas/CanvasHandlerClient\n*L\n35#1:108\n48#1:110\n35#1:109\n48#1:111\n*E\n"})
public final class CanvasHandlerClient {
    @NotNull
    public static final CanvasHandlerClient INSTANCE = new CanvasHandlerClient();
    @NotNull
    private static final Lazy mc$delegate = LazyKt.lazy(CanvasHandlerClient::mc_delegate$lambda$0);

    private CanvasHandlerClient() {
    }

    private final Minecraft getMc() {
        Lazy lazy = mc$delegate;
        return (Minecraft)lazy.getValue();
    }

    private final boolean checkMainThread(String name) {
        if (!this.getMc().isSameThread()) {
            CCHolo.log.error(name + " ran off-thread, refusing!");
            return false;
        }
        return true;
    }

    public final void onCanvasInitPacket$CC_Holo(@NotNull S2CCanvasInitPacket msg) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.checkMainThread("S2CCanvasInitPacket")) {
            return;
        }
        CCHolo.log.debug("Received canvas init packet for canvas " + msg.getCanvasId() + " with " + msg.getObjects().size() + " objects");
        CanvasRootClient root = CanvasRootClient.INSTANCE;
        root.reset();
        Iterable $this$onEach$iv = msg.getObjects();
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2419$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            BaseObject p0 = (BaseObject)element$iv;
            boolean bl2 = false;
            root.updateObject(p0);
        }
        root.updateCaptureState$CC_Holo(msg.getCapturing(), msg.getCapturingMouseMove(), msg.getHidingMouse(), msg.getKeyCaptures());
    }

    public final void onCanvasUpdatePacket$CC_Holo(@NotNull S2CCanvasUpdatePacket msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.checkMainThread("S2CCanvasUpdatePacket")) {
            return;
        }
        CanvasRootClient root = CanvasRootClient.INSTANCE;
        Iterable $this$onEach$iv = msg.getChanged();
        boolean $i$f$onEach = false;
        Iterable iterable = $this$onEach$iv;
        Iterable $this$onEach_u24lambda_u2419$iv = iterable;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            BaseObject p0 = (BaseObject)element$iv;
            boolean bl2 = false;
            root.updateObject(p0);
        }
        int[] nArray = msg.getRemoved();
        for (Object p0 : (Iterable)nArray) {
            boolean bl3 = false;
            root.remove((int)p0);
        }
    }

    public final void onCanvasCaptureStatePacket$CC_Holo(@NotNull S2CCanvasCaptureStatePacket msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.checkMainThread("S2CCanvasCaptureStatePacket")) {
            return;
        }
        CanvasRootClient root = CanvasRootClient.INSTANCE;
        root.updateCaptureState$CC_Holo(msg.getCapturing(), msg.getCapturingMouseMove(), msg.getHidingMouse(), msg.getKeyCaptures());
    }

    public final void onCanvasSetClipboardPacket$CC_Holo(@NotNull S2CCanvasSetClipboardPacket msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.checkMainThread("S2CCanvasSetClipboardPacket")) {
            return;
        }
        try {
            this.getMc().keyboardHandler.setClipboard(msg.getText());
        }
        catch (Exception e) {
            CCHolo.log.error("Error while setting clipboard", (Throwable)e);
        }
    }

    public final void onCanvasOpenLinkPacket$CC_Holo(@NotNull S2CCanvasOpenLinkPacket msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.checkMainThread("S2CCanvasOpenLinkPacket")) {
            return;
        }
        try {
            URI uri = URI.create(msg.getUrl());
            Screen parent = this.getMc().screen;
            this.getMc().setScreen((Screen)new ConfirmLinkScreen(arg_0 -> CanvasHandlerClient.onCanvasOpenLinkPacket$lambda$3(uri, parent, arg_0), msg.getUrl(), false));
        }
        catch (Exception e) {
            CCHolo.log.error("Error while opening link", (Throwable)e);
        }
    }

    @SubscribeEvent
    public final void onLogIn(@NotNull ClientPlayerNetworkEvent.LoggingIn event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CCHolo.log.debug("Logging in, initialising canvas root");
        CanvasRootClient.INSTANCE.reset();
        CanvasRootClient.INSTANCE.sendScreenSizePacket$CC_Holo();
    }

    @SubscribeEvent
    public final void onLogOut(@NotNull ClientPlayerNetworkEvent.LoggingOut event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CCHolo.log.debug("Logging out, clearing canvas root");
        CanvasRootClient.INSTANCE.reset();
        FramebufferPool.INSTANCE.clear();
    }

    private static final Minecraft mc_delegate$lambda$0() {
        return Minecraft.getInstance();
    }

    private static final void onCanvasOpenLinkPacket$lambda$3(URI $uri, Screen $parent, boolean open) {
        if (open) {
            Util.getPlatform().openUri($uri);
        }
        INSTANCE.getMc().setScreen($parent);
    }
}

