/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.networking;

import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.lem.ccholo.util.EntityHitInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lsh/lem/ccholo/networking/HitResultUtil;", "", "<init>", "()V", "createHitResultTable", "", "", "blockHit", "Lnet/minecraft/world/phys/BlockHitResult;", "entityHit", "Lsh/lem/ccholo/util/EntityHitInfo;", "level", "Lnet/minecraft/world/level/Level;", "serializeBlockHit", "hit", "serializeEntityHit", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nHitResultUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitResultUtil.kt\nsh/lem/ccholo/networking/HitResultUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class HitResultUtil {
    @NotNull
    public static final HitResultUtil INSTANCE = new HitResultUtil();

    private HitResultUtil() {
    }

    @NotNull
    public final Map<String, Object> createHitResultTable(@Nullable BlockHitResult blockHit, @Nullable EntityHitInfo entityHit, @NotNull Level level) {
        Map<String, Object> map;
        Map<String, Object> map2;
        Map<String, Object> map3;
        EntityHitInfo it;
        Pair[] pairArray;
        int n;
        String string;
        Pair[] pairArray2;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Pair[] pairArray3 = pairArray2 = new Pair[2];
        int n2 = 0;
        String string2 = "blockHit";
        BlockHitResult blockHitResult = blockHit;
        if (blockHitResult != null) {
            BlockHitResult blockHitResult2 = blockHitResult;
            string = string2;
            n = n2;
            pairArray = pairArray3;
            boolean bl = false;
            map3 = INSTANCE.serializeBlockHit((BlockHitResult)it, level);
            pairArray3 = pairArray;
            n2 = n;
            string2 = string;
            map2 = map3;
        } else {
            map2 = null;
        }
        pairArray3[n2] = TuplesKt.to((Object)string2, map2);
        Pair[] pairArray4 = pairArray2;
        int n3 = 1;
        String string3 = "entityHit";
        EntityHitInfo entityHitInfo = entityHit;
        if (entityHitInfo != null) {
            it = entityHitInfo;
            string = string3;
            n = n3;
            pairArray = pairArray4;
            boolean bl = false;
            map3 = INSTANCE.serializeEntityHit(it, level);
            pairArray4 = pairArray;
            n3 = n;
            string3 = string;
            map = map3;
        } else {
            map = null;
        }
        pairArray4[n3] = TuplesKt.to((Object)string3, map);
        return MapsKt.mapOf((Pair[])pairArray2);
    }

    private final Map<String, Object> serializeBlockHit(BlockHitResult hit, Level level) {
        BlockState blockState = level.getBlockState(hit.getBlockPos());
        Block block = blockState.getBlock();
        String blockId = String.valueOf(ForgeRegistries.BLOCKS.getKey((Object)block));
        Pair[] pairArray = new Pair[5];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"x", (Object)hit.getBlockPos().getX()), TuplesKt.to((Object)"y", (Object)hit.getBlockPos().getY()), TuplesKt.to((Object)"z", (Object)hit.getBlockPos().getZ())};
        pairArray[0] = TuplesKt.to((Object)"pos", (Object)MapsKt.mapOf((Pair[])pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"x", (Object)hit.getLocation().x), TuplesKt.to((Object)"y", (Object)hit.getLocation().y), TuplesKt.to((Object)"z", (Object)hit.getLocation().z)};
        pairArray[1] = TuplesKt.to((Object)"location", (Object)MapsKt.mapOf((Pair[])pairArray2));
        String string = hit.getDirection().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        pairArray[2] = TuplesKt.to((Object)"face", (Object)string);
        pairArray[3] = TuplesKt.to((Object)"block", (Object)blockId);
        pairArray[4] = TuplesKt.to((Object)"inside", (Object)hit.isInside());
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Object> serializeEntityHit(EntityHitInfo hit, Level level) {
        Entity entity = level.getEntity(hit.getEntityId());
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"id", (Object)hit.getEntityId());
        Object object = new Pair[]{TuplesKt.to((Object)"x", (Object)hit.getLocation().x), TuplesKt.to((Object)"y", (Object)hit.getLocation().y), TuplesKt.to((Object)"z", (Object)hit.getLocation().z)};
        pairArray[1] = TuplesKt.to((Object)"location", (Object)MapsKt.mapOf((Pair[])object));
        Map baseMap = MapsKt.mutableMapOf((Pair[])pairArray);
        if (entity != null) {
            Object object2;
            String string;
            String entityType = String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.getType()));
            baseMap.put("type", entityType);
            if (entity.hasCustomName()) {
                object = baseMap;
                string = "name";
                Object object3 = entity.getCustomName();
                if (object3 == null || (object3 = object3.getString()) == null) {
                    object3 = "";
                }
                object2 = object3;
                object.put(string, object2);
            } else {
                baseMap.put("name", entity.getName().getString());
            }
            object = baseMap;
            string = "pos";
            object2 = new Pair[]{TuplesKt.to((Object)"x", (Object)entity.getX()), TuplesKt.to((Object)"y", (Object)entity.getY()), TuplesKt.to((Object)"z", (Object)entity.getZ())};
            object2 = MapsKt.mapOf((Pair[])object2);
            object.put(string, object2);
        }
        return baseMap;
    }
}

