/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.objects.renderers;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.ints.IntIterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import sh.lem.ccholo.canvas.CanvasRootClient;
import sh.lem.ccholo.objects.renderers.FramebufferPool;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0011J0\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005J&\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lsh/lem/ccholo/objects/renderers/FrameRenderer;", "", "<init>", "()V", "oldFogEnd", "", "Ljava/lang/Float;", "oldFogColor", "", "mc", "Lnet/minecraft/client/Minecraft;", "kotlin.jvm.PlatformType", "getMc", "()Lnet/minecraft/client/Minecraft;", "mc$delegate", "Lkotlin/Lazy;", "bindFramebuffer", "", "framebuffer", "Lcom/mojang/blaze3d/pipeline/TextureTarget;", "unbindFramebuffer", "saveAndSetFog", "restoreFog", "renderToFramebuffer", "width", "", "height", "children", "Lit/unimi/dsi/fastutil/ints/IntIterator;", "canvasRootClient", "Lsh/lem/ccholo/canvas/CanvasRootClient;", "farPlane", "drawFramebufferQuad", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "CC-Holo"})
@SourceDebugExtension(value={"SMAP\nFrameRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameRenderer.kt\nsh/lem/ccholo/objects/renderers/FrameRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class FrameRenderer {
    @NotNull
    public static final FrameRenderer INSTANCE = new FrameRenderer();
    @Nullable
    private static Float oldFogEnd;
    @Nullable
    private static float[] oldFogColor;
    @NotNull
    private static final Lazy mc$delegate;

    private FrameRenderer() {
    }

    private final Minecraft getMc() {
        Lazy lazy = mc$delegate;
        return (Minecraft)lazy.getValue();
    }

    public final void bindFramebuffer(@NotNull TextureTarget framebuffer) {
        Intrinsics.checkNotNullParameter((Object)framebuffer, (String)"framebuffer");
        framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        framebuffer.clear(Minecraft.ON_OSX);
        framebuffer.bindWrite(true);
    }

    public final void unbindFramebuffer() {
        block2: {
            Pair<Integer, Pair<Matrix4f, VertexSorting>> pair = FramebufferPool.INSTANCE.release();
            Integer previousFramebuffer = (Integer)pair.component1();
            Pair projectionState = (Pair)pair.component2();
            if (previousFramebuffer != null) {
                GlStateManager._glBindFramebuffer((int)36160, (int)previousFramebuffer);
            } else {
                this.getMc().getMainRenderTarget().bindWrite(true);
            }
            Pair pair2 = projectionState;
            if (pair2 == null) break block2;
            Pair pair3 = pair2;
            boolean bl = false;
            Matrix4f projMatrix = (Matrix4f)pair3.component1();
            VertexSorting sorting = (VertexSorting)pair3.component2();
            RenderSystem.setProjectionMatrix((Matrix4f)projMatrix, (VertexSorting)sorting);
        }
    }

    public final void saveAndSetFog() {
        oldFogEnd = Float.valueOf(RenderSystem.getShaderFogEnd());
        oldFogColor = RenderSystem.getShaderFogColor();
        RenderSystem.setShaderFogEnd((float)2000.0f);
        RenderSystem.setShaderFogColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    public final void restoreFog() {
        block1: {
            Float f = oldFogEnd;
            if (f != null) {
                float it = ((Number)f).floatValue();
                boolean bl = false;
                RenderSystem.setShaderFogEnd((float)it);
            }
            if (oldFogColor == null) break block1;
            float[] it = oldFogColor;
            boolean bl = false;
            RenderSystem.setShaderFogColor((float)it[0], (float)it[1], (float)it[2], (float)it[3]);
        }
    }

    @Nullable
    public final TextureTarget renderToFramebuffer(int width, int height, @NotNull IntIterator children, @NotNull CanvasRootClient canvasRootClient, float farPlane) {
        PoseStack poseStack;
        Intrinsics.checkNotNullParameter((Object)children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)canvasRootClient, (String)"canvasRootClient");
        float w = width;
        float h = height;
        TextureTarget textureTarget = FramebufferPool.INSTANCE.acquire(width, height);
        if (textureTarget == null) {
            return null;
        }
        TextureTarget framebuffer = textureTarget;
        this.bindFramebuffer(framebuffer);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, w, h, 0.0f, -100.0f, farPlane);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        PoseStack $this$renderToFramebuffer_u24lambda_u244 = poseStack = new PoseStack();
        boolean bl = false;
        $this$renderToFramebuffer_u24lambda_u244.setIdentity();
        $this$renderToFramebuffer_u24lambda_u244.translate(0.0, 0.0, -100.0);
        PoseStack pose = poseStack;
        MultiBufferSource.BufferSource buf = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        GuiGraphics gg = new GuiGraphics(this.getMc(), pose, buf);
        Intrinsics.checkNotNull((Object)buf);
        canvasRootClient.drawChildren(children, gg, (MultiBufferSource)buf);
        gg.flush();
        framebuffer.unbindWrite();
        this.unbindFramebuffer();
        return framebuffer;
    }

    public final void drawFramebufferQuad(@NotNull TextureTarget framebuffer, @NotNull PoseStack poseStack, float width, float height) {
        Intrinsics.checkNotNullParameter((Object)framebuffer, (String)"framebuffer");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        BufferBuilder builder = Tesselator.getInstance().getBuilder();
        Matrix4f pose = poseStack.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (int)framebuffer.getColorTextureId());
        RenderSystem.enableBlend();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.vertex(pose, 0.0f, height, 0.0f).uv(0.0f, 0.0f).endVertex();
        builder.vertex(pose, width, height, 0.0f).uv(1.0f, 0.0f).endVertex();
        builder.vertex(pose, width, 0.0f, 0.0f).uv(1.0f, 1.0f).endVertex();
        builder.vertex(pose, 0.0f, 0.0f, 0.0f).uv(0.0f, 1.0f).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)builder.end());
    }

    private static final Minecraft mc_delegate$lambda$0() {
        return Minecraft.getInstance();
    }

    static {
        mc$delegate = LazyKt.lazy(FrameRenderer::mc_delegate$lambda$0);
    }
}

