/*
 * Decompiled with CFR 0.152.
 */
package sh.lem.ccholo.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import thedarkcolour.kotlinforforge.forge.vectorutil.v3d.Vector3fcUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\u0007J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002\u00a8\u0006\u0019"}, d2={"Lsh/lem/ccholo/util/RaycastUtil;", "", "<init>", "()V", "raycastFromScreen", "Lsh/lem/ccholo/util/RaycastUtil$RaycastResult;", "screenX", "", "screenY", "screenWidth", "", "screenHeight", "reach", "getRayDirectionFromScreen", "Lnet/minecraft/world/phys/Vec3;", "camera", "Lnet/minecraft/client/Camera;", "fov", "raycastEntity", "Lnet/minecraft/world/phys/EntityHitResult;", "entity", "Lnet/minecraft/world/entity/Entity;", "start", "end", "RaycastResult", "CC-Holo"})
public final class RaycastUtil {
    @NotNull
    public static final RaycastUtil INSTANCE = new RaycastUtil();

    private RaycastUtil() {
    }

    @NotNull
    public final RaycastResult raycastFromScreen(double screenX, double screenY, int screenWidth, int screenHeight, double reach) {
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        Entity entity = mc.cameraEntity;
        if (entity == null) {
            return new RaycastResult(null, null);
        }
        Entity entity2 = entity;
        double fov = mc.gameRenderer.getFov(camera, 1.0f, true);
        Intrinsics.checkNotNull((Object)camera);
        Vec3 rayDir = this.getRayDirectionFromScreen(camera, screenX, screenY, screenWidth, screenHeight, fov);
        Vec3 eyePos = camera.getPosition();
        Vec3 reachVec = eyePos.add(rayDir.scale(reach));
        ClientLevel clientLevel = mc.level;
        BlockHitResult blockHit = clientLevel != null ? clientLevel.clip(new ClipContext(eyePos, reachVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity2)) : null;
        Intrinsics.checkNotNull((Object)eyePos);
        Intrinsics.checkNotNull((Object)reachVec);
        EntityHitResult entityHit = this.raycastEntity(entity2, eyePos, reachVec);
        return new RaycastResult(blockHit, entityHit);
    }

    public static /* synthetic */ RaycastResult raycastFromScreen$default(RaycastUtil raycastUtil, double d, double d2, int n, int n2, double d3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            d3 = 20.0;
        }
        return raycastUtil.raycastFromScreen(d, d2, n, n2, d3);
    }

    private final Vec3 getRayDirectionFromScreen(Camera camera, double screenX, double screenY, int screenWidth, int screenHeight, double fov) {
        double ndcX = 2.0 * screenX / (double)screenWidth - 1.0;
        double ndcY = 1.0 - 2.0 * screenY / (double)screenHeight;
        double aspectRatio = (double)screenWidth / (double)screenHeight;
        double fovRad = Math.toRadians(fov);
        double halfHeight = Math.tan(fovRad / 2.0);
        double halfWidth = halfHeight * aspectRatio;
        double camSpaceX = ndcX * halfWidth;
        double camSpaceY = ndcY * halfHeight;
        double camSpaceZ = 1.0;
        Vector3f vector3f = camera.getLookVector();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"getLookVector(...)");
        Vec3 forward = Vector3fcUtilKt.toVec3((Vector3fc)((Vector3fc)vector3f));
        Vector3f vector3f2 = camera.getUpVector();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f2, (String)"getUpVector(...)");
        Vec3 up = Vector3fcUtilKt.toVec3((Vector3fc)((Vector3fc)vector3f2));
        Vec3 right = forward.cross(up).normalize();
        Vec3 actualUp = right.cross(forward).normalize();
        Vec3 worldDir = forward.scale(camSpaceZ).add(right.scale(camSpaceX)).add(actualUp.scale(camSpaceY)).normalize();
        Intrinsics.checkNotNull((Object)worldDir);
        return worldDir;
    }

    private final EntityHitResult raycastEntity(Entity entity, Vec3 start, Vec3 end) {
        Level level = entity.level();
        AABB aabb = entity.getBoundingBox().expandTowards(end.subtract(start));
        return ProjectileUtil.getEntityHitResult((Level)level, (Entity)entity, (Vec3)start, (Vec3)end, (AABB)aabb, RaycastUtil::raycastEntity$lambda$0);
    }

    private static final boolean raycastEntity$lambda$0(Entity target) {
        return !target.isSpectator() && target.isPickable();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lsh/lem/ccholo/util/RaycastUtil$RaycastResult;", "", "blockHit", "Lnet/minecraft/world/phys/BlockHitResult;", "entityHit", "Lnet/minecraft/world/phys/EntityHitResult;", "<init>", "(Lnet/minecraft/world/phys/BlockHitResult;Lnet/minecraft/world/phys/EntityHitResult;)V", "getBlockHit", "()Lnet/minecraft/world/phys/BlockHitResult;", "getEntityHit", "()Lnet/minecraft/world/phys/EntityHitResult;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "CC-Holo"})
    public static final class RaycastResult {
        @Nullable
        private final BlockHitResult blockHit;
        @Nullable
        private final EntityHitResult entityHit;

        public RaycastResult(@Nullable BlockHitResult blockHit, @Nullable EntityHitResult entityHit) {
            this.blockHit = blockHit;
            this.entityHit = entityHit;
        }

        @Nullable
        public final BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        @Nullable
        public final EntityHitResult getEntityHit() {
            return this.entityHit;
        }

        @Nullable
        public final BlockHitResult component1() {
            return this.blockHit;
        }

        @Nullable
        public final EntityHitResult component2() {
            return this.entityHit;
        }

        @NotNull
        public final RaycastResult copy(@Nullable BlockHitResult blockHit, @Nullable EntityHitResult entityHit) {
            return new RaycastResult(blockHit, entityHit);
        }

        public static /* synthetic */ RaycastResult copy$default(RaycastResult raycastResult, BlockHitResult blockHitResult, EntityHitResult entityHitResult, int n, Object object) {
            if ((n & 1) != 0) {
                blockHitResult = raycastResult.blockHit;
            }
            if ((n & 2) != 0) {
                entityHitResult = raycastResult.entityHit;
            }
            return raycastResult.copy(blockHitResult, entityHitResult);
        }

        @NotNull
        public String toString() {
            return "RaycastResult(blockHit=" + this.blockHit + ", entityHit=" + this.entityHit + ")";
        }

        public int hashCode() {
            int result = this.blockHit == null ? 0 : this.blockHit.hashCode();
            result = result * 31 + (this.entityHit == null ? 0 : this.entityHit.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RaycastResult)) {
                return false;
            }
            RaycastResult raycastResult = (RaycastResult)other;
            if (!Intrinsics.areEqual((Object)this.blockHit, (Object)raycastResult.blockHit)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.entityHit, (Object)raycastResult.entityHit);
        }
    }
}

