/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dabomb.datagen;

import com.mrbysco.dabomb.client.DefaultColorTint;
import com.mrbysco.dabomb.registry.BombRegistry;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class BombDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new BombRecipes.Runner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new BombLanguage(packOutput));
        generator.addProvider(true, (DataProvider)new BombSoundDefinitions(packOutput));
        generator.addProvider(true, (DataProvider)new BombModels(packOutput));
    }

    private static class BombRecipes
    extends RecipeProvider {
        public BombRecipes(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            super(provider, recipeOutput);
        }

        protected void buildRecipes() {
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.BOMB_ITEM.get(), 2).pattern(" G ").pattern("GSG").pattern(" G ").define(Character.valueOf('G'), Tags.Items.GUNPOWDERS).define(Character.valueOf('S'), Tags.Items.SANDS).unlockedBy("has_gunpowder", this.has(Tags.Items.GUNPOWDERS)).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.DIRT_BOMB_ITEM.get()).pattern(" D ").pattern("DBD").pattern(" D ").define(Character.valueOf('D'), ItemTags.DIRT).define(Character.valueOf('B'), (ItemLike)BombRegistry.BOMB_ITEM.get()).unlockedBy("has_bomb", this.has((ItemLike)BombRegistry.BOMB_ITEM.get())).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.FLOWER_BOMB_ITEM.get()).pattern(" F ").pattern("FBF").pattern(" F ").define(Character.valueOf('F'), ItemTags.SMALL_FLOWERS).define(Character.valueOf('B'), (ItemLike)BombRegistry.BOMB_ITEM.get()).unlockedBy("has_bomb", this.has((ItemLike)BombRegistry.BOMB_ITEM.get())).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.LAVA_BOMB_ITEM.get()).pattern(" G ").pattern("GLG").pattern(" G ").define(Character.valueOf('G'), Tags.Items.GUNPOWDERS).define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).unlockedBy("has_lava_bucket", this.has((ItemLike)Items.LAVA_BUCKET)).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.WATER_BOMB_ITEM.get()).pattern(" G ").pattern("GWG").pattern(" G ").define(Character.valueOf('G'), Tags.Items.GUNPOWDERS).define(Character.valueOf('W'), (ItemLike)Items.WATER_BUCKET).unlockedBy("has_water_bucket", this.has((ItemLike)Items.WATER_BUCKET)).save(this.output);
            this.shapeless(RecipeCategory.COMBAT, (ItemLike)BombRegistry.STICKY_BOMB_ITEM.get()).requires((ItemLike)BombRegistry.BOMB_ITEM.get()).requires((ItemLike)Items.HONEY_BOTTLE).unlockedBy("has_bomb", this.has((ItemLike)BombRegistry.BOMB_ITEM.get())).save(this.output);
            this.shapeless(RecipeCategory.COMBAT, (ItemLike)BombRegistry.BOUNCY_BOMB_ITEM.get()).requires((ItemLike)BombRegistry.BOMB_ITEM.get()).requires(Tags.Items.SLIME_BALLS).unlockedBy("has_bomb", this.has((ItemLike)BombRegistry.BOMB_ITEM.get())).save(this.output);
            this.shapeless(RecipeCategory.COMBAT, (ItemLike)BombRegistry.DRY_BOMB_ITEM.get()).requires((ItemLike)BombRegistry.BOMB_ITEM.get()).requires((ItemLike)Items.SPONGE).unlockedBy("has_bomb", this.has((ItemLike)BombRegistry.BOMB_ITEM.get())).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.BOMB_FISH_ITEM.get(), 2).pattern(" P ").pattern("GSG").pattern(" G ").define(Character.valueOf('G'), Tags.Items.GUNPOWDERS).define(Character.valueOf('S'), Tags.Items.SANDS).define(Character.valueOf('P'), (ItemLike)Items.PUFFERFISH).unlockedBy("has_gunpowder", this.has(Tags.Items.GUNPOWDERS)).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.BEE_BOMB_ITEM.get(), 2).pattern("GBG").pattern(" G ").define(Character.valueOf('G'), Tags.Items.GUNPOWDERS).define(Character.valueOf('B'), (ItemLike)Items.BEEHIVE).unlockedBy("has_gunpowder", this.has(Tags.Items.GUNPOWDERS)).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.ENDER_BOMB_ITEM.get(), 2).pattern("GEG").pattern(" G ").define(Character.valueOf('G'), Tags.Items.GUNPOWDERS).define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).unlockedBy("has_gunpowder", this.has(Tags.Items.GUNPOWDERS)).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.CLUSTER_BOMB_ITEM.get(), 1).pattern("GEG").pattern(" G ").define(Character.valueOf('G'), Tags.Items.GUNPOWDERS).define(Character.valueOf('E'), Ingredient.of((ItemLike)((ItemLike)BombRegistry.BOMB_ITEM.get()))).unlockedBy("has_gunpowder", this.has(Tags.Items.GUNPOWDERS)).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.DYNAMITE_ITEM.get(), 3).pattern(" # ").pattern("GSG").pattern("GGG").define(Character.valueOf('G'), Tags.Items.GUNPOWDERS).define(Character.valueOf('S'), Tags.Items.SANDS).define(Character.valueOf('#'), Tags.Items.STRINGS).unlockedBy("has_gunpowder", this.has(Tags.Items.GUNPOWDERS)).save(this.output);
            this.shapeless(RecipeCategory.COMBAT, (ItemLike)BombRegistry.STICKY_DYNAMITE_ITEM.get()).requires((ItemLike)BombRegistry.DYNAMITE_ITEM.get()).requires((ItemLike)Items.HONEY_BOTTLE).unlockedBy("has_dynamite", this.has((ItemLike)BombRegistry.DYNAMITE_ITEM.get())).save(this.output);
            this.shapeless(RecipeCategory.COMBAT, (ItemLike)BombRegistry.BOUNCY_DYNAMITE_ITEM.get()).requires((ItemLike)BombRegistry.DYNAMITE_ITEM.get()).requires(Tags.Items.SLIME_BALLS).unlockedBy("has_dynamite", this.has((ItemLike)BombRegistry.DYNAMITE_ITEM.get())).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.C4_ITEM.get(), 2).pattern(" R ").pattern("GSG").pattern("GHG").define(Character.valueOf('G'), Tags.Items.GUNPOWDERS).define(Character.valueOf('S'), Tags.Items.SANDS).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('H'), (ItemLike)Items.HONEY_BOTTLE).unlockedBy("has_gunpowder", this.has(Tags.Items.GUNPOWDERS)).save(this.output);
            this.shaped(RecipeCategory.COMBAT, (ItemLike)BombRegistry.REMOTE.get(), 1).pattern(" RR").pattern("II ").pattern("II ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_redstone", this.has(Tags.Items.DUSTS_REDSTONE)).save(this.output);
        }

        public static class Runner
        extends RecipeProvider.Runner {
            public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
                super(output, completableFuture);
            }

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
                return new BombRecipes(provider, recipeOutput);
            }

            public String getName() {
                return "DaBomb Recipes";
            }
        }
    }

    private static class BombLanguage
    extends LanguageProvider {
        public BombLanguage(PackOutput packOutput) {
            super(packOutput, "dabomb", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.dabomb", "Da Bomb");
            this.addItem((Supplier)BombRegistry.BOMB_ITEM, "Bomb");
            this.addEntityType(BombRegistry.BOMB, "Bomb");
            this.addItem((Supplier)BombRegistry.BOUNCY_BOMB_ITEM, "Bouncy Bomb");
            this.addEntityType(BombRegistry.BOUNCY_BOMB, "Bouncy Bomb");
            this.addItem((Supplier)BombRegistry.BOMB_FISH_ITEM, "Bomb Fish");
            this.addEntityType(BombRegistry.BOMB_FISH, "Bomb Fish");
            this.addItem((Supplier)BombRegistry.STICKY_BOMB_ITEM, "Sticky Bomb");
            this.addEntityType(BombRegistry.STICKY_BOMB, "Sticky Bomb");
            this.addItem((Supplier)BombRegistry.DIRT_BOMB_ITEM, "Dirt Bomb");
            this.addEntityType(BombRegistry.DIRT_BOMB, "Dirt Bomb");
            this.addItem((Supplier)BombRegistry.DRY_BOMB_ITEM, "Dry Bomb");
            this.addEntityType(BombRegistry.DRY_BOMB, "Dry Bomb");
            this.addItem((Supplier)BombRegistry.WATER_BOMB_ITEM, "Water Bomb");
            this.addEntityType(BombRegistry.WATER_BOMB, "Water Bomb");
            this.addItem((Supplier)BombRegistry.LAVA_BOMB_ITEM, "Lava Bomb");
            this.addEntityType(BombRegistry.LAVA_BOMB, "Lava Bomb");
            this.addItem((Supplier)BombRegistry.BEE_BOMB_ITEM, "Bee Bomb");
            this.addEntityType(BombRegistry.BEE_BOMB, "Bee Bomb");
            this.addItem((Supplier)BombRegistry.FLOWER_BOMB_ITEM, "Flower Bomb");
            this.addEntityType(BombRegistry.FLOWER_BOMB, "Flower Bomb");
            this.addItem((Supplier)BombRegistry.ENDER_BOMB_ITEM, "Ender Bomb");
            this.addEntityType(BombRegistry.ENDER_BOMB, "Ender Bomb");
            this.addItem((Supplier)BombRegistry.CLUSTER_BOMB_ITEM, "Cluster Bomb");
            this.addEntityType(BombRegistry.CLUSTER_BOMB, "Cluster Bomb");
            this.addItem((Supplier)BombRegistry.DYNAMITE_ITEM, "Dynamite");
            this.addEntityType(BombRegistry.DYNAMITE, "Dynamite");
            this.addItem((Supplier)BombRegistry.BOUNCY_DYNAMITE_ITEM, "Bouncy Dynamite");
            this.addEntityType(BombRegistry.BOUNCY_DYNAMITE, "Bouncy Dynamite");
            this.addItem((Supplier)BombRegistry.STICKY_DYNAMITE_ITEM, "Sticky Dynamite");
            this.addEntityType(BombRegistry.STICKY_DYNAMITE, "Sticky Dynamite");
            this.addItem((Supplier)BombRegistry.C4_ITEM, "C4");
            this.addEntityType(BombRegistry.C4_ENTITY, "C4");
            this.addItem((Supplier)BombRegistry.REMOTE, "Remote");
            this.addSubtitle((Supplier<SoundEvent>)BombRegistry.BOMB_SHOOT, "Bomb thrown");
            this.addSubtitle((Supplier<SoundEvent>)BombRegistry.DYNAMITE_SHOOT, "Dynamite thrown");
            this.addSubtitle((Supplier<SoundEvent>)BombRegistry.C4_SHOOT, "C4 thrown");
            this.addSubtitle((Supplier<SoundEvent>)BombRegistry.BOMB_PLANTED, "Bomb has been planted");
            this.addSubtitle((Supplier<SoundEvent>)BombRegistry.BOMB_DEFUSED, "Bomb has been defused");
            this.addConfig("bomb", "Bomb", "Bomb settings");
            this.addConfig("beeAmount", "Bee Bomb Amount", "Defines the amount of bees released by Bee bomb");
            this.addConfig("beeBombRadius", "Bee Bomb Radius", "Defines the blast radius of the Bee bomb");
            this.addConfig("bombRadius", "Bomb Radius", "Defines the blast radius of the regular Bomb");
            this.addConfig("bombFishRadius", "Bomb Fish Radius", "Defines the blast radius of the Bomb fish");
            this.addConfig("bouncyBombRadius", "Bouncy Bomb Radius", "Defines the blast radius of the Bouncy bomb");
            this.addConfig("dirtBombRadius", "Dirt Bomb Radius", "Defines the blast radius of the Dirt bomb");
            this.addConfig("dryBombRadius", "Dry Bomb Radius", "Defines the blast radius of the Dry bomb");
            this.addConfig("enderBombRadius", "Ender Bomb Radius", "Defines the blast radius of the Ender bomb");
            this.addConfig("flowerBombRadius", "Flower Bomb Radius", "Defines the blast radius of the Flower bomb");
            this.addConfig("flowerBombChance", "Flower Bomb Chance", "Defines the chance that the Flower bomb will place a random flower per valid location in the blast radius");
            this.addConfig("flowerBombBeeChance", "Flower Bomb Bee Chance", "Defines the chance that the Flower bomb will spawn a bee per valid location in the blast radius");
            this.addConfig("lavaBombRadius", "Lava Bomb Radius", "Defines the blast radius of the Lava bomb");
            this.addConfig("stickyBombRadius", "Sticky Bomb Radius", "Defines the blast radius of the Sticky bomb");
            this.addConfig("waterBombRadius", "Water Bomb Radius", "Defines the blast radius of the Water bomb");
            this.addConfig("clusterBombRadius", "Cluster Bomb Radius", "Defines the blast radius of the Cluster bomb");
            this.addConfig("bombFragmentRadius", "Bomb Fragment Radius", "Defines the blast radius of the Cluster Bomb's Fragment");
            this.addConfig("dynamite", "Dynamite", "Dynamite settings");
            this.addConfig("dynamiteRadius", "Dynamite Radius", "Defines the blast radius of the Dynamite");
            this.addConfig("bouncyDynamiteRadius", "Bouncy Dynamite Radius", "Defines the blast radius of the Bouncy Dynamite");
            this.addConfig("stickyDynamiteRadius", "Sticky Dynamite Radius", "Defines the blast radius of the Sticky Dynamite");
            this.addConfig("other", "Other", "Other settings");
            this.addConfig("c4Radius", "C4 Radius", "Defines the blast radius of the C4");
            this.addConfig("bomberman", "Bomberman", "Bomberman settings");
            this.addConfig("enableBomberman", "Enable Bomberman", "Enables the Bomberman game mode");
            this.addConfig("bombermanList", "Bomberman List", "Defines the list of bombs that can be used in Bomberman");
        }

        public void addSubtitle(Supplier<SoundEvent> sound, String name) {
            this.addSubtitle(sound.get(), name);
        }

        public void addSubtitle(SoundEvent sound, String name) {
            String path = "dabomb.subtitle." + sound.location().getPath();
            this.add(path, name);
        }

        private void addConfig(String path, String name, @Nullable String description) {
            this.add("dabomb.configuration." + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("dabomb.configuration." + path + ".tooltip", description);
            }
        }
    }

    private static class BombSoundDefinitions
    extends SoundDefinitionsProvider {
        public BombSoundDefinitions(PackOutput packOutput) {
            super(packOutput, "dabomb");
        }

        public void registerSounds() {
            this.add((Supplier)BombRegistry.BOMB_SHOOT, BombSoundDefinitions.definition().subtitle(this.modSubtitle(BombRegistry.BOMB_SHOOT.getId())).with(BombSoundDefinitions.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"random/bow"))));
            this.add((Supplier)BombRegistry.DYNAMITE_SHOOT, BombSoundDefinitions.definition().subtitle(this.modSubtitle(BombRegistry.DYNAMITE_SHOOT.getId())).with(BombSoundDefinitions.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"random/bow"))));
            this.add((Supplier)BombRegistry.C4_SHOOT, BombSoundDefinitions.definition().subtitle(this.modSubtitle(BombRegistry.C4_SHOOT.getId())).with(BombSoundDefinitions.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"random/bow"))));
            this.add((Supplier)BombRegistry.BOMB_PLANTED, BombSoundDefinitions.definition().subtitle(this.modSubtitle(BombRegistry.BOMB_PLANTED.getId())).with(BombSoundDefinitions.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dabomb", (String)"bomb_planted"))));
            this.add((Supplier)BombRegistry.BOMB_DEFUSED, BombSoundDefinitions.definition().subtitle(this.modSubtitle(BombRegistry.BOMB_DEFUSED.getId())).with(BombSoundDefinitions.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dabomb", (String)"bomb_defused"))));
        }

        public String modSubtitle(ResourceLocation id) {
            return "dabomb.subtitle." + id.getPath();
        }
    }

    private static class BombModels
    extends ModelProvider {
        public BombModels(PackOutput packOutput) {
            super(packOutput, "dabomb");
        }

        protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
            BombRegistry.ITEMS.getEntries().forEach(deferredItem -> {
                if (deferredItem.getId().equals((Object)BombRegistry.WATER_BOMB_ITEM.getId())) {
                    itemModels.generateItemWithTintedOverlay((Item)deferredItem.get(), (ItemTintSource)new DefaultColorTint());
                } else {
                    itemModels.generateFlatItem((Item)deferredItem.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
                }
            });
        }
    }
}

