/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dabomb.entity;

import com.mrbysco.dabomb.config.BombConfig;
import com.mrbysco.dabomb.registry.BombRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BouncyDynamite
extends ThrowableItemProjectile {
    private int bounceCount = 0;

    public BouncyDynamite(EntityType<? extends BouncyDynamite> entityType, Level level) {
        super(entityType, level);
    }

    protected Item getDefaultItem() {
        return (Item)BombRegistry.BOUNCY_DYNAMITE_ITEM.get();
    }

    private ParticleOptions getParticle() {
        ItemStack itemstack = this.getItem();
        return itemstack.isEmpty() ? ParticleTypes.SMOKE : new ItemParticleOption(ParticleTypes.ITEM, itemstack);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void onHit(HitResult hitResult) {
        if (this.bounceCount >= 3 || this.tickCount >= 160) {
            if (!this.level().isClientSide) {
                this.explode();
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
                this.discard();
            }
        } else {
            ++this.bounceCount;
            super.onHit(hitResult);
        }
    }

    protected void onHitBlock(BlockHitResult hitBlock) {
        double velX = this.getDeltaMovement().x;
        double velY = this.getDeltaMovement().y;
        double velZ = this.getDeltaMovement().z;
        Direction direction = hitBlock.getDirection();
        BlockPos blockPos = hitBlock.getBlockPos();
        BlockState blockstate = this.level().getBlockState(blockPos);
        if (blockstate.blocksMotion()) {
            if (!this.level().isClientSide && this.bounceCount < 6) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.METAL_HIT, SoundSource.NEUTRAL, 1.0f, 4.0f);
            }
            if (direction == Direction.EAST || direction == Direction.WEST) {
                this.setDeltaMovement(-velX, velY, velZ);
            }
            if (direction == Direction.DOWN || direction == Direction.UP) {
                this.setDeltaMovement(velX, -velY, velZ);
            }
            if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                this.setDeltaMovement(velX, velY, -velZ);
            }
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        double velX = this.getDeltaMovement().x;
        double velY = this.getDeltaMovement().y;
        double velZ = this.getDeltaMovement().z;
        double absVelX = Math.abs(velX);
        double absVelY = Math.abs(velY);
        double absVelZ = Math.abs(velZ);
        if (absVelX >= absVelY && absVelX >= absVelZ) {
            this.setDeltaMovement(-velX, velY, velZ);
        }
        if (absVelY >= absVelX && absVelY >= absVelZ) {
            this.setDeltaMovement(velX, -velY, velZ);
        }
        if (absVelZ >= absVelY && absVelZ >= absVelX) {
            this.setDeltaMovement(velX, velY, -velZ);
        }
    }

    public void shootFromRotation(Entity entity, float x, float y, float z, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(y * ((float)Math.PI / 180))) * Mth.cos((float)(x * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(y * ((float)Math.PI / 180))) * Mth.cos((float)(x * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.7f, 0.5, (double)0.7f));
        Vec3 vec3 = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vec3.x, entity.onGround() ? 0.0 : vec3.y, vec3.z));
    }

    protected void explode() {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625) + 0.5, this.getZ(), ((Double)BombConfig.COMMON.bouncyDynamiteRadius.get()).floatValue(), Level.ExplosionInteraction.TNT);
    }
}

