/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dabomb.entity.goal;

import com.mrbysco.dabomb.item.ThrowableItem;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;

public class ShootBombGoal
extends Goal {
    private final Mob bomber;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;
    private final EntityType<?> projectile;
    private final SoundEvent soundEvent;
    private final float velocity;
    private final float inaccuracy;
    private final float z;

    public ShootBombGoal(Mob bomber, EntityType<?> projectileType, SoundEvent soundEvent, float bombVelocity, float bomInaccuracy, float z) {
        this.bomber = bomber;
        this.projectile = projectileType;
        this.soundEvent = soundEvent;
        this.speedModifier = 1.25;
        this.attackIntervalMin = 40;
        this.attackIntervalMax = 40;
        this.attackRadius = 20.0f;
        this.attackRadiusSqr = 400.0f;
        this.velocity = bombVelocity;
        this.inaccuracy = bomInaccuracy;
        this.z = z;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingentity = this.bomber.getTarget();
        if (livingentity != null && livingentity.isAlive()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.bomber.getMainHandItem().getItem() instanceof ThrowableItem && (this.canUse() || !this.bomber.getNavigation().isDone());
    }

    public void stop() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        double d0 = this.bomber.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean flag = this.bomber.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
            this.bomber.getNavigation().stop();
        } else {
            this.bomber.getNavigation().moveTo((Entity)this.target, this.speedModifier);
        }
        this.bomber.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!flag) {
                return;
            }
            float f = (float)Math.sqrt(d0) / this.attackRadius;
            this.shootBomb();
            this.attackTime = Mth.floor((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }

    private void shootBomb() {
        ServerLevel serverLevel;
        Entity entity;
        Level level = this.bomber.level();
        if (level instanceof ServerLevel && (entity = this.projectile.create((Level)(serverLevel = (ServerLevel)level), EntitySpawnReason.EVENT)) instanceof ThrowableItemProjectile) {
            ThrowableItemProjectile bomb = (ThrowableItemProjectile)entity;
            level.playSound((Entity)((Player)null), this.bomber.getX(), this.bomber.getY(), this.bomber.getZ(), this.soundEvent, SoundSource.HOSTILE, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            bomb.setPosRaw(this.bomber.getX(), this.bomber.getEyeY() - (double)0.1f, this.bomber.getZ());
            bomb.setItem(this.bomber.getMainHandItem());
            bomb.setOwner((Entity)this.bomber);
            bomb.shootFromRotation((Entity)this.bomber, this.bomber.getXRot(), this.bomber.getYRot(), this.z, this.velocity, this.inaccuracy);
            level.addFreshEntity((Entity)bomb);
            this.bomber.getMainHandItem().shrink(1);
        }
    }
}

