/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dabomb.explosion;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class FluidExplosion
extends ServerExplosion {
    private final Predicate<FluidState> fluidPredicate;

    public FluidExplosion(ServerLevel level, @Nullable Entity entity, Vec3 center, float radius, boolean flames, Predicate<FluidState> fluidPredicate, Explosion.BlockInteraction blockInteraction) {
        super(level, entity, null, null, center, radius, flames, blockInteraction);
        this.fluidPredicate = fluidPredicate;
    }

    public static float getSeenPercent(Vec3 p_46065_, Entity boundingBox) {
        AABB aabb = boundingBox.getBoundingBox();
        double d0 = 1.0 / ((aabb.maxX - aabb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((aabb.maxY - aabb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((aabb.maxZ - aabb.minZ) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = Mth.lerp((double)d5, (double)aabb.minX, (double)aabb.maxX);
                        double d9 = Mth.lerp((double)d6, (double)aabb.minY, (double)aabb.maxY);
                        double d10 = Mth.lerp((double)d7, (double)aabb.minZ, (double)aabb.maxZ);
                        Vec3 vec3 = new Vec3(d8 + d3, d9, d10 + d4);
                        if (boundingBox.level().clip(new ClipContext(vec3, p_46065_, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, boundingBox)).getType() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void explode() {
        this.level.gameEvent(this.source, (Holder)GameEvent.EXPLODE, BlockPos.containing((Position)this.center()));
        HashSet set = Sets.newHashSet();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                block2: for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d0 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double x = this.center().x;
                    double y = this.center().y;
                    double z = this.center().z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
                        BlockState blockstate = this.level.getBlockState(blockpos);
                        FluidState fluidstate = this.level.getFluidState(blockpos);
                        if (!this.level.isInWorldBounds(blockpos)) continue block2;
                        if (this.fluidPredicate.test(fluidstate) || blockstate.isAir() || blockstate.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                            set.add(blockpos);
                        }
                        x += d0 * (double)0.3f;
                        y += d1 * (double)0.3f;
                        z += d2 * (double)0.3f;
                    }
                }
            }
        }
        ArrayList toBlow = new ArrayList(set);
        float f2 = this.radius * 2.0f;
        int k1 = Mth.floor((double)(this.center().x - (double)f2 - 1.0));
        int l1 = Mth.floor((double)(this.center().x + (double)f2 + 1.0));
        int i2 = Mth.floor((double)(this.center().y - (double)f2 - 1.0));
        int i1 = Mth.floor((double)(this.center().y + (double)f2 + 1.0));
        int j2 = Mth.floor((double)(this.center().z - (double)f2 - 1.0));
        int j1 = Mth.floor((double)(this.center().z + (double)f2 + 1.0));
        List list = this.level.getEntities(this.source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        EventHooks.onExplosionDetonate((Level)this.level, (ServerExplosion)this, (List)list, toBlow);
        for (int i = 0; i < list.size(); ++i) {
            Player player;
            double d10;
            double d9;
            double d7;
            double d5;
            double d12;
            double d11;
            Entity entity = (Entity)list.get(i);
            if (entity.ignoreExplosion((Explosion)this) || !((d11 = Math.sqrt(entity.distanceToSqr(this.center())) / (double)f2) <= 1.0) || (d12 = Math.sqrt((d5 = entity.getX() - this.center().x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.getY() : entity.getEyeY()) - this.center().y) * d7 + (d9 = entity.getZ() - this.center().z) * d9)) == 0.0) continue;
            d5 /= d12;
            d7 /= d12;
            d9 /= d12;
            boolean flag = this.damageCalculator.shouldDamageEntity((Explosion)this, entity);
            float f1 = this.damageCalculator.getKnockbackMultiplier(entity);
            if (flag) {
                float seenPercentage = !flag && f1 == 0.0f ? 0.0f : FluidExplosion.getSeenPercent(this.center(), entity);
                entity.hurtServer(this.level, this.damageSource, this.damageCalculator.getEntityDamageAmount((Explosion)this, entity, seenPercentage));
            }
            double d13 = (1.0 - d11) * (double)FluidExplosion.getSeenPercent(this.center(), entity) * (double)this.damageCalculator.getKnockbackMultiplier(entity);
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                d10 = d13 * (1.0 - livingentity.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE));
            } else {
                d10 = d13;
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || (player = (Player)entity).isSpectator() || player.isCreative() && player.getAbilities().flying) continue;
            this.hitPlayers.put(player, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
    }
}

