/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dabomb.handler;

import com.mrbysco.dabomb.config.BombConfig;
import com.mrbysco.dabomb.entity.BeeBomb;
import com.mrbysco.dabomb.entity.BombFish;
import com.mrbysco.dabomb.entity.DirtBomb;
import com.mrbysco.dabomb.entity.DryBomb;
import com.mrbysco.dabomb.entity.EnderBomb;
import com.mrbysco.dabomb.entity.FlowerBomb;
import com.mrbysco.dabomb.entity.LavaBomb;
import com.mrbysco.dabomb.entity.WaterBomb;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.event.level.ExplosionEvent;

public class ExplosionHandler {
    public static void onDetonate(ExplosionEvent.Detonate event) {
        block13: {
            Object optionalTag;
            Object livingEntities;
            ServerLevel serverLevel;
            List affectedEntities;
            Level level;
            ServerExplosion explosion;
            block20: {
                List affectedBlocks;
                block19: {
                    Object object;
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        explosion = event.getExplosion();
                                        level = event.getLevel();
                                        affectedBlocks = event.getAffectedBlocks();
                                        affectedEntities = event.getAffectedEntities();
                                        if (!(level instanceof ServerLevel)) break block13;
                                        serverLevel = (ServerLevel)level;
                                        if (!(explosion.getDirectSourceEntity() instanceof DirtBomb)) break block14;
                                        for (BlockPos pos : affectedBlocks) {
                                            BlockState state = level.getBlockState(pos);
                                            if (!state.isAir() && !state.canBeReplaced()) continue;
                                            level.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
                                        }
                                        break block13;
                                    }
                                    if (!(explosion.getDirectSourceEntity() instanceof WaterBomb)) break block15;
                                    for (BlockPos pos : affectedBlocks) {
                                        BlockState state = level.getBlockState(pos);
                                        if (state.isAir()) {
                                            level.setBlockAndUpdate(pos, Blocks.WATER.defaultBlockState());
                                            continue;
                                        }
                                        Block block = state.getBlock();
                                        if (!(block instanceof SimpleWaterloggedBlock)) continue;
                                        SimpleWaterloggedBlock waterloggedBlock = (SimpleWaterloggedBlock)block;
                                        waterloggedBlock.placeLiquid((LevelAccessor)level, pos, state, Fluids.WATER.getSource(false));
                                    }
                                    break block13;
                                }
                                if (!(explosion.getDirectSourceEntity() instanceof LavaBomb)) break block16;
                                for (BlockPos pos : affectedBlocks) {
                                    BlockState state = level.getBlockState(pos);
                                    if (!state.isAir() && !state.canBeReplaced()) continue;
                                    level.setBlockAndUpdate(pos, Blocks.LAVA.defaultBlockState());
                                }
                                break block13;
                            }
                            if (!(explosion.getDirectSourceEntity() instanceof DryBomb)) break block17;
                            for (BlockPos pos : affectedBlocks) {
                                BlockState state = level.getBlockState(pos);
                                if (state.getBlock() instanceof LiquidBlock && state.canBeReplaced()) {
                                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                                    continue;
                                }
                                Block block = state.getBlock();
                                if (!(block instanceof SimpleWaterloggedBlock)) continue;
                                SimpleWaterloggedBlock waterloggedBlock = (SimpleWaterloggedBlock)block;
                                waterloggedBlock.pickupBlock(null, (LevelAccessor)level, pos, state);
                            }
                            break block13;
                        }
                        object = explosion.getDirectSourceEntity();
                        if (!(object instanceof BombFish)) break block18;
                        BombFish bombFish = (BombFish)((Object)object);
                        for (Entity entity2 : affectedEntities) {
                            if (!(entity2 instanceof LivingEntity)) continue;
                            LivingEntity livingEntity = (LivingEntity)entity2;
                            if (bombFish.getOwner().getUUID().equals(entity2.getUUID())) continue;
                            livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0), (Entity)bombFish);
                        }
                        break block13;
                    }
                    object = explosion.getDirectSourceEntity();
                    if (!(object instanceof BeeBomb)) break block19;
                    BeeBomb beeBomb = (BeeBomb)((Object)object);
                    livingEntities = affectedEntities.stream().filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).toList();
                    for (int i = 0; i < (Integer)BombConfig.COMMON.beeAmount.get(); ++i) {
                        Bee bee = (Bee)EntityType.BEE.create(level, EntitySpawnReason.MOB_SUMMONED);
                        if (bee == null) continue;
                        bee.setPosRaw(beeBomb.getX(), beeBomb.getY() + 0.5, beeBomb.getZ());
                        if (!livingEntities.isEmpty()) {
                            bee.setPersistentAngerTarget(((LivingEntity)livingEntities.get(level.random.nextInt(livingEntities.size()))).getUUID());
                            bee.startPersistentAngerTimer();
                        }
                        level.addFreshEntity((Entity)bee);
                    }
                    break block13;
                }
                livingEntities = explosion.getDirectSourceEntity();
                if (!(livingEntities instanceof FlowerBomb)) break block20;
                FlowerBomb flowerBomb = (FlowerBomb)((Object)livingEntities);
                optionalTag = BuiltInRegistries.BLOCK.get(BlockTags.SMALL_FLOWERS);
                if (!((Optional)optionalTag).isPresent()) break block13;
                for (BlockPos pos : affectedBlocks) {
                    BlockState state = level.getBlockState(pos);
                    if (!level.getBlockState(pos.below()).is(BlockTags.DIRT) || !state.isAir()) continue;
                    ((HolderSet.Named)((Optional)optionalTag).get()).getRandomElement(level.random).ifPresent(holder -> {
                        Block flower = (Block)holder.value();
                        BlockState flowerState = flower.defaultBlockState();
                        if (flowerState.canSurvive((LevelReader)level, pos)) {
                            Bee bee;
                            if (level.random.nextDouble() <= (Double)BombConfig.COMMON.flowerBombChance.get()) {
                                level.setBlockAndUpdate(pos, flowerState);
                            }
                            if (level.random.nextDouble() <= (Double)BombConfig.COMMON.flowerBombBeeChance.get() && (bee = (Bee)EntityType.BEE.create(level, EntitySpawnReason.MOB_SUMMONED)) != null) {
                                bee.setPosRaw(flowerBomb.getX(), flowerBomb.getY() + 0.5, flowerBomb.getZ());
                                level.addFreshEntity((Entity)bee);
                            }
                        }
                    });
                }
                break block13;
            }
            optionalTag = explosion.getDirectSourceEntity();
            if (optionalTag instanceof EnderBomb) {
                EnderBomb bomb = (EnderBomb)((Object)optionalTag);
                livingEntities = affectedEntities.stream().filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).toList();
                Iterator iterator = livingEntities.iterator();
                while (iterator.hasNext()) {
                    LivingEntity livingEntity = (LivingEntity)iterator.next();
                    int maxTries = 5;
                    for (int tries = 0; tries < maxTries; ++tries) {
                        Player player;
                        double targetX = livingEntity.getX() + (level.random.nextDouble() - 0.5) * 64.0;
                        double targetY = livingEntity.getY() + (double)(level.random.nextInt(64) - 32);
                        double targetZ = livingEntity.getZ() + (level.random.nextDouble() - 0.5) * 64.0;
                        if (livingEntity instanceof Player && (player = (Player)livingEntity).isCreative() || !livingEntity.randomTeleport(targetX, targetY, targetZ, true)) continue;
                        level.playSound((Entity)((Player)null), targetX, targetY, targetZ, SoundEvents.ENDERMAN_TELEPORT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        break;
                    }
                    livingEntity.hurtServer(serverLevel, bomb.damageSources().explosion((Explosion)explosion), 2.0f);
                    affectedEntities.remove(livingEntity);
                }
            }
        }
    }
}

