package com.github.barnabeepickle.modmenu.config;

import com.github.barnabeepickle.modmenu.util.HardcodedUtil;
import net.fabricmc.loader.api.ModContainer;

import java.util.Comparator;

public class ModMenuConfig {
	private boolean showLibraries = false;
	private Sorting sorting = Sorting.ASCENDING;

	public void toggleShowLibraries() {
		this.showLibraries = !this.showLibraries;
		ModMenuConfigManager.save();
	}

	public void toggleSortMode() {
		this.sorting = Sorting.values()[(sorting.ordinal() + 1) % Sorting.values().length];
		ModMenuConfigManager.save();
	}

	public boolean showLibraries() {
		return showLibraries;
	}

	public Sorting getSorting() {
		return sorting != null ? sorting : Sorting.ASCENDING;
	}

	public enum Sorting {
		ASCENDING(Comparator.comparing(modContainer -> HardcodedUtil.formatFabricModuleName(modContainer.getMetadata().getName())), "modmenu.sorting.ascending"),
		DESCENDING(ASCENDING.getComparator().reversed(), "modmenu.sorting.descending");

		Comparator<ModContainer> comparator;
		String translationKey;

		Sorting(Comparator<ModContainer> comparator, String translationKey) {
			this.comparator = comparator;
			this.translationKey = translationKey;
		}

		public Comparator<ModContainer> getComparator() {
			return comparator;
		}

		public String getTranslationKey() {
			return translationKey;
		}
	}
}
