package com.github.barnabeepickle.modmenu.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import java.util.List;

@Environment(EnvType.CLIENT)
public class RenderUtils {
	private static final class_310 CLIENT = class_310.method_1551();

	public static void drawWrappedString(String string, int x, int y, int wrapWidth, int lines, int color) {
		while (string != null && string.endsWith("\n")) {
			string = string.substring(0, string.length() - 1);
		}
		List<String> strings = CLIENT.field_1772.method_1728(string, wrapWidth);
		for (int i = 0; i < strings.size(); i++) {
			if (i >= lines) {
				break;
			}
			String line = strings.get(i);
			if (i == lines - 1 && strings.size() > lines) {
				line += "...";
			}
			int x1 = x;
			if (CLIENT.field_1772.method_1726()) {
				int width = CLIENT.field_1772.method_1727(CLIENT.field_1772.method_1721(line));
				x1 += (float) (wrapWidth - width);
			}
			CLIENT.field_1772.method_1729(line, x1, y + i * CLIENT.field_1772.field_2000, color);
		}
	}

	public static void drawBadge(int x, int y, int tagWidth, String text, int outlineColor, int fillColor, int textColor) {
		class_332.fill(x + 1, y - 1, x + tagWidth, y, outlineColor);
		class_332.fill(x, y, x + 1, y + CLIENT.field_1772.field_2000, outlineColor);
		class_332.fill(x + 1, y + 1 + CLIENT.field_1772.field_2000 - 1, x + tagWidth, y + CLIENT.field_1772.field_2000 + 1, outlineColor);
		class_332.fill(x + tagWidth, y, x + tagWidth + 1, y + CLIENT.field_1772.field_2000, outlineColor);
		class_332.fill(x + 1, y, x + tagWidth, y + CLIENT.field_1772.field_2000, fillColor);
		CLIENT.field_1772.method_1729(text, (x + 1 + (tagWidth - CLIENT.field_1772.method_1727(text)) / (float) 2), y + 1, textColor);
	}
}
