package com.github.barnabeepickle.modmenu.gui;

import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.github.barnabeepickle.modmenu.ModMenu;
import com.github.barnabeepickle.modmenu.config.ModMenuConfigManager;
import com.github.barnabeepickle.modmenu.util.BadgeRenderer;
import com.github.barnabeepickle.modmenu.util.HardcodedUtil;
import com.github.barnabeepickle.modmenu.util.RenderUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ModListScreen extends class_437 {
	private static final class_2960 FILTERS_BUTTON_LOCATION = new class_2960(ModMenu.MOD_ID, "textures/gui/filters_button.png");
	private static final class_2960 CONFIGURE_BUTTON_LOCATION = new class_2960(ModMenu.MOD_ID, "textures/gui/configure_button.png");
	@SuppressWarnings("unused")
	private static final Logger LOGGER = LogManager.getLogger();
	private final String textTitle;
	private class_342 searchBox;
	private DescriptionListWidget descriptionListWidget;
	private class_437 parent;
	private ModListWidget modList;
	private String tooltip;
	private ModListEntry selected;
	private BadgeRenderer badgeRenderer;
	private double scrollPercent = 0;
	private boolean showModCount = false;
	private boolean init = false;
	private boolean filterOptionsShown = false;
	private int paneY;
	private int paneWidth;
	private int rightPaneX;
	private int searchBoxX;
	public Set<String> showModChildren = new HashSet<>();

	public ModListScreen(class_437 previousGui) {
		super(new class_2588("modmenu.title"));
		this.parent = previousGui;
		this.textTitle = title.method_10863();
	}

	@Override
	public boolean mouseScrolled(double double_1, double double_2, double double_3) {
		if (modList.isMouseOver(double_1, double_2))
			return this.modList.mouseScrolled(double_1, double_2, double_3);
		if (descriptionListWidget.isMouseOver(double_1, double_2))
			return this.descriptionListWidget.mouseScrolled(double_1, double_2, double_3);
		return false;
	}

	@Override
	public void tick() {
		this.searchBox.method_1865();
	}

	@SuppressWarnings("deprecation")
	@Override
	protected void init() {
		Objects.requireNonNull(this.minecraft).field_1774.method_1462(true);
		paneY = 48;
		paneWidth = this.width / 2 - 8;
		rightPaneX = width - paneWidth;

		int searchBoxWidth = paneWidth - 32 - 22;
		searchBoxX = paneWidth / 2 - searchBoxWidth / 2 - 22 / 2;
		this.searchBox = new class_342(this.font, searchBoxX, 22, searchBoxWidth, 20, this.searchBox, class_1074.method_4662("selectWorld.search"));
		this.searchBox.method_1863((string_1) -> this.modList.filter(string_1, false));
		this.modList = new ModListWidget(this.minecraft, paneWidth, this.height, paneY + 19, this.height - 36, 36, this.searchBox.method_1882(), this.modList, this);
		this.modList.setLeftPos(0);
		this.descriptionListWidget = new DescriptionListWidget(this.minecraft, paneWidth, this.height, paneY + 60, this.height - 36, font.field_2000 + 1, this);
		this.descriptionListWidget.setLeftPos(rightPaneX);
		class_4185 configureButton = new ModMenuTexturedButtonWidget(width - 24, paneY, 20, 20, 0, 0, CONFIGURE_BUTTON_LOCATION, 32, 64, button -> {
			final String modid = Objects.requireNonNull(selected).getMetadata().getId();
			final class_437 screen = ModMenu.getConfigScreen(modid, this);
			if (screen != null) {
				minecraft.method_1507(screen);
			} else {
				ModMenu.openConfigScreen(modid);
			}
		},
			class_1074.method_4662("modmenu.configure")) {
			@Override
			public void render(int mouseX, int mouseY, float delta) {
				if (selected != null) {
					String modid = selected.getMetadata().getId();
					active = ModMenu.hasFactory(modid) || ModMenu.hasLegacyConfigScreenTask(modid);
				} else {
					active = false;
				}
				visible = active;
				super.render(mouseX, mouseY, delta);
			}

			@Override
			public void renderButton(int int_1, int int_2, float float_1) {
				GlStateManager.color4f(1, 1, 1, 1f);
				super.renderButton(int_1, int_2, float_1);
			}
		};
		int urlButtonWidths = paneWidth / 2 - 2;
		int cappedButtonWidth = urlButtonWidths > 200 ? 200 : urlButtonWidths;
		class_4185 websiteButton = new class_4185(rightPaneX + (urlButtonWidths / 2) - (cappedButtonWidth / 2), paneY + 36, urlButtonWidths > 200 ? 200 : urlButtonWidths, 20,
			class_1074.method_4662("modmenu.website"), button -> {
			final ModMetadata metadata = Objects.requireNonNull(selected).getMetadata();
			this.minecraft.method_1507(new class_407((bool) -> {
				if (bool) {
					class_156.method_668().method_670(metadata.getContact().get("homepage").get());
				}
				this.minecraft.method_1507(this);
			}, metadata.getContact().get("homepage").get(), true));
		}) {
			@Override
			public void render(int var1, int var2, float var3) {
				visible = selected != null;
				active = visible && selected.getMetadata().getContact().get("homepage").isPresent();
				super.render(var1, var2, var3);
			}
		};
		class_4185 issuesButton = new class_4185(rightPaneX + urlButtonWidths + 4 + (urlButtonWidths / 2) - (cappedButtonWidth / 2), paneY + 36, urlButtonWidths > 200 ? 200 : urlButtonWidths, 20,
			class_1074.method_4662("modmenu.issues"), button -> {
			final ModMetadata metadata = Objects.requireNonNull(selected).getMetadata();
			this.minecraft.method_1507(new class_407((bool) -> {
				if (bool) {
					class_156.method_668().method_670(metadata.getContact().get("issues").get());
				}
				this.minecraft.method_1507(this);
			}, metadata.getContact().get("issues").get(), true));
		}) {
			@Override
			public void render(int var1, int var2, float var3) {
				visible = selected != null;
				active = visible && selected.getMetadata().getContact().get("issues").isPresent();
				super.render(var1, var2, var3);
			}
		};
		this.children.add(this.searchBox);
		this.addButton(new ModMenuTexturedButtonWidget(paneWidth / 2 + searchBoxWidth / 2 - 20 / 2 + 2, 22, 20, 20, 0, 0, FILTERS_BUTTON_LOCATION, 32, 64, button -> {
			filterOptionsShown = !filterOptionsShown;
		}) {
			@Override
			public void render(int int_1, int int_2, float float_1) {
				super.render(int_1, int_2, float_1);
				if (isHovered()) {
					setTooltip(class_1074.method_4662("modmenu.toggleFilterOptions"));
				}
			}
		});
		String showLibrariesText = class_1074.method_4662("modmenu.showLibraries", class_1074.method_4662("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries()));
		String sortingText = class_1074.method_4662("modmenu.sorting", class_1074.method_4662(ModMenuConfigManager.getConfig().getSorting().getTranslationKey()));
		int showLibrariesWidth = font.method_1727(showLibrariesText) + 20;
		int sortingWidth = font.method_1727(sortingText) + 20;
		int filtersX;
		int filtersWidth = showLibrariesWidth + sortingWidth + 2;
		if ((filtersWidth + font.method_1727(class_1074.method_4662("modmenu.showingMods", NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()))) + 20) >= searchBoxX + searchBoxWidth + 22) {
			filtersX = paneWidth / 2 - filtersWidth / 2;
			showModCount = false;
		} else {
			filtersX = searchBoxX + searchBoxWidth + 22 - filtersWidth + 1;
			showModCount = true;
		}
		this.addButton(new class_4185(filtersX, 45, sortingWidth, 20, sortingText, button -> {
			ModMenuConfigManager.getConfig().toggleSortMode();
			modList.reloadFilters();
		}) {
			@Override
			public void render(int mouseX, int mouseY, float delta) {
				visible = filterOptionsShown;
				this.setMessage(class_1074.method_4662("modmenu.sorting", class_1074.method_4662(ModMenuConfigManager.getConfig().getSorting().getTranslationKey())));
				super.render(mouseX, mouseY, delta);
			}
		});
		this.addButton(new class_4185(filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, class_1074.method_4662("modmenu.showLibraries", class_1074.method_4662("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries())), button -> {
			ModMenuConfigManager.getConfig().toggleShowLibraries();
			modList.reloadFilters();
		}) {
			@Override
			public void render(int mouseX, int mouseY, float delta) {
				visible = filterOptionsShown;
				this.setMessage(class_1074.method_4662("modmenu.showLibraries", class_1074.method_4662("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries())));
				super.render(mouseX, mouseY, delta);
			}
		});
		this.children.add(this.modList);
		this.addButton(configureButton);
		this.addButton(websiteButton);
		this.addButton(issuesButton);
		this.children.add(this.descriptionListWidget);
		this.addButton(new class_4185(this.width / 2 - 154, this.height - 28, 150, 20, class_1074.method_4662("modmenu.modsFolder"), button -> class_156.method_668().method_672(new File(FabricLoader.getInstance().getGameDirectory(), "mods"))));
		this.addButton(new class_4185(this.width / 2 + 4, this.height - 28, 150, 20, class_1074.method_4662("gui.done"), button -> minecraft.method_1507(parent)));
		this.method_20085(this.searchBox);

		init = true;
	}

	public ModListWidget getModList() {
		return modList;
	}

	@Override
	public boolean keyPressed(int int_1, int int_2, int int_3) {
		return super.keyPressed(int_1, int_2, int_3) || this.searchBox.keyPressed(int_1, int_2, int_3);
	}

	@Override
	public boolean charTyped(char char_1, int int_1) {
		return this.searchBox.charTyped(char_1, int_1);
	}

	@Override
	public void render(int mouseX, int mouseY, float delta) {
		ModListScreen.overlayBackground(paneWidth, 0, rightPaneX, height, 64, 64, 64, 255, 255);
		this.tooltip = null;
		ModListEntry selectedEntry = selected;
		if (selectedEntry != null) {
			this.descriptionListWidget.render(mouseX, mouseY, delta);
		}
		this.modList.render(mouseX, mouseY, delta);
		this.searchBox.render(mouseX, mouseY, delta);
		GlStateManager.disableBlend();
		this.drawCenteredString(this.font, this.textTitle, this.modList.getWidth() / 2, 8, 16777215);
		super.render(mouseX, mouseY, delta);
		if (showModCount || !filterOptionsShown) {
			font.method_1729(class_1074.method_4662("modmenu.showingMods", NumberFormat.getInstance().format(modList.getDisplayedCount()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size())), searchBoxX, 52, 0xFFFFFF);
		}
		if (selectedEntry != null) {
			ModMetadata metadata = selectedEntry.getMetadata();
			int x = rightPaneX;
			GlStateManager.color4f(1.0F, 1.0F, 1.0F, 1.0F);
			this.selected.bindIconTexture();
			GlStateManager.enableBlend();
			blit(x, paneY, 0.0F, 0.0F, 32, 32, 32, 32);
			GlStateManager.disableBlend();
			int lineSpacing = font.field_2000 + 1;
			int imageOffset = 36;
			String name = metadata.getName();
			name = HardcodedUtil.formatFabricModuleName(name);
			String trimmedName = name;
			int maxNameWidth = this.width - (x + imageOffset);
			if (font.method_1727(name) > maxNameWidth) {
				trimmedName = font.method_1714(name, maxNameWidth - font.method_1727("...")) + "...";
			}
			font.method_1729(trimmedName, x + imageOffset, paneY + 1, 0xFFFFFF);
			if (mouseX > x + imageOffset && mouseY > paneY + 1 && mouseY < paneY + 1 + font.field_2000 && mouseX < x + imageOffset + font.method_1727(trimmedName)) {
				setTooltip(class_1074.method_4662("modmenu.modIdToolTip", metadata.getId()));
			}
			if (init || badgeRenderer == null || badgeRenderer.getMetadata() != metadata) {
				badgeRenderer = new BadgeRenderer(x + imageOffset + Objects.requireNonNull(this.minecraft).field_1772.method_1727(trimmedName) + 2, paneY, width - 28, selectedEntry.container, this);
				init = false;
			}
			badgeRenderer.draw(mouseX, mouseY);
			font.method_1729("v" + metadata.getVersion().getFriendlyString(), x + imageOffset, paneY + 2 + lineSpacing, 0x808080);
			String authors;
			List<String> names = new ArrayList<>();

			metadata.getAuthors().stream()
				.filter(Objects::nonNull)
				.map(Person::getName)
				.filter(Objects::nonNull)
				.forEach(names::add);

			if (!names.isEmpty()) {
				if (names.size() > 1) {
					authors = Joiner.on(", ").join(names);
				} else {
					authors = names.get(0);
				}
				RenderUtils.drawWrappedString(class_1074.method_4662("modmenu.authorPrefix", authors), x + imageOffset, paneY + 2 + lineSpacing * 2, paneWidth - imageOffset - 4, 1, 0x808080);
			}
			if (this.tooltip != null) {
				this.renderTooltip(Lists.newArrayList(Splitter.on("\n").split(this.tooltip)), mouseX, mouseY);
			}
		}

	}

	public static void overlayBackground(int x1, int y1, int x2, int y2, int red, int green, int blue, int startAlpha, int endAlpha) {
		class_289 tessellator = class_289.method_1348();
		class_287 buffer = tessellator.method_1349();
		Objects.requireNonNull(class_310.method_1551()).method_1531().method_4618(class_332.BACKGROUND_LOCATION);
		GlStateManager.color4f(1.0F, 1.0F, 1.0F, 1.0F);
		buffer.method_1328(7, class_290.field_1575);
		buffer.method_1315(x1, y2, 0.0D).method_1312(x1 / 32.0D, y2 / 32.0D).method_1323(red, green, blue, endAlpha).method_1344();
		buffer.method_1315(x2, y2, 0.0D).method_1312(x2 / 32.0D, y2 / 32.0D).method_1323(red, green, blue, endAlpha).method_1344();
		buffer.method_1315(x2, y1, 0.0D).method_1312(x2 / 32.0D, y1 / 32.0D).method_1323(red, green, blue, startAlpha).method_1344();
		buffer.method_1315(x1, y1, 0.0D).method_1312(x1 / 32.0D, y1 / 32.0D).method_1323(red, green, blue, startAlpha).method_1344();
		tessellator.method_1350();
	}

	@Override
	public void onClose() {
		super.onClose();
		this.modList.close();
	}

	public void setTooltip(String tooltip) {
		this.tooltip = tooltip;
	}

	public ModListEntry getSelectedEntry() {
		return selected;
	}

	public void updateSelectedEntry(ModListEntry entry) {
		if (entry != null) {
			this.selected = entry;
		}
	}

	public double getScrollPercent() {
		return scrollPercent;
	}

	public void updateScrollPercent(double scrollPercent) {
		this.scrollPercent = scrollPercent;
	}

	public String getSearchInput() {
		return searchBox.method_1882();
	}

	public boolean showingFilterOptions() {
		return filterOptionsShown;
	}
}
