/*
 * Decompiled with CFR 0.152.
 */
package com.github.barnabeepickle.modmenu.config;

import com.github.barnabeepickle.modmenu.ModMenu;
import com.github.barnabeepickle.modmenu.config.ModMenuConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ModMenuConfigManager {
    private static File file;
    private static ModMenuConfig config;

    private static void prepareBiomeConfigFile() {
        if (file != null) {
            return;
        }
        file = new File(FabricLoader.getInstance().getConfigDirectory(), "modmenu.json");
    }

    public static ModMenuConfig initializeConfig() {
        if (config != null) {
            return config;
        }
        config = new ModMenuConfig();
        ModMenuConfigManager.load();
        return config;
    }

    private static void load() {
        ModMenuConfigManager.prepareBiomeConfigFile();
        try {
            BufferedReader br;
            ModMenuConfig parsed;
            if (!file.exists()) {
                ModMenuConfigManager.save();
            }
            if (file.exists() && (parsed = (ModMenuConfig)ModMenu.GSON.fromJson((Reader)(br = new BufferedReader(new FileReader(file))), ModMenuConfig.class)) != null) {
                config = parsed;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't load Mod Menu configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static void save() {
        ModMenuConfigManager.prepareBiomeConfigFile();
        String jsonString = ModMenu.GSON.toJson((Object)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save Mod Menu configuration file");
            e.printStackTrace();
        }
    }

    public static ModMenuConfig getConfig() {
        if (config == null) {
            config = new ModMenuConfig();
        }
        return config;
    }
}

