/*
 * Decompiled with CFR 0.152.
 */
package com.github.barnabeepickle.modmenu.gui;

import com.github.barnabeepickle.modmenu.gui.ModListWidget;
import com.github.barnabeepickle.modmenu.util.BadgeRenderer;
import com.github.barnabeepickle.modmenu.util.HardcodedUtil;
import com.github.barnabeepickle.modmenu.util.RenderUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1062;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModListEntry
extends class_4280.class_4281<ModListEntry> {
    public static final class_2960 UNKNOWN_ICON = new class_2960("textures/misc/unknown_pack.png");
    private static final Logger LOGGER = LogManager.getLogger();
    protected final class_310 client;
    protected final ModContainer container;
    protected final ModMetadata metadata;
    protected final ModListWidget list;
    protected class_2960 iconLocation;

    public ModListEntry(ModContainer container, ModListWidget list) {
        this.container = container;
        this.list = list;
        this.metadata = container.getMetadata();
        this.client = class_310.method_1551();
    }

    public void render(int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        String name;
        rowWidth -= this.getXOffset();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindIconTexture();
        GlStateManager.enableBlend();
        class_332.blit((int)(x += this.getXOffset()), (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        GlStateManager.disableBlend();
        String trimmedName = name = HardcodedUtil.formatFabricModuleName(this.metadata.getName());
        int maxNameWidth = rowWidth - 32 - 3;
        class_327 font = this.client.field_1772;
        if (font.method_1727(name) > maxNameWidth) {
            trimmedName = font.method_1714(name, maxNameWidth - font.method_1727("...")) + "...";
        }
        font.method_1729(trimmedName, (float)(x + 32 + 3), (float)(y + 1), 0xFFFFFF);
        new BadgeRenderer(x + 32 + 3 + font.method_1727(name) + 2, y, x + rowWidth, this.container, this.list.getParent()).draw(mouseX, mouseY);
        String description = this.metadata.getDescription();
        if (description.isEmpty() && HardcodedUtil.getHardcodedDescriptions().containsKey(this.metadata.getId())) {
            description = HardcodedUtil.getHardcodedDescription(this.metadata.getId());
        }
        Objects.requireNonNull(this.client.field_1772);
        RenderUtils.drawWrappedString(description, x + 32 + 3 + 4, y + 9 + 2, rowWidth - 32 - 7, 2, 0x808080);
    }

    private class_1043 createIcon() {
        class_1043 class_10432;
        block11: {
            Path path = this.container.getPath(this.metadata.getIconPath(64 * class_310.method_1551().field_1690.field_1868).orElse("assets/" + this.metadata.getId() + "/icon.png"));
            class_1043 cached = this.list.getCachedModIcon(path);
            if (cached != null) {
                return cached;
            }
            if (!Files.exists(path, new LinkOption[0])) {
                ModContainer modMenu = (ModContainer)FabricLoader.getInstance().getModContainer("modmenu").orElseThrow(IllegalAccessError::new);
                path = HardcodedUtil.getFabricMods().contains(this.metadata.getId()) ? modMenu.getPath("assets/modmenu/fabric_icon.png") : (this.metadata.getId().equals("minecraft") ? modMenu.getPath("assets/modmenu/mc_icon.png") : modMenu.getPath("assets/modmenu/grey_fabric_icon.png"));
            }
            if ((cached = this.list.getCachedModIcon(path)) != null) {
                return cached;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                class_1011 image = class_1011.method_4309((InputStream)Objects.requireNonNull(inputStream));
                Validate.validState((image.method_4323() == image.method_4307() ? 1 : 0) != 0, (String)"Must be square icon", (Object[])new Object[0]);
                class_1043 tex = new class_1043(image);
                this.list.cacheModIcon(path, tex);
                class_10432 = tex;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("Invalid icon for mod {}", (Object)this.container.getMetadata().getName(), (Object)t);
                    return null;
                }
            }
            inputStream.close();
        }
        return class_10432;
    }

    public boolean mouseClicked(double v, double v1, int i) {
        this.list.select(this);
        return true;
    }

    public ModMetadata getMetadata() {
        return this.metadata;
    }

    public void bindIconTexture() {
        if (this.iconLocation == null) {
            this.iconLocation = new class_2960("modmenu", this.metadata.getId() + "_icon");
            class_1043 icon = this.createIcon();
            if (icon != null) {
                this.client.method_1531().method_4616(this.iconLocation, (class_1062)icon);
            } else {
                this.iconLocation = UNKNOWN_ICON;
            }
        }
        this.client.method_1531().method_4618(this.iconLocation);
    }

    public int getXOffset() {
        return 0;
    }
}

