/*
 * Decompiled with CFR 0.152.
 */
package com.github.barnabeepickle.modmenu.gui;

import com.github.barnabeepickle.modmenu.ModMenu;
import com.github.barnabeepickle.modmenu.config.ModMenuConfigManager;
import com.github.barnabeepickle.modmenu.gui.DescriptionListWidget;
import com.github.barnabeepickle.modmenu.gui.ModListEntry;
import com.github.barnabeepickle.modmenu.gui.ModListWidget;
import com.github.barnabeepickle.modmenu.gui.ModMenuTexturedButtonWidget;
import com.github.barnabeepickle.modmenu.util.BadgeRenderer;
import com.github.barnabeepickle.modmenu.util.HardcodedUtil;
import com.github.barnabeepickle.modmenu.util.RenderUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModListScreen
extends class_437 {
    private static final class_2960 FILTERS_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/filters_button.png");
    private static final class_2960 CONFIGURE_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/configure_button.png");
    private static final Logger LOGGER = LogManager.getLogger();
    private final String textTitle;
    private class_342 searchBox;
    private DescriptionListWidget descriptionListWidget;
    private class_437 parent;
    private ModListWidget modList;
    private String tooltip;
    private ModListEntry selected;
    private BadgeRenderer badgeRenderer;
    private double scrollPercent = 0.0;
    private boolean showModCount = false;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    public Set<String> showModChildren = new HashSet<String>();

    public ModListScreen(class_437 previousGui) {
        super((class_2561)new class_2588("modmenu.title", new Object[0]));
        this.parent = previousGui;
        this.textTitle = this.title.method_10863();
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (this.modList.isMouseOver(double_1, double_2)) {
            return this.modList.mouseScrolled(double_1, double_2, double_3);
        }
        if (this.descriptionListWidget.isMouseOver(double_1, double_2)) {
            return this.descriptionListWidget.mouseScrolled(double_1, double_2, double_3);
        }
        return false;
    }

    public void tick() {
        this.searchBox.method_1865();
    }

    protected void init() {
        int filtersX;
        Objects.requireNonNull(this.minecraft).field_1774.method_1462(true);
        this.paneY = 48;
        this.paneWidth = this.width / 2 - 8;
        this.rightPaneX = this.width - this.paneWidth;
        int searchBoxWidth = this.paneWidth - 32 - 22;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - 11;
        this.searchBox = new class_342(this.font, this.searchBoxX, 22, searchBoxWidth, 20, this.searchBox, class_1074.method_4662((String)"selectWorld.search", (Object[])new Object[0]));
        this.searchBox.method_1863(string_1 -> this.modList.filter((String)string_1, false));
        this.modList = new ModListWidget(this.minecraft, this.paneWidth, this.height, this.paneY + 19, this.height - 36, 36, this.searchBox.method_1882(), this.modList, this);
        this.modList.setLeftPos(0);
        Objects.requireNonNull(this.font);
        this.descriptionListWidget = new DescriptionListWidget(this.minecraft, this.paneWidth, this.height, this.paneY + 60, this.height - 36, 9 + 1, this);
        this.descriptionListWidget.setLeftPos(this.rightPaneX);
        ModMenuTexturedButtonWidget configureButton = new ModMenuTexturedButtonWidget(this.width - 24, this.paneY, 20, 20, 0, 0, CONFIGURE_BUTTON_LOCATION, 32, 64, button -> {
            String modid = Objects.requireNonNull(this.selected).getMetadata().getId();
            class_437 screen = ModMenu.getConfigScreen(modid, this);
            if (screen != null) {
                this.minecraft.method_1507(screen);
            } else {
                ModMenu.openConfigScreen(modid);
            }
        }, class_1074.method_4662((String)"modmenu.configure", (Object[])new Object[0])){

            public void render(int mouseX, int mouseY, float delta) {
                String modid;
                this.active = ModListScreen.this.selected != null ? ModMenu.hasFactory(modid = ModListScreen.this.selected.getMetadata().getId()) || ModMenu.hasLegacyConfigScreenTask(modid) : false;
                this.visible = this.active;
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public void renderButton(int int_1, int int_2, float float_1) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.renderButton(int_1, int_2, float_1);
            }
        };
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = urlButtonWidths > 200 ? 200 : urlButtonWidths;
        class_4185 websiteButton = new class_4185(this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, urlButtonWidths > 200 ? 200 : urlButtonWidths, 20, class_1074.method_4662((String)"modmenu.website", (Object[])new Object[0]), button -> {
            ModMetadata metadata = Objects.requireNonNull(this.selected).getMetadata();
            this.minecraft.method_1507((class_437)new class_407(bool -> {
                if (bool) {
                    class_156.method_668().method_670((String)metadata.getContact().get("homepage").get());
                }
                this.minecraft.method_1507((class_437)this);
            }, (String)metadata.getContact().get("homepage").get(), true));
        }){

            public void render(int var1, int var2, float var3) {
                this.visible = ModListScreen.this.selected != null;
                this.active = this.visible && ModListScreen.this.selected.getMetadata().getContact().get("homepage").isPresent();
                super.render(var1, var2, var3);
            }
        };
        class_4185 issuesButton = new class_4185(this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, urlButtonWidths > 200 ? 200 : urlButtonWidths, 20, class_1074.method_4662((String)"modmenu.issues", (Object[])new Object[0]), button -> {
            ModMetadata metadata = Objects.requireNonNull(this.selected).getMetadata();
            this.minecraft.method_1507((class_437)new class_407(bool -> {
                if (bool) {
                    class_156.method_668().method_670((String)metadata.getContact().get("issues").get());
                }
                this.minecraft.method_1507((class_437)this);
            }, (String)metadata.getContact().get("issues").get(), true));
        }){

            public void render(int var1, int var2, float var3) {
                this.visible = ModListScreen.this.selected != null;
                this.active = this.visible && ModListScreen.this.selected.getMetadata().getContact().get("issues").isPresent();
                super.render(var1, var2, var3);
            }
        };
        this.children.add(this.searchBox);
        this.addButton((class_339)new ModMenuTexturedButtonWidget(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, FILTERS_BUTTON_LOCATION, 32, 64, button -> {
            this.filterOptionsShown = !this.filterOptionsShown;
        }){

            public void render(int int_1, int int_2, float float_1) {
                super.render(int_1, int_2, float_1);
                if (this.isHovered()) {
                    ModListScreen.this.setTooltip(class_1074.method_4662((String)"modmenu.toggleFilterOptions", (Object[])new Object[0]));
                }
            }
        });
        String showLibrariesText = class_1074.method_4662((String)"modmenu.showLibraries", (Object[])new Object[]{class_1074.method_4662((String)("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries()), (Object[])new Object[0])});
        String sortingText = class_1074.method_4662((String)"modmenu.sorting", (Object[])new Object[]{class_1074.method_4662((String)ModMenuConfigManager.getConfig().getSorting().getTranslationKey(), (Object[])new Object[0])});
        int showLibrariesWidth = this.font.method_1727(showLibrariesText) + 20;
        int sortingWidth = this.font.method_1727(sortingText) + 20;
        int filtersWidth = showLibrariesWidth + sortingWidth + 2;
        if (filtersWidth + this.font.method_1727(class_1074.method_4662((String)"modmenu.showingMods", (Object[])new Object[]{NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size())})) + 20 >= this.searchBoxX + searchBoxWidth + 22) {
            filtersX = this.paneWidth / 2 - filtersWidth / 2;
            this.showModCount = false;
        } else {
            filtersX = this.searchBoxX + searchBoxWidth + 22 - filtersWidth + 1;
            this.showModCount = true;
        }
        this.addButton((class_339)new class_4185(filtersX, 45, sortingWidth, 20, sortingText, button -> {
            ModMenuConfigManager.getConfig().toggleSortMode();
            this.modList.reloadFilters();
        }){

            public void render(int mouseX, int mouseY, float delta) {
                this.visible = ModListScreen.this.filterOptionsShown;
                this.setMessage(class_1074.method_4662((String)"modmenu.sorting", (Object[])new Object[]{class_1074.method_4662((String)ModMenuConfigManager.getConfig().getSorting().getTranslationKey(), (Object[])new Object[0])}));
                super.render(mouseX, mouseY, delta);
            }
        });
        this.addButton((class_339)new class_4185(filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, class_1074.method_4662((String)"modmenu.showLibraries", (Object[])new Object[]{class_1074.method_4662((String)("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries()), (Object[])new Object[0])}), button -> {
            ModMenuConfigManager.getConfig().toggleShowLibraries();
            this.modList.reloadFilters();
        }){

            public void render(int mouseX, int mouseY, float delta) {
                this.visible = ModListScreen.this.filterOptionsShown;
                this.setMessage(class_1074.method_4662((String)"modmenu.showLibraries", (Object[])new Object[]{class_1074.method_4662((String)("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries()), (Object[])new Object[0])}));
                super.render(mouseX, mouseY, delta);
            }
        });
        this.children.add(this.modList);
        this.addButton((class_339)configureButton);
        this.addButton((class_339)websiteButton);
        this.addButton((class_339)issuesButton);
        this.children.add(this.descriptionListWidget);
        this.addButton((class_339)new class_4185(this.width / 2 - 154, this.height - 28, 150, 20, class_1074.method_4662((String)"modmenu.modsFolder", (Object[])new Object[0]), button -> class_156.method_668().method_672(new File(FabricLoader.getInstance().getGameDirectory(), "mods"))));
        this.addButton((class_339)new class_4185(this.width / 2 + 4, this.height - 28, 150, 20, class_1074.method_4662((String)"gui.done", (Object[])new Object[0]), button -> this.minecraft.method_1507(this.parent)));
        this.method_20085((class_364)this.searchBox);
        this.init = true;
    }

    public ModListWidget getModList() {
        return this.modList;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        return super.keyPressed(int_1, int_2, int_3) || this.searchBox.keyPressed(int_1, int_2, int_3);
    }

    public boolean charTyped(char char_1, int int_1) {
        return this.searchBox.charTyped(char_1, int_1);
    }

    public void render(int mouseX, int mouseY, float delta) {
        ModListScreen.overlayBackground(this.paneWidth, 0, this.rightPaneX, this.height, 64, 64, 64, 255, 255);
        this.tooltip = null;
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.render(mouseX, mouseY, delta);
        }
        this.modList.render(mouseX, mouseY, delta);
        this.searchBox.render(mouseX, mouseY, delta);
        GlStateManager.disableBlend();
        this.drawCenteredString(this.font, this.textTitle, this.modList.getWidth() / 2, 8, 0xFFFFFF);
        super.render(mouseX, mouseY, delta);
        if (this.showModCount || !this.filterOptionsShown) {
            this.font.method_1729(class_1074.method_4662((String)"modmenu.showingMods", (Object[])new Object[]{NumberFormat.getInstance().format(this.modList.getDisplayedCount()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size())}), (float)this.searchBoxX, 52.0f, 0xFFFFFF);
        }
        if (selectedEntry != null) {
            ModMetadata metadata = selectedEntry.getMetadata();
            int x = this.rightPaneX;
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.selected.bindIconTexture();
            GlStateManager.enableBlend();
            ModListScreen.blit((int)x, (int)this.paneY, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            GlStateManager.disableBlend();
            Objects.requireNonNull(this.font);
            int lineSpacing = 9 + 1;
            int imageOffset = 36;
            String name = metadata.getName();
            String trimmedName = name = HardcodedUtil.formatFabricModuleName(name);
            int maxNameWidth = this.width - (x + imageOffset);
            if (this.font.method_1727(name) > maxNameWidth) {
                trimmedName = this.font.method_1714(name, maxNameWidth - this.font.method_1727("...")) + "...";
            }
            this.font.method_1729(trimmedName, (float)(x + imageOffset), (float)(this.paneY + 1), 0xFFFFFF);
            if (mouseX > x + imageOffset && mouseY > this.paneY + 1) {
                Objects.requireNonNull(this.font);
                if (mouseY < this.paneY + 1 + 9 && mouseX < x + imageOffset + this.font.method_1727(trimmedName)) {
                    this.setTooltip(class_1074.method_4662((String)"modmenu.modIdToolTip", (Object[])new Object[]{metadata.getId()}));
                }
            }
            if (this.init || this.badgeRenderer == null || this.badgeRenderer.getMetadata() != metadata) {
                this.badgeRenderer = new BadgeRenderer(x + imageOffset + Objects.requireNonNull(this.minecraft).field_1772.method_1727(trimmedName) + 2, this.paneY, this.width - 28, selectedEntry.container, this);
                this.init = false;
            }
            this.badgeRenderer.draw(mouseX, mouseY);
            this.font.method_1729("v" + metadata.getVersion().getFriendlyString(), (float)(x + imageOffset), (float)(this.paneY + 2 + lineSpacing), 0x808080);
            ArrayList names = new ArrayList();
            metadata.getAuthors().stream().filter(Objects::nonNull).map(Person::getName).filter(Objects::nonNull).forEach(names::add);
            if (!names.isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : (String)names.get(0);
                RenderUtils.drawWrappedString(class_1074.method_4662((String)"modmenu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, this.paneY + 2 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
            if (this.tooltip != null) {
                this.renderTooltip(Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)this.tooltip)), mouseX, mouseY);
            }
        }
    }

    public static void overlayBackground(int x1, int y1, int x2, int y2, int red, int green, int blue, int startAlpha, int endAlpha) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        Objects.requireNonNull(class_310.method_1551()).method_1531().method_4618(class_332.BACKGROUND_LOCATION);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_1315((double)x1, (double)y2, 0.0).method_1312((double)x1 / 32.0, (double)y2 / 32.0).method_1323(red, green, blue, endAlpha).method_1344();
        buffer.method_1315((double)x2, (double)y2, 0.0).method_1312((double)x2 / 32.0, (double)y2 / 32.0).method_1323(red, green, blue, endAlpha).method_1344();
        buffer.method_1315((double)x2, (double)y1, 0.0).method_1312((double)x2 / 32.0, (double)y1 / 32.0).method_1323(red, green, blue, startAlpha).method_1344();
        buffer.method_1315((double)x1, (double)y1, 0.0).method_1312((double)x1 / 32.0, (double)y1 / 32.0).method_1323(red, green, blue, startAlpha).method_1344();
        tessellator.method_1350();
    }

    public void onClose() {
        super.onClose();
        this.modList.close();
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
        }
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.method_1882();
    }

    public boolean showingFilterOptions() {
        return this.filterOptionsShown;
    }
}

