/*
 * Decompiled with CFR 0.152.
 */
package com.github.barnabeepickle.modmenu.gui;

import com.github.barnabeepickle.modmenu.ModMenu;
import com.github.barnabeepickle.modmenu.util.HardcodedUtil;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;

public class ModListSearch {
    public static boolean validSearchQuery(String query) {
        return query != null && !query.isEmpty();
    }

    public static List<ModContainer> search(String query, List<ModContainer> candidates) {
        if (!ModListSearch.validSearchQuery(query)) {
            return candidates;
        }
        return candidates.stream().filter(modContainer -> ModListSearch.passesFilters(modContainer, query)).collect(Collectors.toList());
    }

    private static boolean passesFilters(ModContainer container, String query) {
        ModMetadata metadata = container.getMetadata();
        String modId = metadata.getId();
        return HardcodedUtil.formatFabricModuleName(metadata.getName()).toLowerCase(Locale.ROOT).contains(query) || modId.toLowerCase(Locale.ROOT).contains(query) || ModListSearch.authorMatches(container, query) || ModMenu.LIBRARY_MODS.contains(modId) && "api library".contains(query) || "clientside".contains(query) && ModMenu.CLIENTSIDE_MODS.contains(modId) || "configurations configs configures configurable".contains(query) && ModMenu.hasFactory(modId);
    }

    private static boolean authorMatches(ModContainer modContainer, String query) {
        return modContainer.getMetadata().getAuthors().stream().filter(Objects::nonNull).map(Person::getName).filter(Objects::nonNull).map(s -> s.toLowerCase(Locale.ROOT)).anyMatch(s -> s.contains(query));
    }
}

